/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.ObjectOutputStream;

public final class AES
extends BlockCipher {
    private int B;
    private static final int[] C;
    private static final int[] D;
    private int E;
    private int[] F;
    private int G;
    private static final int[] H;
    private int I;
    private int J;
    private AlgorithmIdentifier K = null;
    private int[] L;
    private int M;
    private int N;
    private static final int[] O;
    private static final int[] P;
    private int[] Q;
    private static final int[] R;
    private int S;
    private static final int[] T;
    private int U;
    private static final int[] V;
    private byte[] W;
    private int X;
    private int Y;
    private static final int[] Z;
    private static int[][] ba;
    private static final int[] bb;
    private static final int[] bc;
    private int bd;
    private static final int[] be;
    private int[] bf;
    private int bg;
    private int bh;
    private ObjectOutputStream bi = null;
    private int bj;
    private static final int[] bk;
    private static final int[] bl;
    private int bm;
    private static final int[] bn;
    private int bo;
    private byte[] bp;
    private int bq;
    private int br;

    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (this.bo != 4) {
            if (this.bo == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.bo == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocksize " + this.bo);
        }
        this.l(byArray, n, byArray2, n2);
    }

    private void a(int n, int n2, int n3) {
        this.r(n, n2);
        this.e(n3);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        AlgorithmIdentifier algorithmIdentifier2 = this.getAlgID();
        if (algorithmIdentifier2.getOID().equals(algorithmIdentifier.getOID())) {
            byte[] byArray = CryptoUtils.getIV(algorithmIdentifier2);
            byte[] byArray2 = CryptoUtils.getIV(algorithmIdentifier);
            if (byArray == null && byArray2 == null) {
                if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
                    this.x(null);
                }
            } else if (byArray == null || byArray2 == null) {
                this.A(algorithmIdentifier);
            } else if (!Utils.areEqual(byArray, byArray2)) {
                this.A(algorithmIdentifier);
            }
        } else {
            this.A(algorithmIdentifier);
        }
        this.releaseOp();
        this.a();
    }

    private static void d() {
        int n = 0;
        while (n < 256) {
            byte by = (byte)D[n];
            byte by2 = (byte)AES.o(D[n], 2);
            byte by3 = (byte)AES.o(D[n], 3);
            AES.bk[n] = Utils.bytesToWord(by2, by, by, by3);
            AES.bb[n] = Utils.bytesToWord(by3, by2, by, by);
            AES.T[n] = Utils.bytesToWord(by, by3, by2, by);
            AES.O[n] = Utils.bytesToWord(by, by, by3, by2);
            ++n;
        }
    }

    private void e(int n) {
        if (n == 0) {
            this.mode = 0;
        } else if (n == 1) {
            this.mode = 1;
            this.x(null);
        } else {
            throw new IllegalArgumentException("invalid cipher mode " + n + " for AES");
        }
    }

    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        super.setKey(symmetricKey);
        this.t((SymmetricKey)this.key);
        this.releaseOp();
        this.a();
    }

    private static void f() {
        int n = 0;
        while (n < 256) {
            byte by = (byte)AES.o(R[n], 14);
            byte by2 = (byte)AES.o(R[n], 9);
            byte by3 = (byte)AES.o(R[n], 13);
            byte by4 = (byte)AES.o(R[n], 11);
            AES.H[n] = Utils.bytesToWord(by, by2, by3, by4);
            AES.C[n] = Utils.bytesToWord(by4, by, by2, by3);
            AES.bn[n] = Utils.bytesToWord(by3, by4, by, by2);
            AES.be[n] = Utils.bytesToWord(by2, by3, by4, by);
            ++n;
        }
    }

    private static void g() {
        int n = 1;
        int n2 = 2;
        while (n2 <= 30) {
            AES.Z[n2 - 1] = Utils.bytesToWord((byte)n, 0, 0, 0);
            n = AES.o(2, n & 0xFF);
            ++n2;
        }
    }

    private static int h(int n) {
        byte[] byArray = Utils.wordToBytes(n);
        return Utils.bytesToWord(byArray[1], byArray[2], byArray[3], byArray[0]);
    }

    private static int i(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 <= AES.z(n2)) {
            if ((n2 >> n4 & 1) != 0) {
                n3 ^= n << n4;
            }
            ++n4;
        }
        return n3;
    }

    public String toString() {
        return this.algName();
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.j(algorithmIdentifier);
        this.q(algorithmIdentifier, symmetricKey);
        this.rbs = null;
        this.setIV(null);
        this.A(algorithmIdentifier);
        super.setKey(symmetricKey);
        this.t((SymmetricKey)this.key);
        this.releaseOp();
        this.paddingID = iD;
    }

    public void setDecryptionKey(Key key) throws InvalidKeyException {
        super.setDecryptionKey(key);
        this.t((SymmetricKey)this.key);
        this.releaseOp();
        this.a();
    }

    public AES() {
        this.a(4, 4, 0);
    }

    public void setEncryptionKey(Key key) throws InvalidKeyException {
        super.setEncryptionKey(key);
        this.t((SymmetricKey)this.key);
        this.releaseOp();
        this.a();
    }

    private void j(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            return;
        }
        throw new AlgorithmIdentifierException("Unknown (or unsupported) AES algorithm identifier " + algorithmIdentifier);
    }

    public AlgorithmIdentifier getAlgID() {
        AlgorithmIdentifier algorithmIdentifier = this.bo == 4 ? (this.mode == 0 ? (this.bm == 4 ? AlgID.aes128_ECB : (this.bm == 6 ? AlgID.aes192_ECB : (this.bm == 8 ? AlgID.aes256_ECB : null))) : (this.mode == 1 ? (this.bm == 4 ? new CBCAlgorithmIdentifier(AlgID.aes128_CBC, this.getIV()) : (this.bm == 6 ? new CBCAlgorithmIdentifier(AlgID.aes192_CBC, this.getIV()) : (this.bm == 8 ? new CBCAlgorithmIdentifier(AlgID.aes256_CBC, this.getIV()) : null))) : null)) : null;
        return algorithmIdentifier;
    }

    public String algName() {
        return "AES-" + this.bm * 32;
    }

    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        if (this.bo != 4) {
            if (this.bo == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.bo == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocking parameter " + this.bo);
        }
        this.v(byArray, n, byArray2, n2);
    }

    private static int k(int n, int n2) {
        int n3;
        int n4 = 0;
        while ((n3 = AES.z(n) - AES.z(n2)) >= 0) {
            n ^= n2 << n3;
            n4 ^= 1 << n3;
        }
        return n4;
    }

    public void erase() {
        super.erase();
        this.J = 0;
        this.bm = 0;
        this.bo = 0;
        this.blockSize = 0;
        Utils.setArray(this.F, 0);
        Utils.setArray(this.Q, 0);
        Utils.setArray(this.bp, (byte)0);
        Utils.setArray(this.W, (byte)0);
        this.Y = 0;
        this.bj = 0;
        this.B = 0;
        this.M = 0;
        this.U = 0;
        this.bg = 0;
        this.bq = 0;
        this.G = 0;
        this.E = 0;
        this.N = 0;
        this.X = 0;
        this.bh = 0;
        this.br = 0;
        this.I = 0;
        this.S = 0;
        this.bd = 0;
        if (this.bi != null) {
            this.bi = null;
        }
    }

    private void l(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.G = Utils.bytesToWord(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) ^ this.Q[4 * this.J];
        this.bq = Utils.bytesToWord(byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]) ^ this.Q[4 * this.J + 1];
        this.bg = Utils.bytesToWord(byArray[n + 8], byArray[n + 9], byArray[n + 10], byArray[n + 11]) ^ this.Q[4 * this.J + 2];
        this.U = Utils.bytesToWord(byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]) ^ this.Q[4 * this.J + 3];
        int n3 = this.J - 1;
        while (n3 > 0) {
            this.bd = this.G;
            this.S = this.bq;
            this.I = this.bg;
            this.br = this.U;
            this.G = H[this.bd >>> 24 & 0xFF] ^ C[this.br >>> 16 & 0xFF] ^ bn[this.I >>> 8 & 0xFF] ^ be[this.S & 0xFF] ^ this.Q[n3 * 4];
            this.bq = H[this.S >>> 24 & 0xFF] ^ C[this.bd >>> 16 & 0xFF] ^ bn[this.br >>> 8 & 0xFF] ^ be[this.I & 0xFF] ^ this.Q[n3 * 4 + 1];
            this.bg = H[this.I >>> 24 & 0xFF] ^ C[this.S >>> 16 & 0xFF] ^ bn[this.bd >>> 8 & 0xFF] ^ be[this.br & 0xFF] ^ this.Q[n3 * 4 + 2];
            this.U = H[this.br >>> 24 & 0xFF] ^ C[this.I >>> 16 & 0xFF] ^ bn[this.S >>> 8 & 0xFF] ^ be[this.bd & 0xFF] ^ this.Q[n3 * 4 + 3];
            if (this.bi != null) {
                try {
                    this.bi.writeObject(new int[]{this.G, this.bq, this.bg, this.U});
                }
                catch (IOException iOException) {
                    throw new RuntimeException("iv trace mode broken:  " + iOException);
                }
            }
            --n3;
        }
        byArray2[n2] = (byte)(R[this.G >>> 24 & 0xFF] ^ this.W[0]);
        byArray2[n2 + 1] = (byte)(R[this.U >>> 16 & 0xFF] ^ this.W[1]);
        byArray2[n2 + 2] = (byte)(R[this.bg >>> 8 & 0xFF] ^ this.W[2]);
        byArray2[n2 + 3] = (byte)(R[this.bq & 0xFF] ^ this.W[3]);
        byArray2[n2 + 4] = (byte)(R[this.bq >>> 24 & 0xFF] ^ this.W[4]);
        byArray2[n2 + 5] = (byte)(R[this.G >>> 16 & 0xFF] ^ this.W[5]);
        byArray2[n2 + 6] = (byte)(R[this.U >>> 8 & 0xFF] ^ this.W[6]);
        byArray2[n2 + 7] = (byte)(R[this.bg & 0xFF] ^ this.W[7]);
        byArray2[n2 + 8] = (byte)(R[this.bg >>> 24 & 0xFF] ^ this.W[8]);
        byArray2[n2 + 9] = (byte)(R[this.bq >>> 16 & 0xFF] ^ this.W[9]);
        byArray2[n2 + 10] = (byte)(R[this.G >>> 8 & 0xFF] ^ this.W[10]);
        byArray2[n2 + 11] = (byte)(R[this.U & 0xFF] ^ this.W[11]);
        byArray2[n2 + 12] = (byte)(R[this.U >>> 24 & 0xFF] ^ this.W[12]);
        byArray2[n2 + 13] = (byte)(R[this.bg >>> 16 & 0xFF] ^ this.W[13]);
        byArray2[n2 + 14] = (byte)(R[this.bq >>> 8 & 0xFF] ^ this.W[14]);
        byArray2[n2 + 15] = (byte)(R[this.G & 0xFF] ^ this.W[15]);
    }

    private static void m() {
        int n = 0;
        while (n < 256) {
            int n2 = AES.s(n);
            AES.D[n] = (n2 & 1) * 31 ^ (n2 >> 1 & 1) * 62 ^ (n2 >> 2 & 1) * 124 ^ (n2 >> 3 & 1) * 248 ^ (n2 >> 4 & 1) * 241 ^ (n2 >> 5 & 1) * 227 ^ (n2 >> 6 & 1) * 199 ^ (n2 >> 7 & 1) * 143 ^ 0x63;
            AES.R[AES.D[n]] = n;
            ++n;
        }
    }

    private static void n() {
        int n = 0;
        while (n < 256) {
            byte by = (byte)AES.o(n, 14);
            byte by2 = (byte)AES.o(n, 9);
            byte by3 = (byte)AES.o(n, 13);
            byte by4 = (byte)AES.o(n, 11);
            AES.bl[n] = Utils.bytesToWord(by, by2, by3, by4);
            AES.bc[n] = Utils.bytesToWord(by4, by, by2, by3);
            AES.V[n] = Utils.bytesToWord(by3, by4, by, by2);
            AES.P[n] = Utils.bytesToWord(by2, by3, by4, by);
            ++n;
        }
    }

    private static int o(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < 8) {
            if ((n2 >> n4 & 1) != 0) {
                n3 ^= ba[n][n4];
            }
            ++n4;
        }
        return n3;
    }

    public AES(int n, int n2) {
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalArgumentException("unknown keysize " + n);
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("unknown blockmode " + n2);
        }
        if (n2 == 0) {
            this.a(4, n / 32, 0);
        } else {
            this.a(4, n / 32, 1);
        }
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        this.j(algorithmIdentifier);
        this.q(algorithmIdentifier, (SymmetricKey)key);
        this.rbs = null;
        try {
            this.setIV(null);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        this.A(algorithmIdentifier);
        super.setKey((SymmetricKey)key);
        this.t((SymmetricKey)this.key);
        this.releaseOp();
        this.paddingID = Padding.NONE;
    }

    void p(ObjectOutputStream objectOutputStream) {
        this.bi = objectOutputStream;
    }

    private void q(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws InvalidKeyException {
        byte[] byArray = symmetricKey.getBytes();
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID()) && byArray.length == 32 || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID()) && byArray.length == 32) {
            return;
        }
        throw new InvalidKeyException("Key size did not match size specified in the AlgorithmIdentifier");
    }

    static {
        ba = new int[256][8];
        Z = new int[30];
        D = new int[256];
        R = new int[256];
        bk = new int[256];
        bb = new int[256];
        T = new int[256];
        O = new int[256];
        H = new int[256];
        C = new int[256];
        bn = new int[256];
        be = new int[256];
        bl = new int[256];
        bc = new int[256];
        V = new int[256];
        P = new int[256];
        AES.y();
    }

    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        if (this.bo != 4) {
            if (this.bo == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.bo == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocksize " + this.bo);
        }
        this.l(byArray, n, byArray2, n2);
    }

    private void r(int n, int n2) {
        if (n != 4 && n != 6 && n != 8) {
            throw new IllegalArgumentException("invalid Nb value " + n);
        }
        if (n2 != 4 && n2 != 6 && n2 != 8) {
            throw new IllegalArgumentException("invalid Nk value " + n2);
        }
        this.bo = n;
        this.blockSize = 4 * n;
        this.bm = n2;
        int n3 = n == 8 || n2 == 8 ? 14 : (this.J = n == 4 && n2 == 4 ? 10 : 12);
        if (this.F != null) {
            Utils.setArray(this.F, 0);
        }
        if (this.Q != null) {
            Utils.setArray(this.Q, 0);
        }
        if (this.bp != null) {
            Utils.setArray(this.bp, (byte)0);
        }
        if (this.W != null) {
            Utils.setArray(this.W, (byte)0);
        }
        this.F = new int[(this.J + 1) * n];
        this.Q = new int[(this.J + 1) * n];
        this.bp = new byte[4 * n];
        this.W = new byte[4 * n];
    }

    private static int s(int n) {
        int n2 = 283;
        if (n == 0) {
            return 0;
        }
        int n3 = 1;
        int n4 = 0;
        while (n != 0) {
            int n5 = AES.k(n2, n);
            int n6 = n2 ^ AES.i(n, n5);
            int n7 = n4 ^ AES.i(n3, n5);
            n2 = n;
            n = n6;
            n4 = n3;
            n3 = n7;
        }
        return n4;
    }

    public AES(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.setAlgID(algorithmIdentifier);
    }

    public AES(int n) {
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalArgumentException("unknown keysize " + n);
        }
        this.a(4, n / 32, 0);
    }

    public int getKeySize() {
        return 4 * this.bm;
    }

    private void t(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n;
        byte[] byArray = symmetricKey.getBytes();
        int n2 = byArray.length * 8;
        int n3 = n2 == 128 ? 4 : (n2 == 192 ? 6 : (n = n2 == 256 ? 8 : -1));
        if (n < 0) {
            throw new InvalidKeyException("invalid keysize " + n2);
        }
        if (n != this.bm) {
            this.r(this.bo, n);
        }
        int n4 = 0;
        while (n4 < this.bo * (this.J + 1)) {
            if (n4 < this.bm) {
                this.F[n4] = Utils.bytesToWord(byArray[4 * n4], byArray[4 * n4 + 1], byArray[4 * n4 + 2], byArray[4 * n4 + 3]);
            } else {
                int n5 = this.F[n4 - 1];
                if (n4 % this.bm == 0) {
                    byte by = (byte)(n5 >> 24);
                    byte by2 = (byte)(n5 >> 16);
                    byte by3 = (byte)(n5 >> 8);
                    byte by4 = (byte)n5;
                    n5 = AES.w(by & 0xFF | (by4 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 24) ^ Z[n4 / this.bm];
                } else if (this.bm > 6 && n4 % this.bm == 4) {
                    n5 = AES.w(n5);
                }
                this.F[n4] = this.F[n4 - this.bm] ^ n5;
            }
            if (n4 < this.bo || n4 >= this.bo * this.J) {
                this.Q[n4] = this.F[n4];
            } else {
                byte[] byArray2 = Utils.wordToBytes(this.F[n4]);
                this.Q[n4] = bl[byArray2[0] & 0xFF] ^ bc[byArray2[1] & 0xFF] ^ V[byArray2[2] & 0xFF] ^ P[byArray2[3] & 0xFF];
            }
            ++n4;
        }
        Utils.wordsToBytes(this.F, this.J * this.bo, this.bp, 0, this.bo);
        Utils.wordsToBytes(this.Q, 0, this.W, 0, this.bo);
    }

    private static void u() {
        int n = 0;
        while (n < 256) {
            AES.ba[n][0] = n;
            int n2 = 1;
            while (n2 < 8) {
                int n3 = ba[n][n2 - 1];
                AES.ba[n][n2] = (n3 >> 7 & 1) == 0 ? n3 << 1 : (n3 << 1 ^ 0x1B) & 0xFF;
                ++n2;
            }
            ++n;
        }
    }

    private void v(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.G = Utils.bytesToWord(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) ^ this.F[0];
        this.bq = Utils.bytesToWord(byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]) ^ this.F[1];
        this.bg = Utils.bytesToWord(byArray[n + 8], byArray[n + 9], byArray[n + 10], byArray[n + 11]) ^ this.F[2];
        this.U = Utils.bytesToWord(byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]) ^ this.F[3];
        int n3 = 1;
        while (n3 < this.J) {
            int n4 = this.G;
            int n5 = this.bq;
            int n6 = this.bg;
            int n7 = this.U;
            this.G = bk[n4 >>> 24 & 0xFF] ^ bb[n5 >>> 16 & 0xFF] ^ T[n6 >>> 8 & 0xFF] ^ O[n7 & 0xFF] ^ this.F[n3 * 4];
            this.bq = bk[n5 >>> 24 & 0xFF] ^ bb[n6 >>> 16 & 0xFF] ^ T[n7 >>> 8 & 0xFF] ^ O[n4 & 0xFF] ^ this.F[n3 * 4 + 1];
            this.bg = bk[n6 >>> 24 & 0xFF] ^ bb[n7 >>> 16 & 0xFF] ^ T[n4 >>> 8 & 0xFF] ^ O[n5 & 0xFF] ^ this.F[n3 * 4 + 2];
            this.U = bk[n7 >>> 24 & 0xFF] ^ bb[n4 >>> 16 & 0xFF] ^ T[n5 >>> 8 & 0xFF] ^ O[n6 & 0xFF] ^ this.F[n3 * 4 + 3];
            if (this.bi != null) {
                try {
                    this.bi.writeObject(new int[]{this.G, this.bq, this.bg, this.U});
                }
                catch (IOException iOException) {
                    throw new RuntimeException("iv trace mode broken:  " + iOException);
                }
            }
            ++n3;
        }
        byArray2[n2] = (byte)(D[this.G >>> 24 & 0xFF] ^ this.bp[0]);
        byArray2[n2 + 1] = (byte)(D[this.bq >>> 16 & 0xFF] ^ this.bp[1]);
        byArray2[n2 + 2] = (byte)(D[this.bg >>> 8 & 0xFF] ^ this.bp[2]);
        byArray2[n2 + 3] = (byte)(D[this.U & 0xFF] ^ this.bp[3]);
        byArray2[n2 + 4] = (byte)(D[this.bq >>> 24 & 0xFF] ^ this.bp[4]);
        byArray2[n2 + 5] = (byte)(D[this.bg >>> 16 & 0xFF] ^ this.bp[5]);
        byArray2[n2 + 6] = (byte)(D[this.U >>> 8 & 0xFF] ^ this.bp[6]);
        byArray2[n2 + 7] = (byte)(D[this.G & 0xFF] ^ this.bp[7]);
        byArray2[n2 + 8] = (byte)(D[this.bg >>> 24 & 0xFF] ^ this.bp[8]);
        byArray2[n2 + 9] = (byte)(D[this.U >>> 16 & 0xFF] ^ this.bp[9]);
        byArray2[n2 + 10] = (byte)(D[this.G >>> 8 & 0xFF] ^ this.bp[10]);
        byArray2[n2 + 11] = (byte)(D[this.bq & 0xFF] ^ this.bp[11]);
        byArray2[n2 + 12] = (byte)(D[this.U >>> 24 & 0xFF] ^ this.bp[12]);
        byArray2[n2 + 13] = (byte)(D[this.G >>> 16 & 0xFF] ^ this.bp[13]);
        byArray2[n2 + 14] = (byte)(D[this.bq >>> 8 & 0xFF] ^ this.bp[14]);
        byArray2[n2 + 15] = (byte)(D[this.bg & 0xFF] ^ this.bp[15]);
    }

    private static int w(int n) {
        byte by = (byte)(n >> 24);
        byte by2 = (byte)(n >> 16);
        byte by3 = (byte)(n >> 8);
        byte by4 = (byte)n;
        by = (byte)D[by & 0xFF];
        by2 = (byte)D[by2 & 0xFF];
        by3 = (byte)D[by3 & 0xFF];
        by4 = (byte)D[by4 & 0xFF];
        return by4 & 0xFF | (by3 & 0xFF) << 8 | (by2 & 0xFF) << 16 | (by & 0xFF) << 24;
    }

    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (this.bo != 4) {
            if (this.bo == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.bo == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocking parameter " + this.bo);
        }
        this.v(byArray, n, byArray2, n2);
    }

    private void x(byte[] byArray) {
        byte[] byArray2 = this.getIV();
        this.mode = 1;
        String string = "couldn't reset cipher IV";
        if (byArray != null) {
            string = "couldn't set IV provided with algID";
        } else if (byArray2 != null) {
            byArray = byArray2;
            string = "couldn't reset cipher IV";
        } else if (byArray2 == null) {
            byArray = this.b().randomBytes(new byte[this.blockSize]);
            string = "couldn't randomize cipher IV";
        }
        try {
            this.setIV(byArray);
        }
        catch (CipherException cipherException) {
            throw new IllegalStateException(string + ":  " + cipherException.toString());
        }
        this.paddingID = Padding.PKCS5;
    }

    public void setMode(int n) {
        if (n != this.getMode()) {
            if (n == 0 || n == 1) {
                this.e(n);
            } else {
                throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
            }
        }
        this.releaseOp();
        this.a();
    }

    private static void y() {
        AES.u();
        AES.g();
        AES.m();
        AES.d();
        AES.f();
        AES.n();
    }

    private static int z(int n) {
        int n2 = 0;
        while (n >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    private void A(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID())) {
            this.a(4, 4, 0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID())) {
            this.a(4, 6, 0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID())) {
            this.a(4, 8, 0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID())) {
            this.r(4, 4);
            this.x(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID())) {
            this.r(4, 6);
            this.x(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            this.r(4, 8);
            this.x(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown (or unsupported) AES algorithm identifier " + algorithmIdentifier);
        }
    }
}

