/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class KeyUsageExtension
extends X509Extension {
    public static final int ENCIPHER_ONLY = 7;
    public static final int KEY_ENCIPHERMENT = 2;
    private boolean[] d = new boolean[f.length];
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int NON_REPUDIATION = 1;
    public static final int DIGITAL_SIGNATURE = 0;
    private static final String[] e = new String[]{"DIGITAL SIGNATURE", "NON REPUDIATION", "KEY ENCIPHERMENT", "DATA ENCIPHERMENT", "KEY AGREEMENT", "KEY CERT_SIGN", "CRL SIGN", "ENCIPHER ONLY", "DECIPHER ONLY"};
    public static final int KEY_AGREEMENT = 4;
    public static final int DECIPHER_ONLY = 8;
    public static final int DATA_ENCIPHERMENT = 3;
    private static final int[] f = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final ASN1ObjectID g = PKIX.id_ce_keyUsage;

    public void setUsageFlags(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            this.c(nArray[n]);
            ++n;
        }
        this.setValue(this.a());
    }

    public KeyUsageExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public KeyUsageExtension(int[] nArray, boolean bl) {
        super(g, bl);
        this.setUsageFlags(nArray);
    }

    public boolean hasUsageFlag(int n) {
        if (!this.isDecoded) {
            this.b();
        }
        return this.d != null && n < this.d.length ? this.d[n] : false;
    }

    public void setUsageFlag(int n) {
        this.c(n);
        this.setValue(this.a());
    }

    public KeyUsageExtension() {
        super(g);
    }

    public KeyUsageExtension(boolean bl) {
        super(g, bl);
        this.setValue(this.a());
    }

    private byte[] a() {
        ASN1BitString aSN1BitString = new ASN1BitString(this.d.length);
        int n = 0;
        while (n < this.d.length) {
            if (this.d[n]) {
                aSN1BitString.setBit(n);
            }
            ++n;
        }
        byte[] byArray = Utils.toBytes(aSN1BitString);
        this.isDecoded = true;
        return byArray;
    }

    private void b() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString aSN1BitString = new ASN1BitString(unsyncByteArrayInputStream);
            this.d = new boolean[aSN1BitString.bitLength()];
            int n = 0;
            try {
                while (n < this.d.length) {
                    this.d[n] = aSN1BitString.testBit(n);
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown key usage flag: " + n);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public void clearUsageFlag(int n) {
        if (this.d != null && n < this.d.length) {
            this.d[n] = false;
        }
        this.setValue(this.a());
    }

    public String toString() {
        if (!this.isDecoded) {
            this.b();
        }
        StringBuffer stringBuffer = new StringBuffer("keyUsageExtension {oid = " + g.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl = false;
        int n = 0;
        while (n < f.length) {
            if (this.hasUsageFlag(n)) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(e[n]);
                bl = true;
            }
            ++n;
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }

    private void c(int n) {
        if (this.d == null || this.d.length < f.length) {
            boolean[] blArray = new boolean[f.length];
            if (this.d != null) {
                System.arraycopy(this.d, 0, blArray, 0, this.d.length);
            }
            this.d = blArray;
        }
        this.d[n] = true;
    }

    public void clearAllUsageFlags() {
        if (this.d != null) {
            int n = 0;
            int n2 = this.d.length;
            while (n < n2) {
                this.d[n] = false;
                ++n;
            }
            this.setValue(this.a());
        }
    }
}

