/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509PolicyInformation;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CertificatePoliciesExtension
extends X509Extension {
    private Vector c;
    private static final ASN1ObjectID d = PKIX.id_ce_certificatePolicies;

    public CertificatePoliciesExtension() {
        super(d);
    }

    public CertificatePoliciesExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void addCertificatePolicy(X509PolicyInformation x509PolicyInformation) {
        if (this.c == null) {
            this.c = new Vector();
        }
        this.c.addElement(x509PolicyInformation);
        this.setValue(this.a());
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation, boolean bl) {
        super(d, bl);
        this.c = new Vector();
        this.c.addElement(x509PolicyInformation);
        this.setValue(this.a());
    }

    public CertificatePoliciesExtension(X509PolicyInformation x509PolicyInformation) {
        this(x509PolicyInformation, false);
    }

    private byte[] a() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.c));
        this.isDecoded = true;
        return byArray;
    }

    private void b() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.c = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.c.addElement(new X509PolicyInformation(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.c.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public CertificatePoliciesExtension(Vector vector) {
        this(vector, false);
    }

    public Vector getCertificatePolicies() {
        if (!this.isDecoded) {
            this.b();
        }
        return this.c;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.b();
        }
        StringBuffer stringBuffer = new StringBuffer("certificatePoliciesExtension {oid = " + d.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCertificatePolicies() != null) {
            stringBuffer.append("certificatePolicies = {");
            boolean bl = false;
            int n = 0;
            int n2 = this.getCertificatePolicies().size();
            while (n < n2) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((X509PolicyInformation)this.getCertificatePolicies().elementAt(n)).toString());
                bl = true;
                ++n;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }

    public CertificatePoliciesExtension(Vector vector, boolean bl) {
        super(d, bl);
        this.c = vector;
        this.setValue(this.a());
    }
}

