/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRLDistPoint;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CRLDistPointExtension
extends X509Extension {
    private Vector c = new Vector();
    private static final ASN1ObjectID d = PKIX.id_ce_cRLDistributionPoints;

    public CRLDistPointExtension(CRLDistPoint cRLDistPoint) {
        this(cRLDistPoint, false);
    }

    public Vector getCRLDistPoints() {
        if (!this.isDecoded) {
            this.a();
        }
        return this.c;
    }

    private void a() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (this.c == null) {
                this.c = new Vector();
            } else {
                this.c.removeAllElements();
            }
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.c.addElement(new CRLDistPoint(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.c.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public CRLDistPointExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public CRLDistPointExtension() {
        super(d);
    }

    public void addCRLDistPoint(CRLDistPoint cRLDistPoint) {
        this.c.addElement(cRLDistPoint);
        this.setValue(this.b());
    }

    public CRLDistPointExtension(CRLDistPoint cRLDistPoint, boolean bl) {
        super(d, bl);
        this.addCRLDistPoint(cRLDistPoint);
    }

    public String toString() {
        if (!this.isDecoded) {
            this.a();
        }
        StringBuffer stringBuffer = new StringBuffer("crlDistPointExtension { oid = " + d.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCRLDistPoints() != null) {
            stringBuffer.append("CRLDistributionPoints = { ");
            boolean bl = false;
            int n = 0;
            int n2 = this.getCRLDistPoints().size();
            while (n < n2) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((CRLDistPoint)this.getCRLDistPoints().elementAt(n)).toString());
                bl = true;
                ++n;
            }
            stringBuffer.append(" }");
        }
        stringBuffer.append("] }");
        return stringBuffer.toString();
    }

    private byte[] b() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.c));
        this.isDecoded = true;
        return byArray;
    }
}

