/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class AuthorityKeyIDExtension
extends X509Extension {
    private Vector c = null;
    private BigInteger d = null;
    private byte[] e = null;
    private static final ASN1ObjectID f = PKIX.id_ce_authorityKeyIdentifier;

    public Enumeration authorityCertIssuer() {
        if (!this.isDecoded) {
            this.b();
        }
        return this.c != null ? this.c.elements() : null;
    }

    public AuthorityKeyIDExtension(Vector vector, BigInteger bigInteger, boolean bl) {
        super(f, bl);
        this.c = vector;
        this.d = bigInteger;
        this.setValue(this.a());
    }

    public AuthorityKeyIDExtension(byte[] byArray) {
        this(byArray, false);
    }

    public AuthorityKeyIDExtension() {
        super(f);
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger) {
        this(generalName, bigInteger, false);
    }

    private byte[] a() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.e != null) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(this.e, 0));
        }
        if (this.c != null && this.d != null) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(this.c, 1));
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.d), 2));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    public AuthorityKeyIDExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public String toString() {
        if (!this.isDecoded) {
            this.b();
        }
        StringBuffer stringBuffer = new StringBuffer("authorityKeyIDExtension {oid = " + f.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl = false;
        if (this.getAuthorityKeyID() != null) {
            stringBuffer.append("keyID = " + Utils.toHexString(this.getAuthorityKeyID()));
            bl = true;
        }
        if (this.getAuthorityCertSerialNo() != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("serialNo = " + this.getAuthorityCertSerialNo());
            bl = true;
        }
        if (this.c != null) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("issuer = {");
            boolean bl2 = false;
            int n = 0;
            int n2 = this.c.size();
            while (n < n2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.c.elementAt(n)).toString());
                bl2 = true;
                ++n;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }

    public byte[] getAuthorityKeyID() {
        if (!this.isDecoded) {
            this.b();
        }
        return this.e;
    }

    public AuthorityKeyIDExtension(GeneralName generalName, BigInteger bigInteger, boolean bl) {
        super(f, bl);
        this.c = new Vector();
        this.c.addElement(generalName);
        this.d = bigInteger;
        this.setValue(this.a());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void b() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(4);
                this.e = ASN1OctetString.inputValue(aSN1SequenceInputStream);
            } else {
                this.e = null;
            }
            if (this.e == null || aSN1SequenceInputStream.hasMoreData()) {
                if (aSN1SequenceInputStream.getCurrentTag() != 1) throw new ASN1FormatException("Malformed extension contents");
                aSN1SequenceInputStream.setCurrentTag(16);
                ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
                this.c = new Vector();
                while (aSN1SequenceInputStream2.hasMoreData()) {
                    this.c.addElement(new GeneralName(aSN1SequenceInputStream2));
                }
                aSN1SequenceInputStream2.terminate();
                if (aSN1SequenceInputStream.getCurrentTag() != 2) throw new ASN1FormatException("Malformed extension contents");
                aSN1SequenceInputStream.setCurrentTag(2);
                this.d = ASN1Integer.inputValue(aSN1SequenceInputStream);
            } else {
                this.c = null;
                this.d = null;
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public AuthorityKeyIDExtension(byte[] byArray, boolean bl) {
        super(f, bl);
        this.e = byArray;
        this.setValue(this.a());
    }

    public AuthorityKeyIDExtension(Vector vector, BigInteger bigInteger) {
        this(vector, bigInteger, false);
    }

    public BigInteger getAuthorityCertSerialNo() {
        if (!this.isDecoded) {
            this.b();
        }
        return this.d;
    }
}

