/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Boolean;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKIX;
import com.phaos.utils.OIDManager;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class X509Extension
implements ASN1Object {
    private ASN1Sequence f = null;
    public static final ASN1ObjectID id_netscape_ce = PKIX.id_netscape_ce;
    protected boolean isDecoded = false;
    public static final ASN1ObjectID id_set_ce;
    public static final ASN1ObjectID id_netscape_ce_type;
    public static final ASN1ObjectID id_set_ce_type;
    private ASN1ObjectID g;
    private boolean h;
    private byte[] i;

    public boolean isRecognized() {
        return OIDManager.getOIDManager().getProperty(this.getType(), "extension") != null;
    }

    protected void setCritical(boolean bl) {
        this.h = bl;
        this.e();
    }

    protected void setValue(byte[] byArray) {
        this.i = byArray;
        this.e();
        this.isDecoded = false;
    }

    public X509Extension(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public ASN1ObjectID getID() {
        return this.getType();
    }

    private ASN1Sequence d() {
        if (this.f != null) {
            return this.f;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.g);
        if (this.h) {
            aSN1Sequence.addElement(new ASN1Boolean(this.h));
        }
        aSN1Sequence.addElement(new ASN1OctetString(this.i));
        this.f = aSN1Sequence;
        return this.f;
    }

    public X509Extension(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, byte[] byArray) {
        this(aSN1ObjectID, false, byArray);
    }

    public byte[] getValue() {
        return this.i;
    }

    public boolean getCritical() {
        return this.h;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.d().output(outputStream);
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.g = aSN1ObjectID;
        this.h = bl;
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    public void input(InputStream inputStream) throws IOException {
        this.e();
        this.isDecoded = false;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.g = new ASN1ObjectID(aSN1SequenceInputStream);
        this.h = aSN1SequenceInputStream.getCurrentTag() == 1 ? ASN1Boolean.inputValue(aSN1SequenceInputStream) : false;
        this.i = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    public ASN1ObjectID getType() {
        return this.g;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID, false, Utils.toBytes(aSN1Object));
    }

    public String toString() {
        return "oid = " + this.g + ", critical = " + this.h + ", value = " + Utils.toHexString(this.i);
    }

    public static X509Extension inputInstance(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream);
        boolean bl = aSN1SequenceInputStream.getCurrentTag() == 1 ? ASN1Boolean.inputValue(aSN1SequenceInputStream) : false;
        byte[] byArray = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        String string = OIDManager.getOIDManager().getProperty(aSN1ObjectID, "extension");
        if (string == null) {
            return new X509Extension(aSN1ObjectID, bl, byArray);
        }
        X509Extension x509Extension = null;
        try {
            x509Extension = (X509Extension)Class.forName(string).newInstance();
            x509Extension.setCritical(bl);
            x509Extension.setValue(byArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException.toString());
        }
        return x509Extension;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl, ASN1Object aSN1Object) {
        this(aSN1ObjectID, bl, Utils.toBytes(aSN1Object));
    }

    static {
        id_netscape_ce_type = PKIX.id_netscape_ce_type;
        id_set_ce = PKIX.id_set_ce;
        id_set_ce_type = PKIX.id_set_ce_type;
    }

    private void e() {
        this.f = null;
    }

    public int length() {
        return this.d().length();
    }

    public ASN1Object getASN1Value() throws IOException {
        return ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(this.i));
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl, byte[] byArray) {
        this.g = aSN1ObjectID;
        this.h = bl;
        this.i = byArray;
    }

    public X509Extension() {
    }
}

