/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRL;
import com.phaos.cert.Certificate;
import com.phaos.cert.CertificateRequest;
import com.phaos.cert.Entity;
import com.phaos.cert.PKIX;
import com.phaos.cert.SPKAC;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509Attributes;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.cert.extension.KeyUsageExtension;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.OutputGenerationException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class X509
extends Certificate
implements ASN1Object,
Externalizable {
    private ASN1Sequence g = null;
    private AlgorithmIdentifier h;
    private transient MessageDigest i = null;
    private PrivateKey j;
    private X500Name k;
    private CRL l;
    private BigInteger m;
    private byte[] n;
    protected boolean isDecoded = false;
    private Date o;
    private X509 p;
    private Date q;
    private ASN1Sequence r;
    private X509ExtensionSet s = null;

    public static byte[] getCertID(X500Name x500Name, BigInteger bigInteger, MessageDigest messageDigest) {
        messageDigest.init();
        messageDigest.updateASCII(x500Name.toString());
        messageDigest.updateASCII(bigInteger.toString());
        messageDigest.computeCurrent();
        return messageDigest.getDigestBits();
    }

    private boolean a(X509 x509) {
        if (!this.isDecoded) {
            this.decode();
        }
        return Utils.areEqual(Utils.toBytes(this), Utils.toBytes(x509));
    }

    public X509(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void setKey(PublicKey publicKey) {
        this.setPublicKey(publicKey);
    }

    private void b() {
        this.e();
        this.r = null;
        this.n = null;
    }

    public X500Name getSubject() {
        if (!this.isDecoded) {
            this.decode();
        }
        return (X500Name)this.holder;
    }

    public byte[] getCertID(MessageDigest messageDigest) {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509.getCertID(this.k, this.m, messageDigest);
    }

    public PublicKey getPublicKey() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.key;
    }

    public PublicKey getKey() {
        return this.getPublicKey();
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public X509ExtensionSet getExtensionSet() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.s;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.key = publicKey;
        this.b();
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public void setIssuerCertificate(X509 x509) {
        this.p = x509;
        if (this.k == null) {
            this.setIssuer(x509.getSubject());
        }
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, int n) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = publicKey;
        this.k = x500Name2;
        this.j = privateKey;
        this.m = bigInteger;
        this.setValidity(n);
        this.sign();
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.h = algorithmIdentifier;
        this.b();
    }

    public void setNotAfterDate(Date date) {
        this.q = date;
        this.b();
    }

    public void initialize(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public X509Attributes getAttributes() {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509Attributes.fromExtensionSet(this.s, 0);
    }

    private boolean c() {
        BasicConstraintsExtension basicConstraintsExtension;
        if (!this.isDecoded) {
            this.decode();
        }
        if ((basicConstraintsExtension = (BasicConstraintsExtension)this.p.getExtension(PKIX.id_ce_basicConstraints)) != null && !basicConstraintsExtension.getCA()) {
            return false;
        }
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.p.getExtension(PKIX.id_ce_keyUsage);
        return keyUsageExtension == null || !keyUsageExtension.getCritical() || keyUsageExtension.hasUsageFlag(5);
    }

    public boolean equals(Object object) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (object != null && object instanceof X509) {
            return this.a((X509)object);
        }
        return false;
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.d());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    private ASN1Sequence d() throws SignatureException {
        if (this.g == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.f());
            aSN1Sequence.addElement(this.h);
            aSN1Sequence.addElement(new ASN1BitString(this.getSigBytes()));
            this.g = aSN1Sequence;
        }
        return this.g;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.output(outputStream);
    }

    public void setIssuerPrivateKey(PrivateKey privateKey) {
        this.setIssuerPrivateKey(privateKey, null);
    }

    public void setValidity(int n) {
        this.o = new Date();
        this.q = Utils.daysFrom(this.o, n);
        this.b();
    }

    public X509() {
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.s != null ? this.s.getExtension(aSN1ObjectID) : null;
    }

    public byte[] getSigBytes() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.n == null) {
            this.sign();
        }
        return this.n;
    }

    public boolean verifyCertDate() {
        Date date;
        if (!this.isDecoded) {
            this.decode();
        }
        return !(date = new Date()).before(this.o) && !date.after(this.q);
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, AlgorithmIdentifier algorithmIdentifier) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            Signature signature = Signature.getInstance(algorithmIdentifier);
            signature.setPublicKey(this.key);
            signature.setDocument(byArray);
            signature.setSigBytes(byArray2);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            this.d().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    public byte[] getFingerprint() {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            if (this.i == null) {
                this.i = MessageDigest.getInstance(AlgID.md5);
            }
            return this.i.computeDigest(Utils.toBytes(this.d()));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException("MD5 class not found. " + algorithmIdentifierException.toString());
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException.toString());
        }
    }

    public void input(InputStream inputStream) throws IOException {
        Object object;
        Serializable serializable;
        Object object2;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.r = new ASN1Sequence(aSN1SequenceInputStream);
        this.h = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.n = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.r));
        if (aSN1SequenceInputStream2.getCurrentTag() == 0) {
            object2 = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            serializable = ASN1Integer.inputValue((InputStream)object2);
            ((ASN1ConstructedInputStream)object2).terminate();
        }
        this.m = ASN1Integer.inputValue(aSN1SequenceInputStream2);
        object2 = new AlgorithmIdentifier(aSN1SequenceInputStream2);
        if (!((AlgorithmIdentifier)object2).equals(this.h)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        serializable = new X500Name(aSN1SequenceInputStream2);
        if (this.k == null) {
            this.k = serializable;
        } else if (!this.k.equals(serializable)) {
            throw new IOException("Expected issuer {" + this.k + "}, got issuer {" + serializable + "}");
        }
        ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
        this.o = ASN1Date.inputValue(aSN1SequenceInputStream3);
        this.q = ASN1Date.inputValue(aSN1SequenceInputStream3);
        aSN1SequenceInputStream3.terminate();
        this.holder = new X500Name(aSN1SequenceInputStream2);
        this.key = CryptoUtils.inputSPKI(aSN1SequenceInputStream2);
        if (aSN1SequenceInputStream2.getCurrentTag() == 1) {
            aSN1SequenceInputStream2.setCurrentTag(3);
            object = ASN1BitString.inputValue(aSN1SequenceInputStream2);
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 2) {
            aSN1SequenceInputStream2.setCurrentTag(3);
            object = ASN1BitString.inputValue(aSN1SequenceInputStream2);
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 3) {
            object = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.s = new X509ExtensionSet((InputStream)object);
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.s = null;
        }
        aSN1SequenceInputStream2.terminate();
        this.e();
    }

    public Entity getHolder() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.holder;
    }

    public Vector getExtensions() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.s != null ? this.s.getExtensions() : null;
    }

    public void setExtensions(Vector vector) {
        this.setExtensions(new X509ExtensionSet(vector));
    }

    public void setIssuer(X500Name x500Name) {
        this.k = x500Name;
        if (this.l != null && !x500Name.equals(this.l.getIssuer())) {
            throw new IllegalStateException("Certificate issuer does not match CRL issuer");
        }
        this.b();
    }

    public Date getNotAfterDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.q;
    }

    public void setIssuerCRL(CRL cRL) {
        if (!this.isDecoded) {
            this.decode();
        }
        this.l = cRL;
        if (this.k != null && !this.k.equals(cRL.getIssuer())) {
            throw new IllegalStateException("CRL issuer does not match certificate issuer");
        }
    }

    public void setNotBeforeDate(Date date) {
        this.o = date;
        this.b();
    }

    public BigInteger getSerialNo() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.m;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        return CryptoUtils.verifySignature(this.key, byArray, byArray2);
    }

    public void setIssuerPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.j = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    private void e() {
        this.g = null;
    }

    public String getSigAlgString() {
        return this.getSigAlgOID().toStringCompact();
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decode();
        }
        String string = "";
        string = string + "{ fingerprint = " + Utils.toHexString(this.getFingerprint());
        string = string + ", notBefore = " + this.o;
        string = string + ", notAfter = " + this.q;
        string = string + ", holder = " + this.holder;
        string = string + ", issuer = " + this.k;
        string = string + ", serialNo = " + this.m;
        string = string + ", sigAlgOID = " + this.getSigAlgString();
        string = string + ", key = " + this.key;
        if (this.s != null && this.s.size() > 0) {
            string = string + ", extensions = {";
            boolean bl = false;
            Enumeration enumeration = this.s.getExtensions().elements();
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    string = string + ", ";
                }
                string = string + (X509Extension)enumeration.nextElement();
                bl = true;
            }
            string = string + " }";
        }
        string = string + " }";
        return string;
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.j == null) {
            throw new SignatureException("Cannot sign certificate, no issuer private key set");
        }
        ASN1Sequence aSN1Sequence = this.f();
        try {
            Signature signature = Signature.getInstance(this.j);
            if (this.h == null) {
                throw new SignatureException("Cannot sign certificate, no signature algorithm set");
            }
            signature.setAlgID(this.h);
            signature.setRandomBitsSource(randomBitsSource);
            signature.setDocument(Utils.toBytes(aSN1Sequence));
            this.n = signature.sign();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        this.e();
    }

    protected void decode() {
        this.isDecoded = true;
    }

    public boolean verifyCertSignature() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.p == null) {
            throw new IllegalStateException("Issuer certificate not set");
        }
        try {
            Signature signature = Signature.getInstance(new AlgorithmIdentifier(this.getSigAlgOID()));
            signature.setPublicKey(this.p.getPublicKey());
            signature.setDocument(Utils.toBytes(this.f()));
            signature.setSigBytes(this.getSigBytes());
            return signature.verify();
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new AuthenticationException(streamableOutputException.toString());
        }
        catch (SignatureException signatureException) {
            throw new AuthenticationException(signatureException.toString());
        }
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = publicKey;
        this.k = x500Name2;
        this.j = privateKey;
        this.m = bigInteger;
        this.o = date;
        this.q = date2;
        this.sign();
    }

    public void setExtensions(X509ExtensionSet x509ExtensionSet) {
        this.s = x509ExtensionSet;
        this.b();
    }

    public void setSubject(X500Name x500Name) {
        this.holder = x500Name;
        this.b();
    }

    public void setHolder(X500Name x500Name) {
        this.holder = x500Name;
        this.b();
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.s != null && this.s.hasUnrecognizedCriticalExtension();
    }

    public void addExtension(X509Extension x509Extension) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.s == null) {
            this.s = new X509ExtensionSet();
        }
        this.s.addExtension(x509Extension);
        this.b();
    }

    public void setAttributes(X509Attributes x509Attributes) {
        if (!this.isDecoded) {
            this.decode();
        }
        X509ExtensionSet x509ExtensionSet = this.s;
        this.s = X509Attributes.toExtensionSet(x509Attributes);
        if (x509ExtensionSet != null) {
            Enumeration enumeration = x509ExtensionSet.getExtensions().elements();
            while (enumeration.hasMoreElements()) {
                this.s.addExtension((X509Extension)enumeration.nextElement());
            }
        }
        this.b();
    }

    public X500Name getIssuer() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.k;
    }

    public X509(CertificateRequest certificateRequest, X509 x509, PrivateKey privateKey, BigInteger bigInteger, int n) throws SignatureException {
        this();
        this.holder = certificateRequest.getSubject();
        this.key = certificateRequest.getPublicKey();
        this.setIssuerCertificate(x509);
        this.k = (X500Name)x509.getHolder();
        this.j = privateKey;
        this.m = bigInteger;
        this.setValidity(n);
        this.sign();
    }

    public int length() {
        try {
            return this.d().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public X509(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public void setSerialNo(BigInteger bigInteger) {
        this.m = bigInteger;
        this.b();
    }

    public X509(X500Name x500Name, SPKAC sPKAC, X509 x509, PrivateKey privateKey, BigInteger bigInteger, int n) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = sPKAC.getPublicKey();
        this.setIssuerCertificate(x509);
        this.k = (X500Name)x509.getHolder();
        this.j = privateKey;
        this.m = bigInteger;
        this.setValidity(n);
        this.sign();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public boolean verifyCertCRL() {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.l == null) {
            throw new IllegalStateException("Issuer CRL not set");
        }
        return !this.l.isRevoked(this.m);
    }

    public boolean verify() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyCertDate()) {
            return false;
        }
        if (this.p != null) {
            if (!this.c()) {
                return false;
            }
            if (!this.k.equals(this.p.getSubject())) {
                return false;
            }
            if (!this.verifyCertSignature()) {
                return false;
            }
        }
        return this.l == null || this.verifyCertCRL();
    }

    private ASN1Sequence f() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.r == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.s != null && this.s.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1Integer(2L), 0));
            }
            aSN1Sequence.addElement(new ASN1Integer(this.m));
            if (this.h == null && this.j != null) {
                this.h = Signature.getInstance(this.j).getAlgID();
            }
            if (this.h == null) {
                throw new SignatureException("Cannot build to-be-signed certificate, no signature algorithm set");
            }
            aSN1Sequence.addElement(this.h);
            aSN1Sequence.addElement(this.k);
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.o);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.q);
            aSN1Sequence2.addElement(new ASN1Date(this.o, calendar.get(1) > 2049));
            aSN1Sequence2.addElement(new ASN1Date(this.q, calendar2.get(1) > 2049));
            aSN1Sequence.addElement(aSN1Sequence2);
            aSN1Sequence.addElement((X500Name)this.holder);
            aSN1Sequence.addElement(CryptoUtils.subjectPublicKeyInfo(this.key));
            if (this.s != null && this.s.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.s, 3));
            }
            this.r = aSN1Sequence;
        }
        return this.r;
    }

    public Date getNotBeforeDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.o;
    }

    public int hashCode() {
        if (!this.isDecoded) {
            this.decode();
        }
        return new String(Utils.toBytes(this)).hashCode();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public ASN1ObjectID getSigAlgOID() {
        try {
            this.f();
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException.toString());
        }
        if (this.h != null) {
            return this.h.getOID();
        }
        throw new IllegalStateException("Signature algorithm not defined");
    }

    public X509(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }
}

