/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.cert.Entity;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500RDN;
import com.phaos.utils.ArrayVector;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class X500Name
extends Entity
implements ASN1Object,
Externalizable {
    private Vector e = new Vector();
    private String f = null;
    private String g = null;
    private ASN1Sequence h;
    private String i = null;
    private int j = -1;
    private String k;
    private String l = null;
    private String m = null;
    private String n = null;

    public Enumeration components() {
        return this.getComponents().elements();
    }

    public String getCountryName() {
        return this.i;
    }

    public String getStateName() {
        return this.f;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    public void input(String string) throws InvalidFormatException {
        this.a();
        boolean bl = true;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (!X500RDN.b(string.charAt(n))) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        ArrayVector arrayVector = new ArrayVector();
        while (n3 < string.length()) {
            try {
                char c = string.charAt(n3);
                if (c == '\"') {
                    bl2 = !bl2;
                    stringBuffer.append(c);
                } else if (c == ',' || c == ';') {
                    if (bl2) {
                        stringBuffer.append(c);
                    } else {
                        bl3 = true;
                    }
                } else if (c == '\\') {
                    stringBuffer.append(c);
                    c = string.charAt(++n3);
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(c);
                }
                if (!bl3 && ++n3 != string.length()) continue;
                arrayVector.addElement(new X500RDN(stringBuffer.toString()));
                stringBuffer = new StringBuffer();
                bl2 = false;
                bl3 = false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidFormatException("Malformed DN string");
            }
        }
        Object[] objectArray = new X500RDN[arrayVector.size()];
        arrayVector.getElements(objectArray);
        int n4 = objectArray.length - 1;
        while (n4 >= 0) {
            this.addComponent((X500RDN)objectArray[n4]);
            --n4;
        }
    }

    public String getCommonName() {
        return this.getName();
    }

    public X500Name() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X500Name x500Name = (X500Name)object;
        if (x500Name.size() != this.size()) {
            return false;
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            if (!this.componentAt(n).equals(x500Name.componentAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getLocalityName() {
        return this.n;
    }

    public void addComponent(ASN1ObjectID aSN1ObjectID, ASN1String aSN1String) {
        this.addComponent(new X500RDN(aSN1ObjectID, aSN1String));
    }

    public Vector getComponents() {
        if (this.e == null) {
            this.e = new Vector();
            if (this.i != null) {
                this.e.addElement(new X500RDN(PKIX.id_at_countryName, this.i));
            }
            if (this.f != null) {
                this.e.addElement(new X500RDN(PKIX.id_at_stateOrProvinceName, this.f));
            }
            if (this.n != null) {
                this.e.addElement(new X500RDN(PKIX.id_at_localityName, this.n));
            }
            if (this.g != null) {
                this.e.addElement(new X500RDN(PKIX.id_at_organizationName, this.g));
            }
            if (this.l != null) {
                this.e.addElement(new X500RDN(PKIX.id_at_organizationalUnitName, this.l));
            }
            if (this.getName() != null) {
                this.e.addElement(new X500RDN(PKIX.id_at_commonName, this.getName()));
            }
            if (this.m != null) {
                this.e.addElement(new X500RDN(PKIX.emailAddress, this.m));
            }
        }
        return this.e;
    }

    private void a() {
        this.e.removeAllElements();
        this.i = null;
        this.f = null;
        this.n = null;
        this.g = null;
        this.l = null;
        this.m = null;
        this.k = null;
        this.h = null;
        this.j = -1;
    }

    public void setOrgUnitName(String string) {
        this.l = string;
        this.b();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.c().getEncoded());
    }

    public X500Name(String string) {
        this.input(string);
    }

    public void setCommonName(String string) {
        this.setName(string);
        this.b();
    }

    public void setStateName(String string) {
        this.f = string;
        this.b();
    }

    public void addComponent(X500RDN x500RDN) {
        this.e.addElement(x500RDN);
        Enumeration enumeration = x500RDN.types();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)enumeration.nextElement();
            ASN1Object aSN1Object = x500RDN.getValue(aSN1ObjectID);
            if (!(aSN1Object instanceof ASN1String)) continue;
            ASN1String aSN1String = (ASN1String)aSN1Object;
            if (aSN1ObjectID.equals(PKIX.id_at_commonName)) {
                this.setName(aSN1String.getValue());
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_countryName)) {
                this.i = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_localityName)) {
                this.n = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_stateOrProvinceName)) {
                this.f = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_organizationName)) {
                this.g = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_organizationalUnitName)) {
                this.l = aSN1String.getValue();
                continue;
            }
            if (!aSN1ObjectID.equals(PKIX.emailAddress)) continue;
            this.m = aSN1String.getValue();
        }
        this.k = null;
        this.h = null;
        this.j = -1;
    }

    private void b() {
        this.e = null;
        this.h = null;
        this.k = null;
        this.j = -1;
    }

    public void setOrganizationName(String string) {
        this.g = string;
        this.b();
    }

    public int hashCode() {
        if (this.j == -1) {
            this.j = this.toString().hashCode();
        }
        return this.j;
    }

    public String toString() {
        if (this.k == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.size() - 1;
            while (n >= 0) {
                X500RDN x500RDN = this.componentAt(n);
                stringBuffer.append(x500RDN.toString());
                stringBuffer.append(',');
                --n;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.k = stringBuffer.toString();
        }
        return this.k;
    }

    public X500RDN getAttribute(String string) {
        ASN1ObjectID aSN1ObjectID = X500RDN.d(string);
        return aSN1ObjectID != null ? this.getAttribute(aSN1ObjectID) : null;
    }

    ASN1Sequence c() {
        if (this.h == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            int n = 0;
            int n2 = this.size();
            while (n < n2) {
                aSN1Sequence.addElement((X500RDN)this.e.elementAt(n));
                ++n;
            }
            this.h = aSN1Sequence;
        }
        return this.h;
    }

    public void setEmail(String string) {
        this.m = string;
        this.b();
    }

    public void input(InputStream inputStream) throws IOException {
        this.a();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            this.addComponent(new X500RDN(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.terminate();
    }

    public void setLocalityName(String string) {
        this.n = string;
        this.b();
    }

    public void forgetOriginalFormat() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInput.readObject();
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public int size() {
        return this.getComponents().size();
    }

    public X500RDN getAttribute(ASN1ObjectID aSN1ObjectID) {
        Enumeration enumeration = this.components();
        while (enumeration.hasMoreElements()) {
            X500RDN x500RDN = (X500RDN)enumeration.nextElement();
            if (x500RDN == null || x500RDN.getValue(aSN1ObjectID) == null) continue;
            return x500RDN;
        }
        return null;
    }

    X500Name(ASN1Sequence aSN1Sequence) throws IOException {
        this.d(aSN1Sequence);
    }

    public ASN1Object getAttributeValue(ASN1ObjectID aSN1ObjectID) {
        X500RDN x500RDN = this.getAttribute(aSN1ObjectID);
        return x500RDN != null ? x500RDN.getValue(aSN1ObjectID) : null;
    }

    public void setAttr(String string, String string2) {
        if (string.equalsIgnoreCase("C")) {
            this.setCountryName(string2);
        } else if (string.equalsIgnoreCase("ST")) {
            this.setStateName(string2);
        } else if (string.equalsIgnoreCase("L")) {
            this.setLocalityName(string2);
        } else if (string.equalsIgnoreCase("O")) {
            this.setOrganizationName(string2);
        } else if (string.equalsIgnoreCase("OU")) {
            this.setOrgUnitName(string2);
        } else if (string.equalsIgnoreCase("CN")) {
            this.setName(string2);
        } else if (string.equalsIgnoreCase("Email")) {
            this.setEmail(string2);
        } else {
            throw new IllegalArgumentException("Attribute '" + string + "' cannot be set using setAttr(String, String)" + ", only {C, ST, L, O, OU, CN, EMAIL} are allowed.");
        }
    }

    public String getOrganizationName() {
        return this.g;
    }

    public void addComponent(String string, String string2) {
        this.addComponent(X500RDN.d(string), string2);
    }

    public ASN1Object getAttributeValue(String string) {
        return this.getAttributeValue(X500RDN.d(string));
    }

    public String getEmail() {
        return this.m;
    }

    public X500Name(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int length() {
        return this.c().length();
    }

    public void setCountryName(String string) {
        this.i = string;
        this.b();
    }

    void d(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public String getOrgUnitName() {
        return this.l;
    }

    public X500RDN componentAt(int n) {
        return (X500RDN)this.getComponents().elementAt(n);
    }

    public void addComponent(ASN1ObjectID aSN1ObjectID, String string) {
        this.addComponent(new X500RDN(aSN1ObjectID, string));
    }
}

