/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1String;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SPKAC
implements ASN1Object {
    private PublicKey c;
    private String d;
    private ASN1Sequence e;
    private PrivateKey f;
    private transient RandomBitsSource g;

    public String toBase64() throws IOException {
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length());
        this.output(fixedByteArrayOutputStream);
        return Utils.toBase64(fixedByteArrayOutputStream.getBytes());
    }

    void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.e = aSN1Sequence;
        String string = null;
        try {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.elementAt(0);
            this.c = CryptoUtils.inputSPKI((ASN1Sequence)aSN1Sequence2.elementAt(0));
            string = ((ASN1String)aSN1Sequence2.elementAt(1)).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        if (this.d == null) {
            this.d = string;
        } else if (!this.d.equals(string)) {
            throw new IOException("Challenge does not equal the expected value");
        }
        if (!CryptoUtils.verifySignedASN1(aSN1Sequence, this.c)) {
            throw new IOException("Invalid signature");
        }
    }

    public SPKAC(String string, String string2) throws IOException {
        this(string);
        this.input(string2);
    }

    public void input(String string) throws IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(Utils.fromBase64(string));
        this.input(unsyncByteArrayInputStream);
    }

    public SPKAC(String string) {
        this.d = string;
    }

    public SPKAC(String string, KeyPair keyPair) {
        this(string, keyPair, RandomBitsSource.getDefault());
    }

    public SPKAC(String string, InputStream inputStream) throws IOException {
        this(string);
        this.input(inputStream);
    }

    public PublicKey getPublicKey() {
        return this.c;
    }

    public SPKAC() {
    }

    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public SPKAC(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public int length() {
        return this.b().length();
    }

    public String getChallenge() {
        return this.d;
    }

    public SPKAC(KeyPair keyPair) {
        this(keyPair, RandomBitsSource.getDefault());
    }

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    private ASN1Sequence b() {
        if (this.e != null) {
            return this.e;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(CryptoUtils.subjectPublicKeyInfo(this.c));
        aSN1Sequence.addElement(new ASN1String(this.d, 22));
        try {
            this.e = CryptoUtils.signASN1(aSN1Sequence, this.f, this.g);
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
        return this.e;
    }

    public SPKAC(String string, KeyPair keyPair, RandomBitsSource randomBitsSource) {
        this.c = keyPair.getPublic();
        this.f = keyPair.getPrivate();
        this.d = string;
    }

    public SPKAC(KeyPair keyPair, RandomBitsSource randomBitsSource) {
        this("", keyPair, randomBitsSource);
    }
}

