/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12;
import com.phaos.cert.PKCS12Bag;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.PKCS5;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class PKCS12Safe
implements ASN1Object {
    private ASN1Sequence c;
    private int d = -2;
    private String e;
    private PKCS12 f;
    private PKCS5 g;
    private Vector h;

    public int length() {
        return this.a().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
    }

    private ASN1Sequence a() {
        if (this.c != null) {
            return this.c;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.h));
        if (this.d == -2) {
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
            aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        } else {
            byte[] byArray2;
            this.g = new PKCS5(this.getPassword(), this.d, RandomBitsSource.getDefault());
            try {
                byArray2 = this.g.encrypt(byArray);
            }
            catch (CipherException cipherException) {
                throw new StreamableOutputException(cipherException.toString());
            }
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 6));
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(new ASN1Integer(0L));
            ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
            aSN1Sequence3.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
            aSN1Sequence3.addElement(this.g.outputAlgIDASN1());
            aSN1Sequence3.addElement(new ASN1GenericPrimitive(new ASN1OctetString(byArray2), 0));
            aSN1Sequence2.addElement(aSN1Sequence3);
            aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        }
        this.c = aSN1Sequence;
        return aSN1Sequence;
    }

    public int getMode() {
        return this.d;
    }

    public void setBags(Vector vector) {
        this.h = vector;
        this.b();
    }

    public String getPassword() {
        return this.e != null ? this.e : this.f.getPassword();
    }

    void b() {
        this.c = null;
        if (this.f != null) {
            this.f.c();
        }
    }

    public PKCS5 getPKCS5() {
        return this.g;
    }

    public Vector getBags() {
        return this.h;
    }

    public void setPassword(String string) {
        this.e = string;
        this.b();
    }

    public void addBag(PKCS12Bag pKCS12Bag) {
        this.h.addElement(pKCS12Bag);
        this.b();
    }

    public PKCS12Safe(PKCS12 pKCS12, int n) {
        this(pKCS12);
        this.setMode(n);
    }

    public PKCS12Safe(PKCS12 pKCS12, InputStream inputStream) throws IOException {
        this(pKCS12);
        this.input(inputStream);
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            Object object;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            byte[] byArray = null;
            if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 1)) {
                this.d = -2;
                byArray = ((ASN1OctetString)aSN1GenericConstructed.elementAt(0)).getValue();
            } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 6)) {
                byte[] byArray2;
                object = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1Sequence)object).elementAt(1);
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence2.elementAt(1);
                this.g = new PKCS5();
                this.g.inputAlgID(aSN1Sequence3);
                this.d = this.g.getMode();
                ASN1Object aSN1Object = aSN1Sequence2.elementAt(2);
                if (aSN1Object instanceof ASN1GenericPrimitive) {
                    byArray2 = ((ASN1OctetString)((ASN1GenericPrimitive)aSN1Object).withTag(4)).getValue();
                } else if (aSN1Object instanceof ASN1GenericConstructed) {
                    Vector vector = ((ASN1GenericConstructed)aSN1Object).elements();
                    byte[][] byArray3 = new byte[vector.size()][0];
                    int n = 0;
                    int n2 = 0;
                    int n3 = byArray3.length;
                    while (n2 < n3) {
                        byArray3[n2] = ((ASN1OctetString)vector.elementAt(n2)).getValue();
                        n += byArray3[n2].length;
                        ++n2;
                    }
                    byArray2 = new byte[n];
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = byArray3.length;
                    while (n5 < n6) {
                        System.arraycopy(byArray3[n5], 0, byArray2, n4, byArray3[n5].length);
                        n4 += byArray3[n5].length;
                        ++n5;
                    }
                } else {
                    throw new InvalidInputException("Cound not read encrypted content.");
                }
                this.g.setPassword(this.getPassword());
                byArray = this.g.decrypt(byArray2);
            } else {
                throw new IOException("Unrecognized ContentType " + aSN1ObjectID);
            }
            object = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(byArray));
            while (((ASN1ConstructedInputStream)object).hasMoreData()) {
                this.addBag(PKCS12Bag.a(this, new ASN1Sequence((InputStream)object)));
            }
            ((ASN1ConstructedInputStream)object).terminate();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
        catch (CipherException cipherException) {
            throw new ASN1FormatException(cipherException.toString());
        }
        this.c = aSN1Sequence;
    }

    public PKCS12Safe(PKCS12 pKCS12) {
        this.f = pKCS12;
        this.h = new Vector();
    }

    public void setMode(int n) {
        this.d = n;
        this.b();
    }

    public PKCS12Safe(PKCS12 pKCS12, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12);
        this.input(aSN1Sequence);
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public String toString() {
        String string = this.g != null ? "pkcs5 = {" + this.g + "}" : "mode = " + PKCS5.modeString(this.d);
        Enumeration enumeration = this.h.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ", {" + (PKCS12Bag)enumeration.nextElement() + "}";
        }
        return string;
    }
}

