/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Safe;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DigestInfo;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PKCS5;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class PKCS12
implements ASN1Object {
    private byte[] d;
    private BigInteger e;
    private Vector f = new Vector();
    private AlgorithmIdentifier g;
    private ASN1Sequence h;
    private byte[] i;
    private String j;

    private void a() throws AlgorithmIdentifierException, CipherException {
        if (this.g == null) {
            this.g = AlgID.sha_1;
        }
        if (this.i == null) {
            this.i = RandomBitsSource.getDefault().randomBytes(new byte[8]);
        }
        if (this.e == null) {
            this.e = BigInteger.valueOf(1024L);
        }
        byte[] byArray = PKCS5.pkcs12PseudoRandomBytes((byte)3, MessageDigest.getInstance(this.g).getDigestLength(), this.g, this.j, this.i, this.e.intValue());
        HMAC hMAC = new HMAC(this.g, byArray);
        byte[] byArray2 = Utils.toBytes(new ASN1Sequence(this.f));
        this.d = hMAC.computeDigest(byArray2);
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void setAuthSafes(Vector vector) {
        this.f = vector;
        this.c();
    }

    public PKCS12(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this();
        this.setPassword(string);
        this.input(aSN1Sequence);
    }

    public void addAuthSafe(PKCS12Safe pKCS12Safe) {
        this.f.addElement(pKCS12Safe);
        this.c();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        boolean bl = false;
        Enumeration enumeration = this.f.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(enumeration.nextElement().toString());
            stringBuffer.append(']');
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private ASN1Sequence b() {
        if (this.h != null) {
            return this.h;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(3L));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.f));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        aSN1Sequence.addElement(aSN1Sequence2);
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        if (this.d == null) {
            try {
                this.a();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new StreamableOutputException(algorithmIdentifierException.toString());
            }
            catch (CipherException cipherException) {
                throw new StreamableOutputException(cipherException.toString());
            }
        }
        aSN1Sequence3.addElement(new DigestInfo(this.g, this.d));
        aSN1Sequence3.addElement(new ASN1OctetString(this.i));
        if (this.e.intValue() != 1) {
            aSN1Sequence3.addElement(new ASN1Integer(this.e));
        }
        aSN1Sequence.addElement(aSN1Sequence3);
        this.h = aSN1Sequence;
        return aSN1Sequence;
    }

    public PKCS12(String string, InputStream inputStream) throws IOException {
        this();
        this.setPassword(string);
        this.input(inputStream);
    }

    public String getPassword() {
        return this.j;
    }

    public PKCS12() {
    }

    void c() {
        this.h = null;
        this.d = null;
    }

    public void input(InputStream inputStream) throws IOException {
        Object object;
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        this.c();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        int n = ASN1Integer.inputValue(aSN1SequenceInputStream).intValue();
        if (n != 3) {
            throw new ASN1FormatException("Expecting version 3, got version " + n);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
        if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 1)) {
            if (aSN1SequenceInputStream2.hasMoreData()) {
                aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream2, 0);
                object = ASN1OctetString.inputValue(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.terminate();
                ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream((byte[])object));
                while (aSN1SequenceInputStream3.hasMoreData()) {
                    this.addAuthSafe(new PKCS12Safe(this, new ASN1Sequence(aSN1SequenceInputStream3)));
                }
                aSN1SequenceInputStream3.terminate();
            }
        } else {
            if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 7, 2)) {
                throw new ASN1FormatException("Public-key integrity mode not supported");
            }
            throw new ASN1FormatException("Invalid integrity mode OID " + aSN1ObjectID.toStringCompact());
        }
        aSN1SequenceInputStream2.terminate();
        if (aSN1SequenceInputStream.hasMoreData()) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            object = new DigestInfo(aSN1ConstructedInputStream);
            this.g = ((DigestInfo)object).getDigestAlgID();
            this.d = ((DigestInfo)object).getDigest();
            this.i = ASN1OctetString.inputValue(aSN1ConstructedInputStream);
            this.e = aSN1ConstructedInputStream.hasMoreData() ? ASN1Integer.inputValue(aSN1ConstructedInputStream) : BigInteger.valueOf(1L);
            aSN1ConstructedInputStream.terminate();
        } else {
            this.g = null;
            this.d = null;
            this.i = null;
            this.e = null;
        }
        aSN1SequenceInputStream.terminate();
    }

    public PKCS12(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public void setPassword(String string) {
        if (this.j != null && !this.j.equals(string)) {
            this.c();
        }
        this.j = string;
    }

    public int length() {
        return this.b().length();
    }

    public boolean verify() throws AuthenticationException {
        try {
            if (this.d == null) {
                this.a();
            }
            byte[] byArray = PKCS5.pkcs12PseudoRandomBytes((byte)3, MessageDigest.getInstance(this.g).getDigestLength(), this.g, this.j, this.i, this.e.intValue());
            HMAC hMAC = new HMAC(this.g, byArray);
            byte[] byArray2 = Utils.toBytes(new ASN1Sequence(this.f));
            byte[] byArray3 = hMAC.computeDigest(byArray2);
            return Utils.areEqual(this.d, byArray3);
        }
        catch (CipherException cipherException) {
            throw new AuthenticationException(cipherException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
    }

    public Vector getAuthSafes() {
        return this.f;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }
}

