/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public final class IssuerAndSerialNo
implements ASN1Object {
    private ASN1Sequence c;
    private BigInteger d;
    private X500Name e;

    public int length() {
        return this.b().length();
    }

    public IssuerAndSerialNo(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public IssuerAndSerialNo(X509 x509) {
        this(x509.getIssuer(), x509.getSerialNo());
    }

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    public BigInteger getSerialNo() {
        return this.d;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.e = new X500Name(aSN1SequenceInputStream);
        this.d = ASN1Integer.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.a();
    }

    private void a() {
        this.c = null;
    }

    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IssuerAndSerialNo)) {
            return false;
        }
        IssuerAndSerialNo issuerAndSerialNo = (IssuerAndSerialNo)object;
        return Utils.areEqual(this.getEncoded(), issuerAndSerialNo.getEncoded());
    }

    public IssuerAndSerialNo(X500Name x500Name, BigInteger bigInteger) {
        this.e = x500Name;
        this.d = bigInteger;
    }

    private ASN1Sequence b() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.e);
            aSN1Sequence.addElement(new ASN1Integer(this.d));
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("issuer = ");
        stringBuffer.append(this.e != null ? this.e.toString() : "null");
        stringBuffer.append(", serialNo = ");
        stringBuffer.append(this.d != null ? this.d.toString() : "null");
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public X500Name getIssuer() {
        return this.e;
    }
}

