/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.X500Name;
import com.phaos.utils.Utils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class GeneralName
implements ASN1Object {
    private Type c;
    private ASN1Object d = null;
    private ASN1Object e;

    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Object aSN1Object;
        Type type;
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        int n2 = n & 0x20;
        switch (n & 0x1F) {
            case 0: {
                type = Type.OTHER_NAME;
                pushbackInputStream.unread(n2 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 1: {
                type = Type.RFC822_NAME;
                pushbackInputStream.unread(n2 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 2: {
                type = Type.DNS_NAME;
                pushbackInputStream.unread(n2 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 3: {
                type = Type.X400_ADDRESS;
                pushbackInputStream.unread(n2 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 4: {
                type = Type.DIRECTORY_NAME;
                pushbackInputStream.unread(n);
                ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)pushbackInputStream, 4);
                aSN1Object = new X500Name(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.terminate();
                break;
            }
            case 5: {
                type = Type.EDI_PARTY_NAME;
                pushbackInputStream.unread(n2 | 0x10);
                aSN1Object = new ASN1Sequence(pushbackInputStream);
                break;
            }
            case 6: {
                type = Type.URI;
                pushbackInputStream.unread(n2 | 0x16);
                aSN1Object = new ASN1String(pushbackInputStream);
                break;
            }
            case 7: {
                type = Type.IP_ADDRESS;
                pushbackInputStream.unread(n2 | 4);
                aSN1Object = new ASN1OctetString(pushbackInputStream);
                break;
            }
            case 8: {
                type = Type.REGISTERED_ID;
                pushbackInputStream.unread(n2 | 6);
                aSN1Object = new ASN1ObjectID(pushbackInputStream);
                break;
            }
            default: {
                throw new ASN1FormatException("Unrecognized tag for GeneralName");
            }
        }
        this.a(type, aSN1Object);
    }

    public GeneralName(Type type, ASN1Object aSN1Object) {
        try {
            this.a(type, aSN1Object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public GeneralName(X500Name x500Name) {
        this(Type.DIRECTORY_NAME, x500Name);
    }

    public Type getType() {
        return this.c;
    }

    public ASN1Object getValue() {
        return this.e;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            GeneralName generalName = (GeneralName)object;
            if (this.c == generalName.c) {
                return Utils.areEqual(Utils.toBytes(this.e), Utils.toBytes(generalName.e));
            }
            return false;
        }
        if (object instanceof ASN1Object) {
            return Utils.areEqual(Utils.toBytes(this.e), Utils.toBytes((ASN1Object)object));
        }
        return false;
    }

    public GeneralName(Type type, String string) {
        this(type, new ASN1String(string, 22));
    }

    public String toString() {
        if (this.e == null) {
            return "";
        }
        return "{ " + this.c + ": " + this.e + " }";
    }

    private void a(Type type, ASN1Object aSN1Object) throws IOException {
        if (type == Type.OTHER_NAME) {
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
            new ASN1ObjectID(aSN1SequenceInputStream);
            new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
        } else if (type == Type.RFC822_NAME || type == Type.DNS_NAME || type == Type.URI) {
            if (!(aSN1Object instanceof ASN1String)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
            if (((ASN1String)aSN1Object).getTag() != 22) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.IP_ADDRESS) {
            if (!(aSN1Object instanceof ASN1OctetString)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.X400_ADDRESS || type == Type.DIRECTORY_NAME || type == Type.EDI_PARTY_NAME) {
            new ASN1Sequence(Utils.toStream(aSN1Object));
        } else if (type == Type.REGISTERED_ID) {
            new ASN1ObjectID(Utils.toStream(aSN1Object));
        }
        this.d = null;
        this.c = type;
        this.e = aSN1Object;
    }

    public int length() {
        return this.b().length();
    }

    private ASN1Object b() {
        if (this.d == null) {
            switch (this.c.a()) {
                case 4: {
                    this.d = new ASN1GenericConstructed(this.e, this.c.a());
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.d = ASN1Utils.addImplicitTag(this.e, this.c.a());
                }
            }
        }
        return this.d;
    }

    public GeneralName(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public static class Type {
        public static final Type DNS_NAME;
        public static final Type EDI_PARTY_NAME;
        public static final Type IP_ADDRESS;
        public static final Type DIRECTORY_NAME;
        private String b;
        private int c;
        public static final Type REGISTERED_ID;
        public static final Type URI;
        public static final Type OTHER_NAME;
        public static final Type RFC822_NAME;
        public static final Type X400_ADDRESS;

        static {
            OTHER_NAME = new Type(0, "otherName");
            RFC822_NAME = new Type(1, "rfc822Name");
            DNS_NAME = new Type(2, "dNSName");
            X400_ADDRESS = new Type(3, "x400Address");
            DIRECTORY_NAME = new Type(4, "directoryName");
            EDI_PARTY_NAME = new Type(5, "ediPartyName");
            URI = new Type(6, "uniformResourceIdentifier");
            IP_ADDRESS = new Type(7, "iPAddress");
            REGISTERED_ID = new Type(8, "registeredID");
        }

        private int a() {
            return this.c;
        }

        private Type(int n, String string) {
            this.c = n;
            this.b = string;
        }

        public String toString() {
            return this.b;
        }
    }
}

