/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CRLReason
implements ASN1Object {
    public static final CRLReason REMOVE_FROM_CRL;
    public static final CRLReason AFFILIATION_CHANGE;
    public static final CRLReason KEY_COMPROMISE;
    public static final CRLReason CA_COMPROMISE;
    public static final CRLReason UNSPECIFIED;
    public static final CRLReason[] LIST;
    private int a;
    public static final CRLReason CERTIFICATE_HOLD;
    public static final CRLReason CESSATION_OF_OPERATION;
    public static final CRLReason SUPERSEDED;
    private static final CRLReason b;

    public String toString() {
        if (this.a == UNSPECIFIED.getValue()) {
            return "UNSPECIFIED";
        }
        if (this.a == KEY_COMPROMISE.getValue()) {
            return "KEY COMPROMISE";
        }
        if (this.a == CA_COMPROMISE.getValue()) {
            return "CA COMPROMISE";
        }
        if (this.a == AFFILIATION_CHANGE.getValue()) {
            return "AFFILIATION CHANGE";
        }
        if (this.a == SUPERSEDED.getValue()) {
            return "SUPERSEDED";
        }
        if (this.a == CESSATION_OF_OPERATION.getValue()) {
            return "CESSATION OF OPERATION";
        }
        if (this.a == CERTIFICATE_HOLD.getValue()) {
            return "CERTIFICATE HOLD";
        }
        if (this.a == REMOVE_FROM_CRL.getValue()) {
            return "REMOVE FROM CRL";
        }
        return null;
    }

    public int getValue() {
        return this.a;
    }

    private CRLReason(int n) {
        this.a = n;
    }

    public int length() {
        return new ASN1GenericPrimitive(new ASN1Integer(this.a), 10, 0).length();
    }

    public CRLReason(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        try {
            ASN1GenericPrimitive aSN1GenericPrimitive = new ASN1GenericPrimitive(inputStream);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1GenericPrimitive.withTag(2);
            this.a = aSN1Integer.intValue();
            if (this.a < 0 || this.a > 8) {
                throw new ASN1FormatException("Unrecognized crl reason value");
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
    }

    static {
        UNSPECIFIED = new CRLReason(0);
        KEY_COMPROMISE = new CRLReason(1);
        CA_COMPROMISE = new CRLReason(2);
        AFFILIATION_CHANGE = new CRLReason(3);
        SUPERSEDED = new CRLReason(4);
        CESSATION_OF_OPERATION = new CRLReason(5);
        CERTIFICATE_HOLD = new CRLReason(6);
        b = new CRLReason(7);
        REMOVE_FROM_CRL = new CRLReason(8);
        LIST = new CRLReason[]{UNSPECIFIED, KEY_COMPROMISE, CA_COMPROMISE, AFFILIATION_CHANGE, SUPERSEDED, CESSATION_OF_OPERATION, CERTIFICATE_HOLD, b, REMOVE_FROM_CRL};
    }

    public void output(OutputStream outputStream) throws IOException {
        new ASN1GenericPrimitive(new ASN1Integer(this.a), 10, 0).output(outputStream);
    }
}

