/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.RevokedCertificate;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.cert.X509Attributes;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.OutputGenerationException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CRL
implements ASN1Object {
    private ASN1Sequence g = null;
    private PrivateKey h;
    private PublicKey i;
    private Vector j = null;
    private ASN1Sequence k = null;
    private Date l = null;
    private X509ExtensionSet m = null;
    private Date n = new Date();
    private X500Name o;
    private AlgorithmIdentifier p = null;
    private X509 q;
    private Hashtable r = null;
    private byte[] s = null;

    public boolean verify() throws AuthenticationException {
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyDate()) {
            return false;
        }
        return this.verifySignature();
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    private void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return this.m != null ? this.m.getExtension(aSN1ObjectID) : null;
    }

    public void setPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.h = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setRevokedCertificates(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.r = new Hashtable();
            this.j = new Vector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
                if (this.r.put(revokedCertificate.getSerialNo(), revokedCertificate) != null) {
                    this.j.removeElement(revokedCertificate.getSerialNo());
                }
                this.j.addElement(revokedCertificate.getSerialNo());
            }
            this.f();
        }
    }

    public CRL(X509 x509, File file) throws FileNotFoundException, IOException {
        this(x509);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        fileInputStream.close();
    }

    public Date revocationDate(BigInteger bigInteger) {
        RevokedCertificate revokedCertificate = this.getRevokedCertificate(bigInteger);
        return revokedCertificate != null ? revokedCertificate.getRevocationDate() : null;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.i = publicKey;
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            this.d().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    public CRL(X509 x509, ASN1Sequence aSN1Sequence) throws IOException {
        this(x509);
        this.a(aSN1Sequence);
    }

    public boolean verifyDate() {
        Date date = new Date();
        if (date.before(this.n)) {
            return false;
        }
        return this.l == null || !date.after(this.l);
    }

    public void addExtension(X509Extension x509Extension) {
        if (this.m == null) {
            this.m = new X509ExtensionSet();
        }
        this.m.addExtension(x509Extension);
        this.f();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        Object object;
        this.f();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.k = new ASN1Sequence(aSN1SequenceInputStream);
        this.p = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.s = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.k));
        if (aSN1SequenceInputStream2.getCurrentTag() == 2) {
            object = ASN1Integer.inputValue(aSN1SequenceInputStream2);
        }
        if (!((AlgorithmIdentifier)(object = new AlgorithmIdentifier(aSN1SequenceInputStream2))).equals(this.p)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name x500Name = new X500Name(aSN1SequenceInputStream2);
        if (this.o == null) {
            this.o = x500Name;
        } else if (!this.o.equals(x500Name)) {
            throw new IOException("Expected issuer {" + this.o + "}, got issuer {" + x500Name + "}");
        }
        this.n = ASN1Date.inputValue(aSN1SequenceInputStream2);
        this.l = aSN1SequenceInputStream2.getCurrentTag() == 23 || aSN1SequenceInputStream2.getCurrentTag() == 24 ? ASN1Date.inputValue(aSN1SequenceInputStream2) : null;
        if (aSN1SequenceInputStream2.getCurrentTag() == 16) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
            this.r = new Hashtable();
            this.j = new Vector();
            while (aSN1ConstructedInputStream.hasMoreData()) {
                RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1ConstructedInputStream);
                if (this.r.put(revokedCertificate.getSerialNo(), revokedCertificate) != null) {
                    this.j.removeElement(revokedCertificate.getSerialNo());
                }
                this.j.addElement(revokedCertificate.getSerialNo());
            }
            aSN1ConstructedInputStream.terminate();
        } else {
            this.r = null;
            this.j = null;
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 0) {
            aSN1ConstructedInputStream = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.m = new X509ExtensionSet(aSN1ConstructedInputStream);
            aSN1ConstructedInputStream.terminate();
        } else {
            this.m = null;
        }
        aSN1SequenceInputStream2.terminate();
    }

    public CRL() {
    }

    public CRL(ASN1Sequence aSN1Sequence) throws IOException {
        this.a(aSN1Sequence);
    }

    public X509ExtensionSet getExtensionSet() {
        return this.m;
    }

    public CRL(URL uRL) throws IOException {
        this(uRL.openStream());
    }

    private ASN1Sequence b() {
        if (this.k == null) {
            Object object;
            Object object2;
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.m != null && this.m.size() > 0) {
                aSN1Sequence.addElement(new ASN1Integer(1L));
            } else if (this.r != null && this.r.size() > 0) {
                object2 = this.j.elements();
                while (object2.hasMoreElements()) {
                    object = (RevokedCertificate)this.r.get(object2.nextElement());
                    if (((RevokedCertificate)object).getExtensions() == null || ((RevokedCertificate)object).getExtensions().size() <= 0) continue;
                    aSN1Sequence.addElement(new ASN1Integer(1L));
                    break;
                }
            }
            if (this.p == null) {
                try {
                    this.p = Signature.getInstance(this.h).getAlgID();
                }
                catch (SignatureException signatureException) {
                    throw new IllegalStateException(signatureException.toString());
                }
                catch (NullPointerException nullPointerException) {
                    throw new IllegalStateException("Issuer signing key must be set befor output");
                }
            }
            aSN1Sequence.addElement(this.p);
            aSN1Sequence.addElement(this.o);
            object2 = Calendar.getInstance();
            ((Calendar)object2).setTime(this.n);
            aSN1Sequence.addElement(new ASN1Date(this.n, ((Calendar)object2).get(1) > 2049));
            if (this.l != null) {
                object = Calendar.getInstance();
                ((Calendar)object).setTime(this.l);
                aSN1Sequence.addElement(new ASN1Date(this.l, ((Calendar)object).get(1) > 2049));
            }
            if (this.r != null && this.r.size() > 0) {
                object = new ASN1Sequence();
                Enumeration enumeration = this.j.elements();
                while (enumeration.hasMoreElements()) {
                    ((ASN1Sequence)object).addElement((RevokedCertificate)this.r.get(enumeration.nextElement()));
                }
                aSN1Sequence.addElement((ASN1Object)object);
            }
            if (this.m != null && this.m.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.m, 0));
            }
            this.k = aSN1Sequence;
        }
        return this.k;
    }

    public boolean isRevoked(BigInteger bigInteger) {
        return this.getRevokedCertificate(bigInteger) != null;
    }

    public Enumeration revokedSerialNos() {
        return this.j != null ? this.j.elements() : new Vector().elements();
    }

    public Vector getExtensions() {
        return this.m != null ? this.m.getExtensions() : null;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CRL) {
            return this.e((CRL)object);
        }
        return false;
    }

    public void addCertificate(BigInteger bigInteger, Date date) {
        this.addCertificate(new RevokedCertificate(bigInteger, date));
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (this.m != null && this.m.hasUnrecognizedCriticalExtension()) {
            return true;
        }
        if (this.r != null) {
            Enumeration enumeration = this.revokedSerialNos();
            while (enumeration.hasMoreElements()) {
                X509ExtensionSet x509ExtensionSet;
                RevokedCertificate revokedCertificate = this.getRevokedCertificate((BigInteger)enumeration.nextElement());
                if (revokedCertificate == null || (x509ExtensionSet = revokedCertificate.getExtensionSet()) == null || !x509ExtensionSet.hasUnrecognizedCriticalExtension()) continue;
                return true;
            }
        }
        return false;
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.p = algorithmIdentifier;
        this.f();
    }

    public Vector getRevokedCertificates() {
        Vector vector = null;
        if (this.r != null) {
            vector = new Vector();
            Enumeration enumeration = this.j.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(this.r.get(enumeration.nextElement()));
            }
        }
        return vector;
    }

    public CRL(X509 x509, URL uRL) throws IOException {
        this(x509);
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }

    private void c() {
        this.g = null;
    }

    public CRL(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        ASN1Sequence aSN1Sequence = this.b();
        try {
            try {
                Signature signature = Signature.getInstance(this.p);
                signature.setPrivateKey(this.h);
                signature.setRandomBitsSource(randomBitsSource);
                signature.setDocument(Utils.toBytes(aSN1Sequence));
                this.s = signature.sign();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new SignatureException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SignatureException(invalidKeyException.toString());
            }
            Object var6_5 = null;
            this.c();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.c();
            throw throwable;
        }
    }

    private ASN1Sequence d() throws SignatureException {
        if (this.g == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.b());
            aSN1Sequence.addElement(this.p);
            aSN1Sequence.addElement(new ASN1BitString(this.getSigBytes()));
            this.g = aSN1Sequence;
        }
        return this.g;
    }

    public ASN1Sequence outputASN1() throws IOException {
        try {
            return this.d();
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.d());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    private boolean e(CRL cRL) {
        return Utils.areEqual(Utils.toBytes(this), Utils.toBytes(cRL));
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.setPrivateKey(privateKey, null);
    }

    public void setDate(Date date) {
        this.n = date;
        this.f();
    }

    public void setExtensions(Vector vector) {
        this.setExtensions(new X509ExtensionSet(vector));
    }

    public CRL(X500Name x500Name, PrivateKey privateKey, int n) {
        this(x500Name, privateKey);
        if (n > 0) {
            this.setDates(n);
        }
    }

    public void addCertificate(RevokedCertificate revokedCertificate) {
        if (this.r == null) {
            this.r = new Hashtable();
            this.j = new Vector();
        }
        if (this.r.put(revokedCertificate.getSerialNo(), revokedCertificate) != null) {
            this.j.removeElement(revokedCertificate.getSerialNo());
        }
        this.j.addElement(revokedCertificate.getSerialNo());
        this.f();
    }

    public CRL(X509 x509) {
        this.setIssuer(x509.getSubject());
        this.setPublicKey(x509.getPublicKey());
    }

    public void setAttributes(X509Attributes x509Attributes) {
        X509ExtensionSet x509ExtensionSet = this.m;
        X509ExtensionSet x509ExtensionSet2 = X509Attributes.toExtensionSet(x509Attributes);
        if (x509ExtensionSet != null) {
            Vector vector = x509ExtensionSet.getExtensions();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                x509ExtensionSet2.addExtension((X509Extension)vector.elementAt(n));
                ++n;
            }
        }
        this.setExtensions(x509ExtensionSet2);
    }

    public CRL(X509 x509, InputStream inputStream) throws IOException {
        this(x509);
        this.input(inputStream);
    }

    public CRL(X500Name x500Name, PrivateKey privateKey) {
        this.setIssuer(x500Name);
        this.setPrivateKey(privateKey);
    }

    private void f() {
        this.c();
        this.k = null;
        this.s = null;
    }

    public int length() {
        try {
            return this.d().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            return CryptoUtils.verifySignedASN1(this.d(), this.i);
        }
        catch (SignatureException signatureException) {
            throw new AuthenticationException(signatureException.toString());
        }
    }

    public void setIssuerCertificate(X509 x509) {
        this.q = x509;
        if (this.o == null) {
            this.o = x509.getSubject();
        }
        this.setPublicKey(x509.getPublicKey());
    }

    public CRL(X500Name x500Name, PrivateKey privateKey, Date date, Date date2, Vector vector) {
        this(x500Name, privateKey);
        this.setDates(date, date2);
        this.setRevokedCertificates(vector);
    }

    public Date getDate() {
        return this.n;
    }

    public void addCertificate(BigInteger bigInteger) {
        this.addCertificate(bigInteger, new Date());
    }

    public String toString() {
        String string = "issuer = " + this.o + ", thisUpdate = " + this.n;
        if (this.l != null) {
            string = string + ", nextUpdate = " + this.l;
        }
        string = string + ", revokedCertificates = {";
        Enumeration enumeration = this.j.elements();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)this.r.get(enumeration.nextElement());
            string = string + "(" + revokedCertificate + ")";
            if (!enumeration.hasMoreElements()) continue;
            string = string + ", ";
        }
        string = string + "}";
        if (this.m != null && this.m.size() > 0) {
            string = string + ", extensions = " + this.m;
        }
        return string;
    }

    public CRL(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.s == null) {
            this.sign();
        }
        return this.s;
    }

    public void setDates(int n) {
        this.setDates(new Date(), Utils.daysFromNow(n));
    }

    public void setIssuer(X500Name x500Name) {
        this.o = x500Name;
        this.f();
    }

    public X500Name getIssuer() {
        return this.o;
    }

    public void setDates(Date date, Date date2) {
        this.n = date;
        this.l = date2;
        this.f();
    }

    public Date getNextDate() {
        return this.l;
    }

    public void setExtensions(X509ExtensionSet x509ExtensionSet) {
        this.m = x509ExtensionSet;
        this.f();
    }

    public RevokedCertificate getRevokedCertificate(BigInteger bigInteger) {
        return this.r != null ? (RevokedCertificate)this.r.get(bigInteger) : null;
    }
}

