/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Boolean;
import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1String;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import java.math.BigInteger;
import java.util.Date;

public class ASN1Utils {
    public static final int[] oiwAlgID;
    public static final int[] pkcsID;
    public static final int[] rsaID;
    public static final int[] nistAlgorithms;
    public static final int[] xcmID;
    public static final int[] xkaID;
    public static final int[] entrustID;
    public static final int[] netscapeID;
    public static final int[] attrTypeID;
    public static final int[] dds;
    public static final int[] iana;
    public static final int[] phaosID;

    public static byte[] inputASN1BitString(ASN1Header aSN1Header, InputStream inputStream) throws IOException {
        return ASN1BitString.inputValue(new SequenceInputStream(Utils.toStream(aSN1Header), inputStream));
    }

    public static int lengthBase256(int n) {
        if (n >= 0x1000000) {
            return 4;
        }
        if (n >= 65536) {
            return 3;
        }
        if (n >= 256) {
            return 2;
        }
        return 1;
    }

    public static byte[] toBytesBase128(int n) {
        byte[] byArray = new byte[ASN1Utils.lengthBase128(n)];
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n >> 7 * n2 & 0x7F;
            if (n2 != 0) {
                n3 |= 0x80;
            }
            byArray[byArray.length - 1 - n2] = (byte)n3;
            --n2;
        }
        return byArray;
    }

    public static int lengthBase128(int n) {
        if (n >= 0x10000000) {
            return 5;
        }
        if (n >= 0x200000) {
            return 4;
        }
        if (n >= 16384) {
            return 3;
        }
        if (n >= 128) {
            return 2;
        }
        return 1;
    }

    public static ASN1Object inputASN1Object(byte[] byArray) throws IOException {
        return ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(byArray));
    }

    public static ASN1Object inputASN1Object(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        byte by = Utils.inputByte(pushbackInputStream);
        pushbackInputStream.unread(by);
        if ((by & 0xC0) == 0) {
            switch (by & 0x1F) {
                case 0: {
                    throw new ASN1FormatException("Unexpected end-of-contents octet.");
                }
                case 1: {
                    return new ASN1Boolean(pushbackInputStream);
                }
                case 2: {
                    return new ASN1Integer(pushbackInputStream);
                }
                case 3: {
                    return new ASN1BitString(pushbackInputStream);
                }
                case 4: {
                    return new ASN1OctetString(pushbackInputStream);
                }
                case 5: {
                    return new ASN1Null(pushbackInputStream);
                }
                case 6: {
                    return new ASN1ObjectID(pushbackInputStream);
                }
                case 16: {
                    return new ASN1Sequence(pushbackInputStream);
                }
                case 17: {
                    return new ASN1Set(pushbackInputStream);
                }
                case 12: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    return new ASN1String(pushbackInputStream);
                }
                case 23: 
                case 24: {
                    return new ASN1Date(pushbackInputStream);
                }
            }
        }
        if ((by & 0x20) == 0) {
            return new ASN1GenericPrimitive(pushbackInputStream);
        }
        return new ASN1GenericConstructed(pushbackInputStream);
    }

    public static void outputBase128(int n, OutputStream outputStream) throws IOException {
        int n2 = ASN1Utils.lengthBase128(n) - 1;
        while (n2 >= 0) {
            int n3 = n >> 7 * n2 & 0x7F;
            if (n2 != 0) {
                n3 |= 0x80;
            }
            outputStream.write(n3);
            --n2;
        }
    }

    public static Date inputASN1Date(ASN1Header aSN1Header, InputStream inputStream) throws IOException {
        return ASN1Date.inputValue(new SequenceInputStream(Utils.toStream(aSN1Header), inputStream));
    }

    private ASN1Utils() {
    }

    public static void outputHeader(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(n + n2 + 32);
        outputStream.write(128);
    }

    public static boolean isPrefix(int[] nArray, int[] nArray2) {
        if (nArray.length > nArray2.length) {
            return false;
        }
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void outputLengthBytes(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else {
            int n2 = n >= 0x1000000 ? 4 : (n >= 65536 ? 3 : (n >= 256 ? 2 : 1));
            outputStream.write(0x80 | n2);
            --n2;
            while (n2 >= 0) {
                outputStream.write(n >> 8 * n2 & 0xFF);
                --n2;
            }
        }
    }

    public static String inputASN1String(ASN1Header aSN1Header, InputStream inputStream) throws IOException {
        return ASN1String.inputValue(new SequenceInputStream(Utils.toStream(aSN1Header), inputStream));
    }

    public static byte[] inputASN1OctetString(ASN1Header aSN1Header, InputStream inputStream) throws IOException {
        return ASN1OctetString.inputValue(new SequenceInputStream(Utils.toStream(aSN1Header), inputStream));
    }

    public static int getTag(int n) {
        return n & 0x1F;
    }

    public static ASN1Object addImplicitTag(ASN1Object aSN1Object, int n) {
        try {
            InputStream inputStream = Utils.toStream(aSN1Object);
            ASN1Header aSN1Header = new ASN1Header(inputStream);
            if (aSN1Header.getEncodingMethod() == 0) {
                return new ASN1GenericPrimitive(aSN1Header.readBody(inputStream), n);
            }
            ASN1Header aSN1Header2 = new ASN1Header(n, 128, aSN1Header.getEncodingMethod(), aSN1Header.getBodyLength());
            return new ASN1GenericConstructed(new SequenceInputStream(Utils.toStream(aSN1Header2), inputStream));
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException.toString());
        }
    }

    public static void outputEndOfContents(OutputStream outputStream) throws IOException {
        outputStream.write(0);
        outputStream.write(0);
    }

    public static int[] inputASN1ObjectID(ASN1Header aSN1Header, InputStream inputStream) throws IOException {
        return ASN1ObjectID.inputValue(new SequenceInputStream(Utils.toStream(aSN1Header), inputStream));
    }

    static {
        rsaID = new int[]{1, 2, 840, 113549};
        netscapeID = new int[]{2, 16, 840, 1, 113730};
        entrustID = new int[]{1, 2, 840, 113533, 7};
        phaosID = new int[]{1, 3, 6, 1, 4, 1, 2518};
        pkcsID = new int[]{1, 2, 840, 113549, 1};
        attrTypeID = new int[]{2, 5, 4};
        oiwAlgID = new int[]{1, 3, 14, 3, 2};
        xcmID = new int[]{1, 2, 840, 10040, 4};
        xkaID = new int[]{1, 2, 840, 10046};
        iana = new int[]{1, 3, 6, 1, 5, 5, 8};
        nistAlgorithms = new int[]{2, 16, 840, 1, 101, 3, 4};
        dds = new int[]{1, 3, 6, 1, 4, 1, 3029};
    }

    public static int inputBase128(InputStream inputStream) throws IOException {
        byte by;
        int n = 0;
        int n2 = 0;
        do {
            if (n2 > 4 || (n & 0xFF000000) != 0) {
                throw new InvalidInputException("Component too large.");
            }
            by = Utils.inputByte(inputStream);
            n <<= 7;
            n |= by & 0x7F;
            ++n2;
        } while ((by & 0x80) != 0);
        return n;
    }

    public static BigInteger inputASN1Integer(ASN1Header aSN1Header, InputStream inputStream) throws IOException {
        return ASN1Integer.inputValue(new SequenceInputStream(Utils.toStream(aSN1Header), inputStream));
    }
}

