/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1String
implements ASN1TaggedObject {
    private static final int g = 22;
    private String h;
    private byte[] i;
    private ASN1Header j;

    public ASN1String(String string, int n) {
        this.b(string, n);
    }

    public ASN1Header getHeader() {
        return this.j;
    }

    private static void a(OutputStream outputStream, String string, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        if (n == 12) {
            byte[] byArray = Utils.toUTF8(string);
            ASN1Utils.outputLengthBytes(outputStream, byArray.length);
            outputStream.write(byArray);
        } else if (n == 30) {
            ASN1Utils.outputLengthBytes(outputStream, 2 * string.length());
            ASN1String.c(outputStream, string);
        } else {
            ASN1Utils.outputLengthBytes(outputStream, string.length());
            ASN1String.f(outputStream, string);
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        this.j.output(outputStream);
        int n = this.j.getTag();
        if (n == 12) {
            outputStream.write(this.i);
        } else if (n == 30) {
            ASN1String.c(outputStream, this.h);
        } else if (n == 28) {
            ASN1String.d(outputStream, this.h);
        } else {
            ASN1String.f(outputStream, this.h);
        }
    }

    public ASN1String(String string) {
        this.b(string, 22);
    }

    public int length() {
        return this.j.totalLength();
    }

    public int getTag() {
        return this.j.getTag();
    }

    private void b(String string, int n) {
        int n2;
        this.h = string;
        if (n == 12) {
            this.i = Utils.toUTF8(string);
            n2 = this.i.length;
        } else {
            n2 = n == 30 ? 2 * string.length() : (n == 28 ? 4 * string.length() : string.length());
        }
        this.j = new ASN1Header(n, 0, 0, n2);
    }

    private static void c(OutputStream outputStream, String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            outputStream.write((byte)(c >> 8));
            outputStream.write((byte)c);
            ++n;
        }
    }

    public String getValue() {
        return this.h;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.j.getTag()) {
            case 19: {
                stringBuffer.append("PrintableString");
                break;
            }
            case 20: {
                stringBuffer.append("T61String");
                break;
            }
            case 22: {
                stringBuffer.append("IA5String");
                break;
            }
            case 25: {
                stringBuffer.append("GraphicString");
                break;
            }
            case 26: {
                stringBuffer.append("VisibleString");
                break;
            }
            case 27: {
                stringBuffer.append("GeneralString");
                break;
            }
            case 30: {
                stringBuffer.append("BMPString");
                break;
            }
            case 28: {
                stringBuffer.append("UniversalString");
                break;
            }
            case 12: {
                stringBuffer.append("UTF8String");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ASN.1 string type.");
            }
        }
        stringBuffer.append(" \"");
        stringBuffer.append(this.h);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static void outputValue(OutputStream outputStream, String string) throws IOException {
        ASN1String.a(outputStream, string, 22, 0);
    }

    private static void d(OutputStream outputStream, String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            outputStream.write((byte)(c >> 24));
            outputStream.write((byte)(c >> 16));
            outputStream.write((byte)(c >> 8));
            outputStream.write((byte)c);
            ++n;
        }
    }

    public ASN1String(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private static int e(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        int n = aSN1Header.getTag();
        if (n != 19 && n != 20 && n != 22 && n != 25 && n != 26 && n != 27 && n != 30 && n != 28 && n != 12) {
            throw new ASN1FormatException("Got tag " + n + " instead of an ASN.1 string type.");
        }
        if (aSN1Header.getEncodingMethod() == 0) {
            byte[] byArray = aSN1Header.readBody(inputStream);
            if (n == 30) {
                int n2 = 0;
                int n3 = byArray.length - 1;
                while (n2 < n3) {
                    stringBuffer.append((char)(byArray[n2] << 8 | byArray[n2 + 1] & 0xFF));
                    n2 += 2;
                }
            } else if (n == 28) {
                int n4 = 0;
                int n5 = byArray.length - 1;
                while (n4 < n5) {
                    stringBuffer.append((char)(byArray[n4] << 24 | byArray[n4 + 1] << 16 | byArray[n4 + 2] << 8 | byArray[n4 + 3] & 0xFF));
                    n4 += 4;
                }
            } else if (n == 12) {
                stringBuffer.append(Utils.fromUTF8(byArray));
            } else {
                int n6 = 0;
                int n7 = byArray.length;
                while (n6 < n7) {
                    stringBuffer.append((char)(byArray[n6] & 0xFF));
                    ++n6;
                }
            }
        } else {
            ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
            while (aSN1ConstructedInputStream.hasMoreData()) {
                int n8 = ASN1String.e(inputStream, stringBuffer);
                if (n8 == n) continue;
                throw new ASN1FormatException("Got tag " + n8 + " instead of " + n + ".");
            }
            aSN1ConstructedInputStream.terminate();
        }
        return n;
    }

    private static void f(OutputStream outputStream, String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            outputStream.write((byte)string.charAt(n));
            ++n;
        }
    }

    public static String inputValue(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        ASN1String.e(inputStream, stringBuffer);
        return stringBuffer.toString();
    }

    public void input(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ASN1String.e(inputStream, stringBuffer);
        this.b(stringBuffer.toString(), n);
    }

    public static void outputValue(OutputStream outputStream, String string, int n) throws IOException {
        ASN1String.a(outputStream, string, n, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, String string, int n) throws IOException {
        ASN1String.a(outputStream, string, n, 128);
    }
}

