/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Header
implements Streamable,
ASN1 {
    private int g;
    private int h;
    private int i;
    private int j;

    public byte[] headerAndBody(InputStream inputStream) throws IOException {
        byte[] byArray = this.readBody(inputStream);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length() + byArray.length);
        this.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(byArray);
        return fixedByteArrayOutputStream.toByteArray();
    }

    public ASN1Header(int n, int n2, int n3, int n4) {
        this.g = n;
        this.i = n2;
        this.j = n3;
        this.h = n4;
    }

    public int getEncodingMethod() {
        return this.j;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a(outputStream);
        this.d(outputStream);
    }

    public void checkTag(int n) throws ASN1FormatException {
        if (this.g != n) {
            throw new ASN1FormatException("Got tag " + this.g + " instead of " + n + ".");
        }
    }

    public void input(InputStream inputStream) throws IOException {
        this.f(inputStream);
        this.b(inputStream);
    }

    public ASN1Header() {
    }

    public int totalLength() {
        return this.length() + this.h;
    }

    void a(OutputStream outputStream) throws IOException {
        int n = this.g < 31 ? this.g : 31;
        int n2 = this.i | n;
        if (this.j != 0) {
            n2 |= 0x20;
        }
        outputStream.write(n2);
        if (this.g >= 31) {
            ASN1Utils.outputBase128(this.g, outputStream);
        }
    }

    public byte[] readBody(InputStream inputStream) throws IOException {
        if (this.j != 2) {
            byte[] byArray = new byte[this.h];
            Utils.inputByteArray(byArray, inputStream);
            return byArray;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        while (true) {
            ASN1Header aSN1Header = new ASN1Header();
            aSN1Header.input(inputStream);
            if (aSN1Header.i == 0 && aSN1Header.g == 0 && aSN1Header.h == 0) break;
            aSN1Header.output(unsyncByteArrayOutputStream);
            unsyncByteArrayOutputStream.write(aSN1Header.readBody(inputStream));
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String tagToString(int n) {
        String[] stringArray = new String[]{"END OF CONTENTS", "BOOLEAN", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "ObjectDescriptor", "EXTERNAL", "REAL", "ENUMERATED", "11", "12", "13", "14", "15", "SEQUENCE", "SET", "NumericString", "PrintableString", "T61String", "VideotexString", "IA5String", "UTCTime", "GeneralizedTime", "GraphicString", "VisibleString", "GeneralString", "UniversalString", "29", "BMPString"};
        return n < stringArray.length ? stringArray[n] : Integer.toString(n);
    }

    public void checkTagClass(int n) throws ASN1FormatException {
        if (this.i != n) {
            throw new ASN1FormatException("Got tag class " + this.tagClassToString(this.i) + " instead of " + this.tagClassToString(n) + ".");
        }
    }

    public void skipBody(InputStream inputStream) throws IOException {
        if (this.j != 2) {
            int n = 0;
            while (n < this.h) {
                Utils.inputByte(inputStream);
                ++n;
            }
        } else {
            while (true) {
                ASN1Header aSN1Header = new ASN1Header();
                aSN1Header.input(inputStream);
                if (aSN1Header.i == 0 && aSN1Header.g == 0 && aSN1Header.h == 0) break;
                aSN1Header.skipBody(inputStream);
            }
        }
    }

    public int length() {
        return this.e() + this.c();
    }

    void b(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        if (n < 128) {
            this.h = n;
        } else if (n == 128) {
            this.j = 2;
            this.h = -1;
        } else {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new ASN1FormatException("Length is too big: takes " + n2 + " bytes");
            }
            this.h = 0;
            int n3 = 0;
            while (n3 < n2) {
                this.h <<= 8;
                this.h |= Utils.inputByte(inputStream) & 0xFF;
                ++n3;
            }
        }
    }

    public ASN1Header(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Header(int n, int n2) {
        this(n, n2, 2, -1);
    }

    public int getTagClass() {
        return this.i;
    }

    public void checkEncodingMethod(int n) throws ASN1FormatException {
        if (this.j != n) {
            throw new ASN1FormatException("Got encoding method " + this.encodingMethodToString(this.j) + " instead of " + this.encodingMethodToString(n) + ".");
        }
    }

    int c() {
        return 1 + (this.h < 128 ? 0 : ASN1Utils.lengthBase256(this.h));
    }

    public String encodingMethodToString(int n) {
        String[] stringArray = new String[]{"primitive", "constructed", "constructed"};
        return stringArray[n];
    }

    void d(OutputStream outputStream) throws IOException {
        if (this.j == 2) {
            outputStream.write(128);
        } else {
            ASN1Utils.outputLengthBytes(outputStream, this.h);
        }
    }

    int e() {
        return 1 + (this.g < 31 ? 0 : ASN1Utils.lengthBase128(this.g));
    }

    void f(InputStream inputStream) throws IOException {
        int n = Utils.inputByte(inputStream) & 0xFF;
        this.i = n & 0xC0;
        this.j = (n & 0x20) == 0 ? 0 : 1;
        this.g = n & 0x1F;
        if (this.g == 31) {
            this.g = ASN1Utils.inputBase128(inputStream);
        }
    }

    public String tagClassToString(int n) {
        String[] stringArray = new String[]{"universal", "application", "context-specific", "private"};
        return stringArray[n >> 6];
    }

    public int getBodyLength() {
        return this.h;
    }

    public String toString() {
        return this.tagClassToString(this.i) + " " + (this.i == 0 ? this.tagToString(this.g) : Integer.toString(this.g)) + " " + this.encodingMethodToString(this.j) + " length=" + (this.j == 2 ? "unknown" : Integer.toString(this.h));
    }

    public int getTag() {
        return this.g;
    }
}

