/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ASN1BitString
implements ASN1TaggedObject {
    private byte[] c;
    private ASN1Header d;
    private int e;

    private static void a(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, byArray.length + 1);
        outputStream.write(0);
        outputStream.write(byArray);
    }

    public int intValue() {
        if (this.c.length == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (n2 == this.c.length - 1) {
                n += (this.c[n2] & 0xFF & 255 << this.e) << 8 * (3 - n2);
                break;
            }
            n += (this.c[n2] & 0xFF) << 8 * (3 - n2);
            ++n2;
        }
        int n3 = 0;
        int n4 = this.bitLength();
        int n5 = 0;
        while (n5 < n4) {
            n3 += (n & Integer.MIN_VALUE) != 0 ? 1 << n5 : 0;
            n <<= 1;
            ++n5;
        }
        return n3;
    }

    public boolean testBit(int n) {
        if (n < 0 || n >= 8 * this.c.length - this.e) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        return (this.c[n / 8] & 1 << 7 - n % 8) != 0;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.d.output(outputStream);
        outputStream.write(this.e);
        if (this.e == 0) {
            outputStream.write(this.c);
        } else {
            outputStream.write(this.c, 0, this.c.length - 1);
            outputStream.write(this.c[this.c.length - 1] & 255 << this.e & 0xFF);
        }
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        ASN1BitString.a(outputStream, byArray, n, 128);
    }

    public ASN1BitString(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1BitString(byte[] byArray) {
        this.b(byArray, 0);
    }

    private void b(byte[] byArray, int n) {
        if (byArray.length == 0) {
            n = 0;
        }
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        this.c = byArray;
        this.e = n;
        this.d = new ASN1Header(3, 0, 0, byArray.length + 1);
    }

    public ASN1BitString() {
        this(new byte[0], 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BIT STRING ");
        stringBuffer.append(Utils.toHexString(this.c));
        if (this.e != 0) {
            stringBuffer.append("(" + this.e + " unused)");
        }
        return stringBuffer.toString();
    }

    public int getUnused() {
        return this.e;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(3);
        if (aSN1Header.getEncodingMethod() == 0) {
            if (aSN1Header.getBodyLength() == 0) {
                throw new ASN1FormatException("Body is empty.");
            }
            this.e = Utils.inputByte(inputStream) & 7;
            this.b(Utils.inputBytes(inputStream, aSN1Header.getBodyLength() - 1), this.e);
        } else {
            int n = 0;
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
            while (aSN1ConstructedInputStream.hasMoreData()) {
                ASN1BitString aSN1BitString = new ASN1BitString(aSN1ConstructedInputStream);
                if (n != 0) {
                    throw new ASN1FormatException("Illegal encoding of bit-string.");
                }
                unsyncByteArrayOutputStream.write(aSN1BitString.getValue());
                n = aSN1BitString.getUnused();
            }
            aSN1ConstructedInputStream.terminate();
            this.b(unsyncByteArrayOutputStream.toByteArray(), n);
        }
    }

    public byte[] getValue() {
        return this.c;
    }

    public ASN1BitString(BigInteger bigInteger) {
        this(bigInteger.bitLength());
        int n = this.bitLength();
        int n2 = 0;
        while (n2 < n) {
            if (bigInteger.testBit(n2)) {
                this.setBit(n2);
            }
            ++n2;
        }
    }

    public ASN1BitString(byte[] byArray, int n) {
        this.b(byArray, n);
    }

    public ASN1Header getHeader() {
        return this.d;
    }

    public int bitLength() {
        return 8 * this.c.length - this.e;
    }

    public void setBit(int n) {
        if (n < 0 || n >= 8 * this.c.length - this.e) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        int n2 = n / 8;
        this.c[n2] = (byte)(this.c[n2] | 1 << 7 - n % 8);
    }

    public ASN1BitString(int n) {
        int n2 = n == 0 ? 0 : (n - 1) / 8 + 1;
        this.b(new byte[n2], 8 * n2 - n);
    }

    public static byte[] inputValue(InputStream inputStream) throws IOException {
        return new ASN1BitString(inputStream).getValue();
    }

    public void clearBit(int n) {
        if (n < 0 || n >= 8 * this.c.length - this.e) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        int n2 = n / 8;
        this.c[n2] = (byte)(this.c[n2] & ~(1 << 7 - n % 8));
    }

    public int length() {
        return this.d.totalLength();
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray) throws IOException {
        ASN1BitString.a(outputStream, byArray, 3, 0);
    }
}

