/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.bean;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import oracle.sql.NUMBER;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBNode;

public class XMLTypeBean
extends XDBElement {
    private long m_kidnum;

    private native int getKidBytesIntNative(long var1, long var3);

    private native short getKidBytesShortNative(long var1, long var3);

    private native long getKidBytesLongNative(long var1, long var3);

    private native byte getKidBytesByteNative(long var1, long var3);

    private native byte[] getKidBytesNumberNative(long var1, long var3);

    private native String getKidBytesStringNative(long var1, long var3);

    private native boolean getKidBytesBooleanNative(long var1, long var3);

    private native float getKidBytesFloatNative(long var1, long var3);

    private native void setKidBytesIntNative(long var1, long var3, int var5);

    private native void setKidBytesShortNative(long var1, long var3, short var5);

    private native void setKidBytesLongNative(long var1, long var3, long var5);

    private native void setKidBytesByteNative(long var1, long var3, byte var5);

    private native void setKidBytesNumberNative(long var1, long var3, byte[] var5);

    private native void setKidBytesStringNative(long var1, long var3, String var5);

    private native void setKidBytesFloatNative(long var1, long var3, float var5);

    private native void setKidBytesBooleanNative(long var1, long var3, boolean var5);

    private native long getElementNative(long var1, long var3);

    private native void setElementNative(long var1, long var3, long var5);

    private native long childOccursMultipleNative(long var1, long var3);

    private native long getNumElemArrNative(long var1);

    private native long getArrayElemAtNative(long var1, long var3);

    private native void setElemVectorNative(long var1, long var3, long[] var5);

    private native boolean getKidBytesDateNative(long var1, long var3, int[] var5);

    private native void setKidBytesDateNative(long var1, long var3, int[] var5);

    public void setKidNum(long kidnum) {
        this.m_kidnum = kidnum;
    }

    public XMLTypeBean(XDBDocument owner, long xob, long kidnum) {
        super(owner, xob);
        this.m_kidnum = kidnum;
    }

    public XMLTypeBean(XDBDocument owner, long kidnum) {
        super(owner, 0L);
        this.m_kidnum = kidnum;
    }

    public void setNodeXob(int propnum) {
        XMLTypeBean node = this;
        ((XDBNode)node).setNodeXob(propnum);
    }

    public int getScalarint(int kidnum) {
        return this.getKidBytesIntNative(this.toCState(), kidnum);
    }

    public long getScalarlong(int kidnum) {
        return this.getKidBytesLongNative(this.toCState(), kidnum);
    }

    public short getScalarshort(int kidnum) {
        return this.getKidBytesShortNative(this.toCState(), kidnum);
    }

    public byte getScalarbyte(int kidnum) {
        return this.getKidBytesByteNative(this.toCState(), kidnum);
    }

    public BigDecimal getScalarBigDecimal(int kidnum) {
        try {
            byte[] numarray = this.getKidBytesNumberNative(this.toCState(), kidnum);
            return NUMBER.toBigDecimal((byte[])numarray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getScalarString(int kidnum) {
        return this.getKidBytesStringNative(this.toCState(), kidnum);
    }

    public boolean getScalarboolean(int kidnum) {
        return this.getKidBytesBooleanNative(this.toCState(), kidnum);
    }

    public float getScalarfloat(int kidnum) {
        return this.getKidBytesFloatNative(this.toCState(), kidnum);
    }

    public Date getScalarDate(int kidnum) {
        int[] dateval = new int[6];
        if (this.getKidBytesDateNative(this.toCState(), kidnum, dateval)) {
            Calendar cal = Calendar.getInstance();
            cal.set(dateval[0], dateval[1], dateval[2], dateval[3], dateval[4], dateval[5]);
            return cal.getTime();
        }
        return null;
    }

    public void setScalar(int kidnum, Date val) {
        int[] dateval = new int[6];
        Calendar cal = Calendar.getInstance();
        cal.setTime(val);
        dateval[0] = cal.get(1);
        dateval[1] = cal.get(2);
        dateval[2] = cal.get(5);
        dateval[3] = cal.get(11);
        dateval[4] = cal.get(12);
        dateval[5] = cal.get(13);
        this.setKidBytesDateNative(this.toCState(), kidnum, dateval);
    }

    public void setScalar(int kidnum, int val) {
        this.setKidBytesIntNative(this.toCState(), kidnum, val);
    }

    public void setScalar(int kidnum, short val) {
        this.setKidBytesShortNative(this.toCState(), kidnum, val);
    }

    public void setScalar(int kidnum, long val) {
        this.setKidBytesLongNative(this.toCState(), kidnum, val);
    }

    public void setScalar(int kidnum, byte val) {
        this.setKidBytesByteNative(this.toCState(), kidnum, val);
    }

    public void setScalar(int kidnum, BigDecimal val) {
        try {
            this.setKidBytesNumberNative(this.toCState(), kidnum, NUMBER.toBytes((BigDecimal)val));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setScalar(int kidnum, float val) {
        this.setKidBytesFloatNative(this.toCState(), kidnum, val);
    }

    public void setScalar(int kidnum, boolean val) {
        this.setKidBytesBooleanNative(this.toCState(), kidnum, val);
    }

    public void setScalar(int kidnum, String val) {
        this.setKidBytesStringNative(this.toCState(), kidnum, val);
    }

    public boolean isVector(long kidnum) {
        long arrcstate = this.childOccursMultipleNative(this.toCState(), kidnum);
        return arrcstate != 0L;
    }

    public long getChildArray(long kidnum) {
        return this.childOccursMultipleNative(this.toCState(), kidnum);
    }

    public long getNumChildArray(long arrcstate) {
        return this.getNumElemArrNative(arrcstate);
    }

    public long getChildElemAt(long arrcstate, int index) {
        return this.getArrayElemAtNative(arrcstate, index);
    }

    public long getElem(int kidnum) {
        return this.getElementNative(this.toCState(), kidnum);
    }

    public void setElem(int kidnum, Object obj) {
        long arrcstate = 0L;
        arrcstate = this.childOccursMultipleNative(this.toCState(), kidnum);
        if (arrcstate != 0L) {
            Vector v = (Vector)obj;
            int vecsize = v.size();
            long[] xobarray = new long[vecsize];
            for (int i = 0; i < vecsize; ++i) {
                xobarray[i] = ((XMLTypeBean)v.elementAt(i)).toCState();
            }
            this.setElemVectorNative(this.toCState(), kidnum, xobarray);
        } else {
            XMLTypeBean beanclass = (XMLTypeBean)obj;
            this.setElementNative(this.toCState(), kidnum, beanclass.toCState());
        }
    }
}

