/*
 * Decompiled with CFR 0.152.
 */
package ice.xslt;

import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.util.ICEException;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.w3c.dom.Node;

public class XalanTransformer
implements ice.pilots.html4.Transformer {
    protected XalanTransformer() {
    }

    public boolean transform(Node node, Node node2, Node node3) throws IOException {
        this.doTransform(node, node2, node3);
        return true;
    }

    public boolean transform(Node node, Node node2, Writer writer) throws IOException {
        DNode dNode = (DNode)node;
        DDocument dDocument = dNode.getOwnerDDocument();
        DDocument dDocument2 = dDocument.getDom().createDDocument(dDocument.getPilot(), false);
        this.doTransform(node, node2, dDocument2);
        this.doSerialize(dDocument2, writer);
        return true;
    }

    private void doTransform(final Node node, final Node node2, final Node node3) throws IOException {
        BoxedCode boxedCode = new BoxedCode(){

            public Object run() {
                try {
                    XalanTransformer.this.doTransformImpl(node, node2, node3);
                    return null;
                }
                catch (TransformerException transformerException) {
                    if (Debug.ex) {
                        Debug.ex(transformerException);
                    }
                    throw new ProxyException(transformerException);
                }
            }
        };
        try {
            SecurityKit.doPrivileged(boxedCode);
        }
        catch (ProxyException proxyException) {
            throw new ICEException(1, 4, 17);
        }
    }

    void doTransformImpl(Node node, Node node2, Node node3) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new DOMSource(node2));
        DOMSource dOMSource = new DOMSource(node);
        DOMResult dOMResult = new DOMResult(node3);
        transformer.transform(dOMSource, dOMResult);
    }

    private void doSerialize(final Node node, final Writer writer) throws IOException {
        BoxedCode boxedCode = new BoxedCode(){

            public Object run() {
                try {
                    XalanTransformer.this.doSerializeImpl(node, writer);
                    return null;
                }
                catch (IOException iOException) {
                    if (Debug.ex) {
                        Debug.ex(iOException);
                    }
                    throw new ProxyException(iOException);
                }
            }
        };
        try {
            SecurityKit.doPrivileged(boxedCode);
        }
        catch (ProxyException proxyException) {
            throw (IOException)proxyException.getTarget();
        }
    }

    void doSerializeImpl(Node node, Writer writer) throws IOException {
        Serializer serializer = SerializerFactory.getSerializer((Properties)OutputProperties.getDefaultMethodProperties((String)"xml"));
        serializer.setWriter(writer);
        serializer.asDOMSerializer().serialize(node);
    }
}

