/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import ice.util.io.IOKit;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import ice.util.security.jdk11.JarCache_jdk11;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

final class URLClassLoader_jdk11
extends ClassLoader {
    private URL codebase = null;
    private URL[] urls = null;
    ThreadGroup _threadGroup;

    URLClassLoader_jdk11(URL[] uRLArray) {
        this.urls = uRLArray;
        this.codebase = uRLArray[0];
        int n = 1;
        while (n < uRLArray.length) {
            JarCache_jdk11.getInstance().addJarFile(uRLArray[n]);
            ++n;
        }
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                return this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    String string2 = string.replace('.', '/') + ".class";
                    byte[] byArray = this.getResourceAsByteArray(string2);
                    if (byArray != null) {
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class <" + string + "> not found anywhere");
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public byte[] getResourceAsByteArray(String string) {
        byte[] byArray;
        block6: {
            Object object;
            byArray = null;
            if (this.urls.length > 1) {
                object = "jar:" + this.urls[1] + "!/" + string;
                byArray = JarCache_jdk11.getInstance().getResource((String)object);
            }
            if (byArray == null && this.codebase != null) {
                try {
                    object = new URL(this.codebase, string);
                    InputStream inputStream = this.getInputStream((URL)object);
                    if (inputStream == null) break block6;
                    try {
                        byArray = IOKit.readAll(inputStream);
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block6;
                    Debug.ex(iOException);
                }
            }
        }
        return byArray;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        if (this.urls.length > 1) {
            try {
                uRL = new URL("jar://" + this.urls[1].toString() + "!/" + string);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.codebase != null) {
            try {
                uRL = new URL(this.codebase, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        Object object;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        if (this.urls.length > 1 && (object = this.getResourceAsByteArray(string)) != null) {
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        if (inputStream == null && this.codebase != null && (object = (Object)this.getResource(string)) != null) {
            inputStream = this.getInputStream((URL)object);
        }
        return inputStream;
    }

    private InputStream getInputStream(URL uRL) {
        URLConnection uRLConnection;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            if (Debug.ex) {
                Debug.ex(iOException);
            }
            return null;
        }
        return (InputStream)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return URLClassLoader_jdk11.this.do_getInputStream(uRLConnection);
            }
        });
    }

    private InputStream do_getInputStream(URLConnection uRLConnection) {
        InputStream inputStream;
        try {
            HttpURLConnection httpURLConnection;
            int n;
            inputStream = uRLConnection.getInputStream();
            if (uRLConnection instanceof HttpURLConnection && (n = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                inputStream = null;
            }
        }
        catch (IOException iOException) {
            if (Debug.ex) {
                Debug.ex(iOException);
            }
            inputStream = null;
        }
        return inputStream;
    }

    URL getSecurityContext() {
        return this.codebase;
    }
}

