/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import ice.debug.Debug;
import ice.util.net.VetoProtocol;
import java.lang.reflect.Method;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class URLStreamHandlerFactory
implements java.net.URLStreamHandlerFactory {
    private static final Object NOT_INIT_TAG;
    private static Hashtable handlerStorage;
    private static Hashtable vetoedProtocols;

    public URLStreamHandlerFactory() {
        URLStreamHandlerFactory.init();
    }

    public static void init() {
        if (handlerStorage != null) {
            return;
        }
        handlerStorage = new Hashtable();
        vetoedProtocols = new Hashtable();
        URLStreamHandlerFactory.addStreamHandler("dom", "ice.pilots.domviewer.Handler");
        URLStreamHandlerFactory.addStreamHandler("about", "ice.storm.AboutHandler");
    }

    public static void unload() {
        handlerStorage.clear();
        vetoedProtocols.clear();
        handlerStorage = null;
        vetoedProtocols = null;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler;
        block6: {
            if (vetoedProtocols.get(string) != null) {
                return new VetoProtocol();
            }
            uRLStreamHandler = null;
            Class clazz = URLStreamHandlerFactory.getProtocolClass(string);
            if (clazz != null) {
                try {
                    uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (Debug.ex) {
                        Debug.ex(illegalAccessException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (!Debug.ex) break block6;
                    Debug.ex(instantiationException);
                }
            }
        }
        return uRLStreamHandler;
    }

    private static Class nameToClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Debug.ex) {
                Debug.ex(classNotFoundException);
            }
            return null;
        }
    }

    private static Class getProtocolClass(String string) {
        String string2;
        Class clazz = null;
        Object v = handlerStorage.get(string);
        if (v instanceof Class) {
            clazz = (Class)v;
        } else if (v != null && (clazz = URLStreamHandlerFactory.nameToClass(string2 = (String)v)) != null) {
            handlerStorage.put(string, clazz);
        }
        return clazz;
    }

    public static void addStreamHandler(String string, String string2) {
        if (handlerStorage == null) {
            URLStreamHandlerFactory.init();
        }
        handlerStorage.put(string, string2);
    }

    public static void addStreamHandler(String string, Class clazz) {
        if (handlerStorage == null) {
            URLStreamHandlerFactory.init();
        }
        handlerStorage.put(string, clazz);
    }

    public static void removeStreamHandler(String string) {
        if (handlerStorage == null) {
            URLStreamHandlerFactory.init();
        }
        handlerStorage.remove(string);
    }

    public static void vetoProtocol(String string) {
        if (handlerStorage == null) {
            URLStreamHandlerFactory.init();
        }
        vetoedProtocols.put(string, string);
    }

    public static void unVetoProtocol(String string) {
        if (handlerStorage == null) {
            URLStreamHandlerFactory.init();
        }
        vetoedProtocols.remove(string);
    }

    public static Class get(String string) {
        if (handlerStorage == null) {
            URLStreamHandlerFactory.init();
        }
        if (vetoedProtocols.get(string) != null) {
            return null;
        }
        return URLStreamHandlerFactory.getProtocolClass(string);
    }

    public static void closeAllConnections() {
        Enumeration enumeration = handlerStorage.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof Class)) continue;
            Class clazz = (Class)v;
            try {
                Method method = clazz.getMethod("closeAll", null);
                method.invoke(null, null);
            }
            catch (Exception exception) {
                if (!Debug.ex) continue;
                Debug.ex(exception);
            }
        }
    }

    static {
        block2: {
            NOT_INIT_TAG = Boolean.FALSE;
            handlerStorage = null;
            vetoedProtocols = null;
            try {
                Properties properties = System.getProperties();
                ((Hashtable)properties).put("hotjava.file.iconwidth", "30");
                ((Hashtable)properties).put("hotjava.file.iconheight", "24");
            }
            catch (Exception exception) {
                if (!Debug.ex) break block2;
                Debug.ex(exception);
            }
        }
    }
}

