/*
 * Decompiled with CFR 0.152.
 */
package ice.util.image;

import ice.util.image.IceImageObserver;
import ice.util.image.ImageObserverProxy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;

public class ImageProxy {
    byte[] realImageData = null;
    private Image theImage = null;
    private ImageObserverProxy theObserver = null;

    ImageProxy(Image image) {
        this.theImage = image;
    }

    public Image getImage() {
        return this.theImage;
    }

    public ImageObserver registerListener(IceImageObserver iceImageObserver) {
        if (this.theObserver != null) {
            this.theObserver.registerListener(iceImageObserver);
            return this.theObserver;
        }
        return null;
    }

    void setImageObserver(ImageObserverProxy imageObserverProxy) {
        this.theObserver = imageObserverProxy;
    }

    public int getHeight(ImageObserver imageObserver) {
        if (this.theImage != null) {
            return this.theImage.getHeight(imageObserver);
        }
        return -1;
    }

    public int getWidth(ImageObserver imageObserver) {
        if (this.theImage != null) {
            return this.theImage.getWidth(imageObserver);
        }
        return -1;
    }

    public ImageProducer getSource() {
        return null;
    }

    public Graphics getGraphics() {
        if (this.theImage != null) {
            return this.theImage.getGraphics();
        }
        return null;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if (this.theImage != null) {
            return this.theImage.getProperty(string, imageObserver);
        }
        return null;
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (this.theImage != null) {
            return this.theImage.getScaledInstance(n, n2, n3);
        }
        return null;
    }

    public void flush() {
        if (this.theImage != null) {
            this.theImage.flush();
            this.theImage = null;
        }
        if (this.theObserver != null) {
            this.theObserver.dispose();
            this.theObserver = null;
        }
    }

    public boolean compareImage(Image image) {
        return image == this.theImage;
    }
}

