/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.util.alg.Bidi;

class Bidi_WINDOWS_1255
extends Bidi {
    private static final int LET = 0;
    private static final int NUM = 1;
    private static final int HEB = 2;
    private static final int SEP = 3;
    private static final int MIR = 4;
    private static final int NOR = 5;
    private static final int WSP = 6;
    private static final int NEQ = 7;
    private static final int NSP = 8;
    private static final int TURN = 0;
    private static final int LEAVE = 1;
    private static final int STATE_HEBREW = 0;
    private static final int STATE_ENGLISH = 1;
    private static final byte[] charMap = new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 3, 5, 7, 7, 7, 5, 5, 4, 4, 5, 5, 3, 5, 3, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 4, 5, 4, 3, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 4, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 4, 5, 5};
    private static final char lastChar = '~';
    private int[] types;
    private int pos;

    protected Bidi_WINDOWS_1255(int n, char[] cArray, int n2, int n3) {
        super(n, cArray, n2, n3);
    }

    protected void reset() {
        this.types = null;
        this.pos = 0;
    }

    private static boolean isHebrew(char c) {
        return c > '~';
    }

    private int findFirstEnglishIndex(int n, boolean bl) {
        if (n == this.startPos || n == this.endPos - 1) {
            return -1;
        }
        int n2 = bl ? 1 : -1;
        int n3 = n + n2;
        while (true) {
            if (n3 == this.startPos || n3 == this.endPos - 1) break;
            char c = this.buf[n3];
            switch (charMap[c]) {
                case 0: 
                case 1: 
                case 7: {
                    return n3;
                }
            }
            n3 += n2;
        }
        n3 = -1;
        return n3;
    }

    private void changeBackwardsToHebrew(int n, int n2) {
        int n3 = this.findFirstEnglishIndex(n, false);
        if (n3 < 0) {
            System.out.println("!!!! ERROR");
        }
        int n4 = ++n3 - this.startPos;
        while (n4 <= n2) {
            this.types[n4] = 0;
            ++n4;
        }
    }

    private void getTypes() {
        int n = this.endPos - this.startPos;
        this.types = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.types[n2] = 0;
            ++n2;
        }
        boolean bl = false;
        int n3 = 2;
        int n4 = 2;
        int n5 = this.startPos;
        while (n5 < this.endPos) {
            char c;
            char c2 = this.buf[n5];
            int n6 = n5 - this.startPos;
            int n7 = 2;
            n4 = n5 + 1 < this.endPos ? (Bidi_WINDOWS_1255.isHebrew(c = this.buf[n5 + 1]) ? 2 : charMap[c]) : 2;
            if (Bidi_WINDOWS_1255.isHebrew(c2)) {
                if (bl) {
                    this.changeBackwardsToHebrew(n5, n6);
                    bl = false;
                }
            } else {
                n7 = charMap[c2];
                switch (n7) {
                    case 0: {
                        if (!bl) {
                            bl = true;
                        }
                        this.types[n6] = 1;
                        break;
                    }
                    case 7: {
                        if (bl) {
                            if (n3 != 0 && n3 != 1 && n4 != 0 && n4 != 1) {
                                this.changeBackwardsToHebrew(n5, n6);
                                bl = false;
                                break;
                            }
                            this.types[n6] = 1;
                            break;
                        }
                        if (n3 == 1) {
                            this.types[n6] = 1;
                            break;
                        }
                        this.types[n6] = 0;
                        break;
                    }
                    case 1: {
                        this.types[n6] = 1;
                        break;
                    }
                    case 6: {
                        if (bl) {
                            this.types[n6] = 1;
                        }
                        if (bl) break;
                        this.types[n6] = 0;
                        break;
                    }
                    default: {
                        if (bl || n3 == 1 && n4 == 1) {
                            this.types[n6] = 1;
                            break;
                        }
                        if (bl) break;
                        this.types[n6] = 0;
                    }
                }
            }
            n3 = n7;
            ++n5;
        }
    }

    protected StringBuffer getStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.endPos == this.startPos) {
            return stringBuffer;
        }
        this.pos = this.endPos - 1;
        while (this.buf[this.pos] == ' ') {
            if (this.pos == this.startPos) {
                return stringBuffer;
            }
            --this.pos;
        }
        this.endPos = this.pos + 1;
        this.getTypes();
        while (this.pos >= this.startPos) {
            char c = this.buf[this.pos];
            int n = this.pos - this.startPos;
            int n2 = this.types[n];
            if (n2 == 1) {
                int n3 = n;
                int n4 = n3 - 1;
                while (n4 >= 0 && this.types[n4] == 1) {
                    --n4;
                }
                int n5 = ++n4;
                while (n5 <= n3) {
                    char c2 = this.buf[n5 + this.startPos];
                    stringBuffer.append(this.mirror(c2));
                    ++n5;
                }
                if (n4 == 0) break;
                this.pos = n4 + this.startPos - 1;
                continue;
            }
            stringBuffer.append(this.mirror(c));
            --this.pos;
        }
        return stringBuffer;
    }
}

