/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.DefaultPilotContext;
import ice.storm.DocPane;
import ice.storm.DocumentProxy;
import ice.storm.DynamicObject;
import ice.storm.FramesDivider;
import ice.storm.FramesetInfo;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.ViewportGuiParams;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Listeners;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Viewport {
    static final String NONAME = "view";
    private static final Object counterLock = new Object();
    private static long viewportCounter = 0L;
    private static final Method createWindowObj = Viewport.getCreateWindowObj();
    static String initialViewportName;
    private final Object dataLock = new Object();
    private String id;
    private String name;
    protected Viewport parent = null;
    private Viewport first;
    private Viewport last;
    private Viewport next;
    private Viewport prev;
    DefaultPilotContext pilotContext;
    protected Container container = null;
    protected Pilot pilot = null;
    private Component pilotComponent = null;
    protected FramesetInfo frameset = null;
    protected FramesetInfo curFrameset = null;
    private final HashArray params = new HashArray();
    private ViewportGuiParams guiParams;
    private Object propertyListeners;
    private int zoom = 256;
    private DynamicObject _windowObj;
    private String historyId = null;
    private String _locationUrl;
    private String _baseUrl;
    private int documentId = 1;
    static /* synthetic */ Class class$ice$storm$StormBase;
    static /* synthetic */ Class class$ice$storm$Viewport;

    private static String makeDefaultId(String string) {
        long l;
        Object object = counterLock;
        synchronized (object) {
            l = viewportCounter++;
        }
        return '_' + string + '_' + l;
    }

    private static Method getCreateWindowObj() {
        Class[] classArray = new Class[]{class$ice$storm$StormBase == null ? (class$ice$storm$StormBase = Viewport.class$("ice.storm.StormBase")) : class$ice$storm$StormBase, class$ice$storm$Viewport == null ? (class$ice$storm$Viewport = Viewport.class$("ice.storm.Viewport")) : class$ice$storm$Viewport};
        Method method = Defs.getMethod("ice.scripters.WindowObj", "create", classArray);
        if (method == null && Debug.trace) {
            Debug.trace("No scripting support");
        }
        return method;
    }

    public Viewport() {
        this(null);
    }

    public Viewport(String string) {
        this.name = string != null ? string : NONAME;
        this.id = Viewport.makeDefaultId(this.name);
    }

    private StormBase getStorm() {
        if (this.pilotContext != null) {
            return this.pilotContext.base;
        }
        return null;
    }

    public String toString() {
        return "{Viewport id=" + this.id + " name=" + this.name + "}";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getName2() {
        if (this.name == initialViewportName || this.name == NONAME) {
            return "";
        }
        return this.name;
    }

    public void setName(String string) {
        if (string != null && string.length() != 0) {
            this.pilotContext.base.sendViewportMessage(this, "nameChange", this.name, string);
            this.name = string;
        }
    }

    public int getDocumentId() {
        return this.documentId;
    }

    final void increseDocumentId() {
        Object object = this.dataLock;
        synchronized (object) {
            ++this.documentId;
        }
    }

    public void setZoom(int n) {
        Object object;
        if (n <= 0) {
            throw new IllegalArgumentException("Zoom factor must be positive");
        }
        if (this.zoom != n) {
            this.zoom = n;
            object = this.getPilot();
            if (object != null) {
                ((Pilot)object).setZoom(n);
            }
        }
        object = this.first;
        while (object != null) {
            ((Viewport)object).setZoom(this.zoom);
            object = ((Viewport)object).getNextSibling();
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = Listeners.add(this.propertyListeners, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = Listeners.remove(this.propertyListeners, propertyChangeListener);
        }
    }

    final Object getPropertyListeners() {
        return this.propertyListeners;
    }

    public void removeAllPropertyChangeListeners() {
        Object object = this.dataLock;
        synchronized (object) {
            this.propertyListeners = null;
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public Container getTopLevelContainer() {
        Container container = this.container;
        if (container != null) {
            Container container2;
            while ((container2 = container.getParent()) != null) {
                container = container2;
            }
        }
        return container;
    }

    public void setContainer(Container container) {
        if (Debug.trace && this.container != null) {
            Debug.trace("Replacing AWT container in " + this);
        }
        this.container = container;
        Viewport viewport = this.first;
        while (viewport != null) {
            viewport.setContainer(container);
            viewport = viewport.getNextSibling();
        }
    }

    public void setProperty(Object object, Object object2) {
        this.params.put(object, object2);
    }

    public void removeProperty(Object object) {
        this.params.remove(object);
    }

    public Object getProperty(Object object) {
        return this.params.get(object);
    }

    public ViewportGuiParams getGuiParams() {
        return this.guiParams;
    }

    public void setGuiParams(ViewportGuiParams viewportGuiParams) {
        this.guiParams = viewportGuiParams;
    }

    void setPilotContext(DefaultPilotContext defaultPilotContext) {
        this.pilotContext = defaultPilotContext;
    }

    public boolean isStopRequested() {
        if (this.pilotContext == null) {
            return true;
        }
        return this.pilotContext.isStopRequested();
    }

    public void beginFrameset(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, FramesDivider framesDivider) {
        FramesetInfo framesetInfo = new FramesetInfo(nArray, nArray2, nArray3, nArray4, n);
        if (this.frameset == null) {
            this.curFrameset = this.frameset = framesetInfo;
        } else if (this.curFrameset.canAddChild()) {
            framesDivider.setFramesetInfo(this.curFrameset);
            this.curFrameset.addChild(framesetInfo, framesDivider);
            this.curFrameset = framesetInfo;
        }
    }

    public void endFrameset() {
        if (this.curFrameset != null) {
            this.curFrameset = this.curFrameset.getParent();
        }
    }

    public boolean addFramesetChild(Viewport viewport, FramesDivider framesDivider) {
        FramesetInfo framesetInfo = this.curFrameset;
        if (framesetInfo == null) {
            return false;
        }
        if (framesetInfo.canAddChild()) {
            framesetInfo.addChild(viewport, framesDivider);
            framesDivider.setFramesetInfo(framesetInfo);
            this.addChild(viewport);
            return true;
        }
        return false;
    }

    public Viewport getNextSibling() {
        return this.next;
    }

    public Viewport getFirstChild() {
        return this.first;
    }

    public void addChild(Viewport viewport) {
        viewport.setParent(this);
        viewport.prev = this.last;
        viewport.next = null;
        if (this.last != null) {
            this.last.next = viewport;
        } else {
            this.first = viewport;
        }
        this.last = viewport;
        viewport.setZoom(this.zoom);
    }

    public Enumeration getChildren() {
        if (this.first == null) {
            return null;
        }
        return new ChildrenEnumerator(this.first);
    }

    public int getChildrenCount() {
        int n = 0;
        Viewport viewport = this.first;
        while (viewport != null) {
            ++n;
            viewport = viewport.getNextSibling();
        }
        return n;
    }

    public Viewport getChildByIndex(int n) {
        Viewport viewport = this.first;
        while (n > 0 && viewport != null) {
            --n;
            viewport = viewport.getNextSibling();
        }
        return viewport;
    }

    String getHistoryId() {
        if (this.historyId != null) {
            return this.historyId;
        }
        Viewport viewport = this.getParent();
        if (viewport == null) {
            return this.id;
        }
        this.historyId = "";
        Viewport viewport2 = viewport;
        while (viewport2 != null) {
            this.historyId = this.historyId + "_" + viewport2.getChildIndex(this);
            viewport2 = viewport2.getParent();
        }
        this.historyId = this.historyId + "_" + viewport.getLocation();
        return this.historyId;
    }

    private int getChildIndex(Viewport viewport) {
        int n = 0;
        Viewport viewport2 = this.first;
        while (viewport2 != null && viewport2 != viewport) {
            ++n;
            viewport2 = viewport2.getNextSibling();
        }
        if (viewport2 == null) {
            return -1;
        }
        return n;
    }

    public Viewport getParent() {
        return this.parent;
    }

    public Viewport getTopParent() {
        Viewport viewport;
        Viewport viewport2 = this;
        while ((viewport = viewport2.getParent()) != null) {
            viewport2 = viewport;
        }
        return viewport2;
    }

    void setParent(Viewport viewport) {
        if (this.parent != null) {
            return;
        }
        this.parent = viewport;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public void iterate(ViewportVisitor viewportVisitor) {
        if (viewportVisitor == null) {
            return;
        }
        viewportVisitor.visit(this);
        Viewport viewport = this.first;
        while (viewport != null) {
            viewport.iterate(viewportVisitor);
            viewport = viewport.getNextSibling();
        }
    }

    public void getViewAndAllChildren(Vector vector) {
        vector.addElement(this);
        Viewport viewport = this.first;
        while (viewport != null) {
            viewport.getViewAndAllChildren(vector);
            viewport = viewport.getNextSibling();
        }
    }

    public Viewport findViewportByName(String string) {
        if (string.equals(this.id) || string.equals(this.name)) {
            return this;
        }
        Viewport viewport = this.first;
        while (viewport != null) {
            Viewport viewport2 = viewport.findViewportByName(string);
            if (viewport2 != null) {
                return viewport2;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    Viewport findViewportByHistoryId(String string) {
        if (string.equals(this.getHistoryId())) {
            return this;
        }
        Viewport viewport = this.first;
        while (viewport != null) {
            Viewport viewport2 = viewport.findViewportByHistoryId(string);
            if (viewport2 != null) {
                return viewport2;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    public Viewport findImmediateChild(String string) {
        Viewport viewport = this.first;
        while (viewport != null) {
            if (string.equals(viewport.id) || string.equals(viewport.name)) {
                return viewport;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    public Viewport getImmediateChildWithProperty(Object object, Object object2) {
        Viewport viewport = this.first;
        while (viewport != null) {
            if (viewport.getProperty(object) == object2) {
                return viewport;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    public Viewport findViewportInTreeByName(String string) {
        switch (string.length()) {
            case 4: {
                if (!"_top".equals(string)) break;
                return this.getTopParent();
            }
            case 5: {
                if (!"_self".equals(string)) break;
                return this;
            }
            case 7: {
                if (!"_parent".equals(string)) break;
                Viewport viewport = this.getParent();
                if (viewport == null) {
                    viewport = this;
                }
                return viewport;
            }
        }
        Viewport viewport = this;
        do {
            Viewport viewport2;
            if ((viewport2 = viewport.findViewportByName(string)) == null) continue;
            return viewport2;
        } while ((viewport = viewport.getParent()) != null);
        return null;
    }

    public Component getPilotComponent() {
        return this.pilotComponent;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public Pilot getParentChainPilot() {
        Viewport viewport = this;
        do {
            Pilot pilot;
            if ((pilot = viewport.getPilot()) == null) continue;
            return pilot;
        } while ((viewport = viewport.getParent()) != null);
        return null;
    }

    protected void setPilot(Pilot pilot) {
        this.removePilot();
        this.pilot = pilot;
        this.pilot.setZoom(this.zoom);
        if (this.first == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.container.add(this.pilotComponent);
                this.scheduleValidate(this.container);
            }
        }
    }

    protected void scheduleValidate(final Component component) {
        this.pilotContext.base.runOnEventThreadLater(new Runnable(){

            public void run() {
                component.validate();
            }
        }, 0L);
    }

    protected void removePilot() {
        this.increseDocumentId();
        if (this.pilot == null) {
            return;
        }
        this.pilot.dispose();
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
        this.pilot = null;
    }

    protected void dispose() {
        this.removePilot();
        Viewport viewport = this.first;
        while (viewport != null) {
            viewport.dispose();
            viewport = viewport.getNextSibling();
        }
        this.last = null;
        this.first = null;
        if (this.frameset != null) {
            this.frameset.dispose();
        }
        this.frameset = null;
        this.curFrameset = null;
        if (this.pilotContext != null) {
            this.pilotContext.dispose();
        }
        this.container = null;
        this.parent = null;
        this.pilotContext = null;
    }

    protected void clearContent() {
        this.increseDocumentId();
        Viewport viewport = this.first;
        while (viewport != null) {
            viewport.dispose();
            viewport = viewport.getNextSibling();
        }
        this.last = null;
        this.first = null;
        if (this.frameset != null) {
            this.frameset.dispose();
        }
        this.frameset = null;
        this.curFrameset = null;
        if (this.pilot != null && this.pilotComponent == null) {
            this.pilotComponent = this.pilot.createComponent();
            if (this.pilotComponent != null && this.container != null) {
                this.container.add(this.pilotComponent);
                this.scheduleValidate(this.container);
            }
        }
    }

    void copyFramesetAndChildrenFrom(Viewport viewport) {
        if (this.pilotComponent != null) {
            if (this.container != null) {
                this.container.remove(this.pilotComponent);
            }
            this.pilotComponent = null;
        }
        this.frameset = viewport.frameset;
        this.first = viewport.first;
        this.last = viewport.last;
        viewport.frameset = null;
        viewport.last = null;
        viewport.first = null;
        Viewport viewport2 = this.first;
        while (viewport2 != null) {
            viewport2.parent = this;
            viewport2.setContainer(this.container);
            viewport2.setZoom(this.zoom);
            viewport2 = viewport2.getNextSibling();
        }
    }

    public void viewportLayout(int n, int n2, int n3, int n4) {
        if (this.frameset != null) {
            this.frameset.layout(n, n2, n3, n4);
        } else {
            Pilot pilot = this.pilot;
            if (pilot != null) {
                DocPane docPane = pilot.getDocPane();
                if (docPane != null) {
                    docPane.setPaneBounds(n, n2, n3, n4);
                    docPane.revalidate();
                } else {
                    Component component = this.pilotComponent;
                    if (component != null) {
                        component.setBounds(n, n2, n3, n4);
                        this.scheduleValidate(component);
                    }
                }
            }
        }
    }

    public String getLocation() {
        return this._locationUrl;
    }

    void setLocationUrl(String string) {
        this._locationUrl = string;
        this._baseUrl = null;
    }

    public URL getBaseURL() {
        String string = this.getBaseUrl();
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBaseUrl() {
        String string = this._baseUrl;
        if (string == null) {
            if (this._locationUrl != null) {
                string = this._locationUrl;
            } else if (this.parent != null) {
                string = this.parent.getBaseUrl();
            }
        }
        return string;
    }

    void setBaseUrl(String string) {
        if (string == null) {
            Debug.bug();
        }
        this._baseUrl = string;
    }

    public final boolean hasWindowObj() {
        return this._windowObj == null;
    }

    public DynamicObject getDynamicWrapper() {
        return this.getWindowObj();
    }

    public final DynamicObject getWindowObj() {
        DynamicObject dynamicObject = this._windowObj;
        if (dynamicObject == null && createWindowObj != null) {
            Object[] objectArray = new Object[]{this.getStorm(), this};
            Object object = this.dataLock;
            synchronized (object) {
                block9: {
                    dynamicObject = this._windowObj;
                    if (dynamicObject == null) {
                        try {
                            dynamicObject = this._windowObj = (DynamicObject)createWindowObj.invoke(null, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (Debug.ex) {
                                Debug.ex(illegalAccessException);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (!Debug.ex) break block9;
                            Debug.ex(invocationTargetException.getTargetException());
                        }
                    }
                }
            }
        }
        return dynamicObject;
    }

    public final void clearWindowObj() {
        this._windowObj = null;
    }

    public Viewport getContextViewport() {
        return Scripter.contextViewportImpl();
    }

    public DynamicObject getDocumentObject() {
        DynamicObject dynamicObject = null;
        Pilot pilot = this.getPilot();
        if (pilot != null) {
            dynamicObject = pilot.getDocumentObject();
        }
        if (dynamicObject == null) {
            dynamicObject = new DocumentProxy(this);
        }
        return dynamicObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ChildrenEnumerator
    implements Enumeration {
        private Viewport cursor;

        ChildrenEnumerator(Viewport viewport) {
            this.cursor = viewport;
        }

        public boolean hasMoreElements() {
            return this.cursor != null;
        }

        public Object nextElement() {
            Viewport viewport = this.cursor;
            this.cursor = this.cursor.getNextSibling();
            return viewport;
        }
    }
}

