/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.DefaultFactory;
import ice.storm.DefaultPilotContext;
import ice.storm.HistoryManager;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.PseudoHistoryManager;
import ice.storm.ResourceOwner;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.ScripterFactory;
import ice.storm.ScripterInfo;
import ice.storm.StormCallback;
import ice.storm.URLClassLoaderFactory;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.storm.ViewportLayoutManager;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Listeners;
import ice.util.awt.TimedAWTExecutor;
import ice.util.security.SecurityKit;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StormBase {
    public static final String VERSION = "v5_2_3";
    public static final String EXPIRES_STRING = "EXPIRY_DATE_TEXT";
    public static final String EXPIRES_LONG = "988668001910L";
    private static final Object staticDataLock;
    private static final Object _noScripter;
    private static int refCounter;
    private final Object viewportTreeLock = new Object();
    private HistoryManager historyManager;
    private PilotFactory pilotFactory;
    private ScripterFactory scripterFactory;
    private URLClassLoaderFactory classLoaderFactory;
    private String componentToolkitName = "awt";
    private Container container;
    private ViewportCallback viewportCallback;
    private ScripterCallback scripterCallback;
    private Hashtable scripters = new Hashtable();
    private Hashtable missingScripters = new Hashtable();
    private Vector viewports = new Vector();
    private Viewport activeViewport;
    private Object globalListeners;
    private Hashtable disabledMimeTypes = new Hashtable();
    private TimedAWTExecutor timedAWTExecutor;
    private final UrlMaster urlMaster = new UrlMaster();
    private final long[] recursiveTimestamp = new long[1];
    private Method clearAllMethod = null;
    private final boolean trace_viewport_messages = Debug.trace && Defs.booleanProperty("ice.storm.trace_viewport_messages");
    private final HashArray stormData = new HashArray();

    public StormBase() {
        Object object = staticDataLock;
        synchronized (object) {
            ++refCounter;
        }
        DefaultFactory defaultFactory = new DefaultFactory();
        defaultFactory.loadDefaultResources();
        this.pilotFactory = defaultFactory;
        this.scripterFactory = defaultFactory;
        this.classLoaderFactory = defaultFactory;
        this.setHistoryManager(new PseudoHistoryManager(this));
        this.addPropertyChangeListener(this.getHistoryManager(), null);
        this.clearAllMethod = Defs.getMethod("ice.net.ConnectionManager", "clearAll", null);
    }

    public final void setHistoryManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
    }

    public final HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public final void setPilotFactory(PilotFactory pilotFactory) {
        this.pilotFactory = pilotFactory;
    }

    public final PilotFactory getPilotFactory() {
        return this.pilotFactory;
    }

    public final void setScripterFactory(ScripterFactory scripterFactory) {
        this.scripterFactory = scripterFactory;
    }

    public final ScripterFactory getScripterFactory() {
        return this.scripterFactory;
    }

    public final void setURLClassLoaderFactory(URLClassLoaderFactory uRLClassLoaderFactory) {
        this.classLoaderFactory = uRLClassLoaderFactory;
    }

    public final URLClassLoaderFactory getURLClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public final void setComponentToolkitName(String string) {
        this.componentToolkitName = string;
    }

    public final String getComponentToolkitName() {
        return this.componentToolkitName;
    }

    public final void setContainer(Container container, String string) {
        if (this.viewportCallback != null || this.container != null) {
            return;
        }
        this.container = container;
        this.configureViewport(new Viewport(string), null);
    }

    public final Container getContainer(Container container) {
        return this.container;
    }

    public final void setCallback(StormCallback stormCallback) {
        CallbackAdapter.OldCallbackWrap oldCallbackWrap = new CallbackAdapter.OldCallbackWrap(stormCallback);
        oldCallbackWrap.registerWith(this);
    }

    public final StormCallback getCallback() {
        if (this.viewportCallback instanceof CallbackAdapter) {
            return ((CallbackAdapter.OldCallbackWrap)this.viewportCallback).oldCallback;
        }
        return null;
    }

    public final ViewportCallback getViewportCallback() {
        return this.viewportCallback;
    }

    public final void setViewportCallback(ViewportCallback viewportCallback) {
        if (this.container != null) {
            return;
        }
        this.viewportCallback = viewportCallback;
        this.viewportCallback.init(this);
    }

    public final ScripterCallback getScripterCallback() {
        return this.scripterCallback;
    }

    public final void setScripterCallback(ScripterCallback scripterCallback) {
        this.scripterCallback = scripterCallback;
    }

    public void setActiveViewport(Viewport viewport) {
        this.activeViewport = viewport;
    }

    public Viewport getActiveViewport() {
        return this.activeViewport;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        if (string == null) {
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.globalListeners = Listeners.add(this.globalListeners, propertyChangeListener);
            }
        } else {
            Viewport viewport = this.findViewportByName(string);
            if (viewport != null) {
                viewport.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        if (string == null) {
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.globalListeners = Listeners.remove(this.globalListeners, propertyChangeListener);
            }
        } else {
            Viewport viewport = this.findViewportByName(string);
            if (viewport != null) {
                viewport.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    boolean sendViewportMessage(Viewport viewport, String string, Object object, Object object2) {
        if (viewport == null) {
            Debug.bug();
        }
        if (this.trace_viewport_messages && Debug.trace) {
            Debug.trace(viewport + ", " + string + ", " + object + ", " + object2);
        }
        if (this.viewportCallback != null) {
            try {
                this.viewportCallback.processViewportMessage(viewport, string, object, object2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Debug.ex) {
                    Debug.ex(outOfMemoryError);
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex(runtimeException);
                }
                return false;
            }
        }
        boolean bl = true;
        PropertyChangeEvent propertyChangeEvent = null;
        Viewport viewport2 = viewport;
        while (true) {
            Object object3;
            if ((object3 = viewport2 == null ? this.globalListeners : viewport2.getPropertyListeners()) != null) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(viewport, string, object, object2);
                }
                bl &= StormBase.firePropertyChangeEvent(object3, propertyChangeEvent);
            }
            if (viewport2 == null) break;
            viewport2 = viewport2.getParent();
        }
        return bl;
    }

    private static boolean firePropertyChangeEvent(Object object, PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener;
        if (object == null) {
            Defs.badArg();
        }
        boolean bl = true;
        int n = 0;
        while ((propertyChangeListener = (PropertyChangeListener)Listeners.get(object, n)) != null) {
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Debug.ex) {
                    Debug.ex(outOfMemoryError);
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex(runtimeException);
                }
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isMimeTypeEnabled(String string) {
        Enumeration enumeration;
        PilotFactory pilotFactory;
        boolean bl = false;
        if (!this.disabledMimeTypes.containsKey(string) && (pilotFactory = this.getPilotFactory()) != null && (enumeration = pilotFactory.getAllPilotInfos()) != null) {
            while (enumeration.hasMoreElements()) {
                PilotInfo pilotInfo = (PilotInfo)enumeration.nextElement();
                if (!pilotInfo.isSupportedContentType(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setMimeTypeEnabled(String string, boolean bl) {
        Object v = this.disabledMimeTypes.get(string);
        if (v != null && bl) {
            this.disabledMimeTypes.remove(string);
        } else if (v == null && !bl) {
            this.disabledMimeTypes.put(string, string);
        }
    }

    public UrlMaster getUrlMaster() {
        return this.urlMaster;
    }

    public void renderContent(String string, String string2, String string3) {
        Scripter scripter;
        Viewport viewport = this.prepare_viewport(string3);
        if (viewport == null) {
            Debug.bug();
        }
        string = this.getUrlMaster().resolve(viewport.getBaseUrl(), string);
        if (Debug.trace) {
            Debug.trace(string + " in " + viewport);
        }
        if ((scripter = this.getScripterForCodeLocation(string)) != null) {
            scripter.evalCodeLocation(viewport, string);
            return;
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ContentLoader contentLoader = null;
            contentLoader = new ContentLoader(string, string2);
            contentLoader.setReferer(viewport.getBaseUrl());
            if (this.checkForAnchors(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopLoading(string3);
            viewport.pilotContext.queueRenderContent(contentLoader);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    private boolean checkForAnchors(ContentLoader contentLoader, Viewport viewport) {
        boolean bl;
        block7: {
            String string;
            bl = false;
            URL uRL = contentLoader.getURL();
            if (uRL == null) {
                return false;
            }
            String string2 = uRL.getRef();
            if (string2 != null && (string = viewport.getLocation()) != null) {
                Pilot pilot;
                String string3;
                int n = string.lastIndexOf(35);
                if (0 <= n) {
                    string = string.substring(0, n);
                }
                if (0 <= (n = (string3 = uRL.toExternalForm()).lastIndexOf(35))) {
                    string3 = string3.substring(0, n);
                }
                if (string.equals(string3) && (pilot = viewport.getPilot()) != null && pilot.refExists(string2)) {
                    try {
                        this.getHistoryManager().goingSomewhere(contentLoader, viewport.getId());
                        pilot.gotoRef(string2);
                        bl = true;
                    }
                    catch (RuntimeException runtimeException) {
                        if (!Debug.ex) break block7;
                        Debug.ex(runtimeException);
                    }
                }
            }
        }
        return bl;
    }

    public void renderContent(ContentLoader contentLoader, String string) {
        Viewport viewport = this.prepare_viewport(string);
        if (viewport == null) {
            if (Debug.trace) {
                Debug.trace("Failed: no view for " + string);
            }
            return;
        }
        this.renderViewportContent(contentLoader, viewport);
    }

    public void renderViewportContent(ContentLoader contentLoader, Viewport viewport) {
        if (viewport.pilotContext == null) {
            throw new IllegalArgumentException("Unitialized view");
        }
        if (Debug.trace) {
            Debug.trace("loader=" + contentLoader + " view=" + viewport);
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (this.checkForAnchors(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopViewportLoading(viewport);
            viewport.pilotContext.queueRenderContent(contentLoader);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void renderContentFully(ContentLoader contentLoader, String string) {
        Viewport viewport = this.prepare_viewport(string);
        if (viewport == null) {
            if (Debug.trace) {
                Debug.trace("Failed: no view for " + string + " to render " + contentLoader);
            }
            return;
        }
        if (Debug.trace) {
            Debug.trace("loader=" + contentLoader + " view=" + viewport);
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (this.checkForAnchors(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopLoading(string);
            this.do_render_content(contentLoader, viewport);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void clearContent(String string, String string2) {
        if (Debug.trace) {
            Debug.trace("contentType=" + string + " viewport=" + string2);
        }
        this.stopLoading(string2);
        Viewport viewport = this.prepare_viewport(string2);
        if (viewport == null) {
            return;
        }
        this.do_clear_content(null, string, viewport);
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    private Viewport prepare_viewport(String string) {
        if ("_blank".equals(string)) {
            string = null;
        }
        Viewport viewport = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (string != null) {
                if (this.viewports.size() == 0) {
                    Viewport.initialViewportName = string;
                } else {
                    viewport = this.findViewportByName(string);
                }
            } else if (this.container != null && this.viewports.size() == 1) {
                viewport = (Viewport)this.viewports.elementAt(0);
            }
        }
        if (viewport == null && !this.configureViewport(viewport = new Viewport(string), viewport.getId())) {
            return null;
        }
        return viewport;
    }

    void do_clear_content(ContentLoader contentLoader, String string, Viewport viewport) {
        if (string == null) {
            string = "text/html";
        }
        boolean bl = this.disabledMimeTypes.containsKey(string);
        Object object = this.viewportTreeLock;
        synchronized (object) {
            viewport.clearContent();
        }
        Pilot pilot = viewport.getPilot();
        if (pilot != null) {
            boolean bl2 = this.getPilotFactory().isContentTypeSupported(pilot, contentLoader, string);
            if (!bl2) {
                if (viewport.isStopRequested()) {
                    return;
                }
                viewport.removePilot();
                pilot = null;
            } else {
                if (contentLoader != null) {
                    string = contentLoader.getContentType();
                }
                viewport.setLocationUrl(null);
                pilot.clear(string);
            }
        }
        Object object2 = this.viewportTreeLock;
        synchronized (object2) {
            this.reqClearViewport(viewport);
        }
        if (pilot == null) {
            this.sendViewportMessage(viewport, "pilotLoading", null, "begin");
            if (bl) {
                pilot = this.getPilotFactory().createPilot("application/disabled");
            } else if (contentLoader != null) {
                pilot = this.getPilotFactory().createPilot(contentLoader);
                string = contentLoader.getContentType();
            } else {
                pilot = this.getPilotFactory().createPilot(string);
            }
            if (pilot == null) {
                this.sendViewportMessage(viewport, "pilotLoading", null, "error");
                return;
            }
            if (viewport.isStopRequested()) {
                return;
            }
            pilot.base = this;
            pilot.context = viewport.pilotContext;
            pilot.init(this.componentToolkitName);
            viewport.setPilot(pilot);
            viewport.setLocationUrl(null);
            pilot.clear(string);
            this.sendViewportMessage(viewport, "pilotLoading", null, "end");
        }
    }

    void do_render_content(ContentLoader contentLoader, Viewport viewport) {
        IOException iOException;
        if (!this.sendViewportMessage(viewport, "contentLoading", contentLoader, "request")) {
            return;
        }
        this.sendViewportMessage(viewport, "contentLoading", contentLoader, "connect");
        if (!contentLoader.hasReply() && contentLoader.getContentType() == null) {
            contentLoader.make();
        }
        if ((iOException = contentLoader.getException()) == null) {
            if (contentLoader.getContentType().equals("application/external")) {
                return;
            }
            if (viewport.isStopRequested()) {
                return;
            }
            this.do_clear_content(contentLoader, contentLoader.getContentType(), viewport);
            viewport.setLocationUrl(contentLoader.getLocation());
            if (viewport.isStopRequested()) {
                return;
            }
            Pilot pilot = viewport.getPilot();
            this.getHistoryManager().goingSomewhere(contentLoader, viewport.getId());
            if (viewport.isStopRequested()) {
                return;
            }
            this.sendViewportMessage(viewport, "contentLoading", contentLoader, "begin");
            if (!this.isRecursiveLoading(viewport, contentLoader)) {
                try {
                    pilot.parse(contentLoader);
                }
                catch (IOException iOException2) {
                    if (Debug.ex) {
                        Debug.ex(iOException2);
                    }
                    iOException = iOException2;
                    contentLoader.setException(iOException);
                }
            }
            if (iOException == null) {
                this.sendViewportMessage(viewport, "contentLoading", contentLoader, "end");
                pilot.parsingDone();
            }
        }
        if (iOException != null) {
            if (Debug.trace) {
                Debug.trace("Failed to load: " + contentLoader);
            }
            this.sendViewportMessage(viewport, "contentLoading", contentLoader, "error");
        }
    }

    private final boolean isRecursiveLoading(Viewport viewport, ContentLoader contentLoader) {
        int n = 0;
        String string = contentLoader.getLocation();
        if (string == null) {
            return false;
        }
        viewport = viewport.getParent();
        while (viewport != null) {
            String string2 = viewport.getLocation();
            if (string2 != null && string.equals(string2) && ++n > 1) {
                long[] lArray = this.recursiveTimestamp;
                synchronized (lArray) {
                    if (this.recursiveTimestamp[0] == 0L) {
                        this.recursiveTimestamp[0] = System.currentTimeMillis();
                        boolean bl = false;
                        return bl;
                    }
                    if (System.currentTimeMillis() - this.recursiveTimestamp[0] > 2000L) {
                        this.recursiveTimestamp[0] = System.currentTimeMillis();
                        boolean bl = false;
                        return bl;
                    }
                    this.recursiveTimestamp[0] = System.currentTimeMillis();
                }
                return true;
            }
            viewport = viewport.getParent();
        }
        return false;
    }

    public void reload(String string) {
        this.getHistoryManager().reload(string);
    }

    public void goBack(String string) {
        this.getHistoryManager().goBack(string);
    }

    public boolean canGoBack(String string) {
        return this.getHistoryManager().canGoBack(string);
    }

    public void goForward(String string) {
        this.getHistoryManager().goForward(string);
    }

    public boolean canGoForward(String string) {
        return this.getHistoryManager().canGoForward(string);
    }

    public boolean configureViewport(Viewport viewport, String string) {
        Viewport viewport2 = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
            if (string != null) {
                viewport2 = this.findViewportByName(string);
            }
        }
        if (viewport2 != null) {
            viewport2.clearContent();
            Object object2 = this.viewportTreeLock;
            synchronized (object2) {
                Enumeration enumeration = viewport.getChildren();
                if (enumeration != null) {
                    viewport2.copyFramesetAndChildrenFrom(viewport);
                    while (enumeration.hasMoreElements()) {
                        Viewport viewport3 = (Viewport)enumeration.nextElement();
                        this.process_new_viewport(viewport3);
                    }
                }
            }
        }
        if (this.viewportCallback != null) {
            Object object3;
            Object object4 = this.viewportTreeLock;
            synchronized (object4) {
                this.viewports.addElement(viewport);
            }
            Container container = (Container)SecurityKit.doPrivileged(CallbackAdapter.box_createTopLevelContainer(this.viewportCallback, viewport));
            if (container == null && !"none".equalsIgnoreCase(this.componentToolkitName)) {
                if (Debug.trace) {
                    Debug.trace("Failed to create AWT container for " + viewport);
                }
                Object object5 = this.viewportTreeLock;
                synchronized (object5) {
                    this.viewports.removeElement(viewport);
                }
                return false;
            }
            if (Debug.trace) {
                object3 = null;
                Object object6 = this.viewportTreeLock;
                synchronized (object6) {
                    Vector vector = this.viewports;
                    int n = vector.size();
                    while (n-- != 0) {
                        Viewport viewport4 = (Viewport)vector.elementAt(n);
                        if (viewport == viewport4 || viewport4.getContainer() != container) continue;
                        object3 = viewport4;
                        break;
                    }
                }
                if (object3 != null) {
                    Debug.trace("ERROR: got same AWT container for " + object3 + " and " + viewport);
                }
            }
            viewport.setContainer(container);
            if (container != null) {
                container.setLayout(new ViewportLayoutManager(viewport));
            }
            object3 = this.viewportTreeLock;
            synchronized (object3) {
                this.process_new_viewport(viewport);
            }
        }
        if (this.container != null) {
            if (this.viewports.size() > 0) {
                return false;
            }
            viewport.setContainer(this.container);
            if (this.container != null) {
                this.container.setLayout(new ViewportLayoutManager(viewport));
            }
            Object object7 = this.viewportTreeLock;
            synchronized (object7) {
                this.viewports.addElement(viewport);
                this.process_new_viewport(viewport);
            }
        }
        return true;
    }

    public Viewport findViewportByName(String string) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Viewport viewport = null;
            int n = 0;
            while (n < this.viewports.size() && viewport == null) {
                viewport = (Viewport)this.viewports.elementAt(n);
                viewport = viewport.findViewportByName(string);
                ++n;
            }
            Viewport viewport2 = viewport;
            return viewport2;
        }
    }

    void getAllPilotInstances(Class clazz, Vector vector) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int n = 0;
            while (n != this.viewports.size()) {
                Viewport viewport = (Viewport)this.viewports.elementAt(n);
                this.getAllPilotInstances_r(viewport, clazz, vector);
                ++n;
            }
        }
    }

    private void getAllPilotInstances_r(Viewport viewport, Class clazz, Vector vector) {
        Pilot pilot = viewport.getPilot();
        if (clazz.isInstance(pilot)) {
            vector.addElement(pilot);
        }
        Viewport viewport2 = viewport.getFirstChild();
        while (viewport2 != null) {
            this.getAllPilotInstances_r(viewport2, clazz, vector);
            viewport2 = viewport2.getNextSibling();
        }
    }

    private boolean isTopLevelViewport(Viewport viewport) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int n = 0;
            int n2 = this.viewports.size();
            while (n != n2) {
                if (viewport == this.viewports.elementAt(n)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    boolean isKnownViewport(Viewport viewport) {
        viewport = viewport.getTopParent();
        return this.isTopLevelViewport(viewport);
    }

    Viewport findViewportByHistoryId(String string) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Viewport viewport = null;
            int n = 0;
            while (n < this.viewports.size() && viewport == null) {
                viewport = (Viewport)this.viewports.elementAt(n);
                viewport = viewport.findViewportByHistoryId(string);
                ++n;
            }
            Viewport viewport2 = viewport;
            return viewport2;
        }
    }

    public void getAllViewports(Vector vector) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int n = 0;
            int n2 = this.viewports.size();
            while (n != n2) {
                Viewport viewport = (Viewport)this.viewports.elementAt(n);
                viewport.getViewAndAllChildren(vector);
                ++n;
            }
        }
    }

    public void closeViewport(String string) {
        Viewport viewport = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
            int n = 0;
            while (n < this.viewports.size()) {
                Viewport viewport2 = (Viewport)this.viewports.elementAt(n);
                if (viewport2.getId().equals(string) || viewport2.getName().equals(string)) {
                    viewport = viewport2;
                    break;
                }
                ++n;
            }
            if (viewport == null) {
                if (Debug.trace) {
                    Debug.trace("No top view: " + string);
                }
                return;
            }
            this.viewports.removeElement(viewport);
        }
        if (Debug.trace) {
            Debug.trace("view=" + viewport);
        }
        viewport.dispose();
        if (this.viewportCallback != null) {
            this.viewportCallback.disposeTopLevelContainer(viewport);
        }
    }

    public String getViewportState(String string) {
        Viewport viewport = this.findViewportByName(string);
        if (viewport == null) {
            return null;
        }
        DefaultPilotContext defaultPilotContext = viewport.pilotContext;
        if (defaultPilotContext == null) {
            return null;
        }
        return defaultPilotContext.state;
    }

    public void stopLoading(String string) {
        Viewport viewport = this.findViewportByName(string);
        if (viewport != null) {
            this.stopViewportLoading(viewport);
        }
    }

    public void stopViewportLoading(Viewport viewport) {
        block6: {
            this.sendViewportMessage(viewport, "contentLoading", null, "stop");
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.process_stop_loading(viewport);
            }
            if (this.clearAllMethod != null) {
                try {
                    this.clearAllMethod.invoke(null, null);
                }
                catch (Throwable throwable) {
                    if (!Debug.ex) break block6;
                    Debug.ex(throwable);
                }
            }
        }
    }

    void process_stop_loading(Viewport viewport) {
        DefaultPilotContext defaultPilotContext = viewport.pilotContext;
        if (defaultPilotContext == null) {
            return;
        }
        defaultPilotContext.stopLoading();
        Viewport viewport2 = viewport.getFirstChild();
        while (viewport2 != null) {
            this.process_stop_loading(viewport2);
            viewport2 = viewport2.getNextSibling();
        }
    }

    public void dispose() {
        Object[] objectArray;
        Object object;
        Object object2;
        Enumeration<Object> enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Scripter)enumeration.nextElement();
            ((Scripter)object2).dispose();
        }
        this.scripters.clear();
        this.missingScripters.clear();
        object2 = this.viewportTreeLock;
        synchronized (object2) {
            this.activeViewport = null;
            enumeration = this.viewports.elements();
            while (enumeration.hasMoreElements()) {
                object = (Viewport)enumeration.nextElement();
                ((Viewport)object).dispose();
            }
            this.viewports.removeAllElements();
        }
        object = staticDataLock;
        synchronized (object) {
            --refCounter;
        }
        if (this.timedAWTExecutor != null) {
            this.timedAWTExecutor.shutdown();
        }
        HashArray hashArray = this.stormData;
        synchronized (hashArray) {
            objectArray = this.stormData.getValues();
            this.stormData.clear();
        }
        int n = 0;
        int n2 = objectArray.length;
        while (n != n2) {
            Object object3 = objectArray[n];
            if (object3 instanceof ResourceOwner) {
                ((ResourceOwner)object3).disposeResources();
            }
            ++n;
        }
    }

    public static void unload() {
    }

    public void suspend() {
        Object object;
        Enumeration<Object> enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).suspend();
        }
        enumeration = this.viewports.elements();
        while (enumeration.hasMoreElements()) {
            object = (Viewport)enumeration.nextElement();
            Pilot pilot = ((Viewport)object).getPilot();
            if (pilot == null) continue;
            pilot.suspend();
        }
    }

    public void resume() {
        Object object;
        Enumeration<Object> enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).resume();
        }
        enumeration = this.viewports.elements();
        while (enumeration.hasMoreElements()) {
            object = (Viewport)enumeration.nextElement();
            Pilot pilot = ((Viewport)object).getPilot();
            if (pilot == null) continue;
            pilot.resume();
        }
    }

    public Scripter getScripterForCodeLocation(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return this.getScripter(string2);
        }
        return null;
    }

    public Scripter getScripter(String string) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ScripterInfo scripterInfo = this.getScripterFactory().getScripterInfo(string);
            if (scripterInfo == null) {
                Scripter scripter = null;
                return scripter;
            }
            Scripter scripter = (Scripter)this.scripters.get(scripterInfo);
            if (scripter != null) {
                Scripter scripter2 = scripter;
                return scripter2;
            }
            if (this.missingScripters.get(scripterInfo) != null) {
                Scripter scripter3 = null;
                return scripter3;
            }
            ScripterFactory scripterFactory = this.getScripterFactory();
            scripter = scripterFactory.createScripter(string);
            if (scripter == null) {
                this.missingScripters.put(scripterInfo, _noScripter);
                Scripter scripter4 = null;
                return scripter4;
            }
            this.scripters.put(scripterInfo, scripter);
            scripter.init(this);
            Scripter scripter5 = scripter;
            return scripter5;
        }
    }

    public void unloadAllScripters() {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Object object2;
            Enumeration enumeration = this.getScripterFactory().getAllScripterInfos();
            while (enumeration.hasMoreElements()) {
                object2 = (ScripterInfo)enumeration.nextElement();
                ((ScripterInfo)object2).setEnabled(false);
            }
            enumeration = this.scripters.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Scripter)enumeration.nextElement();
                ((Scripter)object2).dispose();
            }
            this.scripters.clear();
            object2 = this.viewports;
            int n = ((Vector)object2).size();
            while (n-- != 0) {
                Viewport viewport = (Viewport)((Vector)object2).elementAt(n);
                this.clear_viewport_dynwrapper_r(viewport);
            }
        }
    }

    private void clear_viewport_dynwrapper_r(Viewport viewport) {
        viewport.clearWindowObj();
        viewport = viewport.getFirstChild();
        while (viewport != null) {
            this.clear_viewport_dynwrapper_r(viewport);
            viewport = viewport.getNextSibling();
        }
    }

    private void process_new_viewport(Viewport viewport) {
        viewport.setPilotContext(new DefaultPilotContext(this, viewport));
        Enumeration enumeration = viewport.getChildren();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Viewport viewport2 = (Viewport)enumeration.nextElement();
            this.process_new_viewport(viewport2);
        }
    }

    void unregisterViewport(Viewport viewport) {
        this.getHistoryManager().clearHistoryForViewport(viewport);
        viewport.removeAllPropertyChangeListeners();
        viewport.clearWindowObj();
    }

    private void reqClearViewport(Viewport viewport) {
        Enumeration enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            Scripter scripter = (Scripter)enumeration.nextElement();
            scripter.clearViewport(viewport);
        }
    }

    private TimedAWTExecutor getTimedAWTExecutor() {
        TimedAWTExecutor timedAWTExecutor = this.timedAWTExecutor;
        if (timedAWTExecutor == null) {
            StormBase stormBase = this;
            synchronized (stormBase) {
                timedAWTExecutor = this.timedAWTExecutor;
                if (timedAWTExecutor == null) {
                    this.timedAWTExecutor = timedAWTExecutor = new TimedAWTExecutor();
                }
            }
        }
        return timedAWTExecutor;
    }

    public void runOnEventThreadLater(Runnable runnable, long l) {
        this.getTimedAWTExecutor().invokeLater(runnable, l);
    }

    public boolean isEventThread() {
        return this.getTimedAWTExecutor().isEventThread();
    }

    public Object getData(Object object) {
        return this.stormData.get(object);
    }

    public Object initData(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        HashArray hashArray = this.stormData;
        synchronized (hashArray) {
            HashArray.Entry entry = this.stormData.ensureEntry(object);
            if (entry.value == null) {
                entry.value = object2;
            }
            Object object3 = entry.value;
            return object3;
        }
    }

    static {
        String string;
        staticDataLock = new Object();
        _noScripter = new Object();
        refCounter = 0;
        if (Defs.booleanProperty("ice.browser.verbose", false)) {
            System.out.println("ICEbrowser v5_2_3");
            System.out.println("(c) ICEsoft Technologies, Inc.");
        }
        if ((string = Defs.property("ice.browser.http.agent")) == null) {
            string = "ICE Browser/v5_2_3 (Java " + Defs.property("java.version") + "; " + Defs.property("os.name") + " " + Defs.property("os.version") + " " + Defs.property("os.arch") + ")";
        }
        Defs.setSystemProperty("http.agent", string);
    }
}

