/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

class FormInputRadio
extends JRadioButton
implements ObjectPainter,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private JRadioButton none;
    private ButtonGroup group;

    FormInputRadio(DocView docView, DElement dElement, JRadioButton jRadioButton, ButtonGroup buttonGroup) {
        this.docView = docView;
        this.element = (DInputElement)dElement;
        this.none = jRadioButton;
        this.group = buttonGroup;
        this.setSelected(this.element.getChecked());
        this.checkAttributes();
        this.setBorder(null);
        this.setOpaque(false);
        if (buttonGroup != null) {
            buttonGroup.add(this);
        }
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
        if (this.isSelected() != this.element.getChecked()) {
            if (this.isSelected() && this.none != null) {
                this.none.setSelected(true);
            } else {
                this.setSelected(this.element.getChecked());
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
        this.group.remove(this);
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }
}

