/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class FormSelectList
extends List
implements Runnable,
DSelectElement.SelectPainter,
ItemListener,
Movable {
    private DocView docView;
    private DSelectElement sel;
    private ObjectBox box;
    private boolean ignoreItemChange;
    boolean onMyWay = false;

    FormSelectList(DocView docView, DElement dElement, int n) {
        super(n);
        this.docView = docView;
        this.sel = (DSelectElement)dElement;
        if (this.sel.getMultiple()) {
            this.setMultipleMode(true);
        }
        this.copyOptionsToView();
        this.checkAttributes();
        this.addItemListener(this);
        this.enableEvents(28L);
    }

    private void copyOptionsToView() {
        int n = this.getItemCount();
        int n2 = 0;
        DOptionElement dOptionElement = this.sel.firstDOption();
        while (n2 < n && dOptionElement != null) {
            String string = this.getItem(n2);
            String string2 = dOptionElement.getTextOrEmptyString();
            if (string.length() != string2.length() || !string.equals(string2)) break;
            dOptionElement = this.sel.nextDOption(dOptionElement);
            ++n2;
        }
        if (n2 == n && dOptionElement == null) {
            return;
        }
        this.ignoreItemChange = true;
        this.removeAll();
        dOptionElement = this.sel.firstDOption();
        n2 = 0;
        while (dOptionElement != null) {
            this.add(dOptionElement.getTextOrEmptyString());
            if (dOptionElement.getSelected()) {
                this.select(n2);
            }
            dOptionElement = this.sel.nextDOption(dOptionElement);
            ++n2;
        }
        this.ignoreItemChange = false;
    }

    private void updateSelection() {
        this.ignoreItemChange = true;
        DOptionElement dOptionElement = this.sel.firstDOption();
        int n = 0;
        while (dOptionElement != null) {
            if (dOptionElement.getSelected()) {
                this.select(n);
            } else {
                this.deselect(n);
            }
            dOptionElement = this.sel.nextDOption(dOptionElement);
            ++n;
        }
        this.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.setEnabled(!this.sel.getDisabled());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (!this.ignoreItemChange && (object = itemEvent.getItem()) instanceof Integer) {
            int n = (Integer)object;
            this.sel.setSelectedIndexByUser(n);
        }
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void run() {
        this.onMyWay = false;
        this.copyOptionsToView();
    }

    public void onOptionStructChange() {
        if (!this.onMyWay) {
            this.onMyWay = true;
            this.docView.getPilot().getStorm().runOnEventThreadLater(this, 100L);
        }
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement dOptionElement, DAttr dAttr) {
        int n = this.sel.getOptionIndex(dOptionElement);
        if (n >= 0 && n < this.getItemCount()) {
            this.ignoreItemChange = true;
            String string = dOptionElement.getLabel();
            if (string != null && !this.getItem(n).equals(string)) {
                this.replaceItem(string, n);
                this.box.invalidate();
                this.box.reqReflow();
            }
            this.ignoreItemChange = false;
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
        if (objectBox != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        super.doLayout();
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }
}

