/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import java.awt.Rectangle;

class FloatManager {
    private CSSBox firstFloater;
    private CSSBox lastFloater;
    private CSSBox firstJustAdded;
    private Rectangle[] activeLeftFloaters;
    private Rectangle[] activeRightFloaters;
    private int numLeft;
    private int numRight;
    private int x1;
    private int x2;
    private int y;
    private int ax1;
    private int ax2;

    FloatManager(int n, int n2) {
        this.ax1 = this.x1 = n;
        this.ax2 = this.x2 = n2;
    }

    void pushLeftFloaters(Rectangle rectangle) {
        if (this.activeLeftFloaters == null) {
            this.activeLeftFloaters = new Rectangle[10];
        } else if (this.activeLeftFloaters.length == this.numLeft) {
            Rectangle[] rectangleArray = new Rectangle[this.activeLeftFloaters.length * 2];
            System.arraycopy(this.activeLeftFloaters, 0, rectangleArray, 0, this.numLeft);
            this.activeLeftFloaters = rectangleArray;
        }
        this.activeLeftFloaters[this.numLeft++] = rectangle;
    }

    void pushRightFloaters(Rectangle rectangle) {
        if (this.activeRightFloaters == null) {
            this.activeRightFloaters = new Rectangle[10];
        } else if (this.activeRightFloaters.length == this.numRight) {
            Rectangle[] rectangleArray = new Rectangle[this.activeRightFloaters.length * 2];
            System.arraycopy(this.activeRightFloaters, 0, rectangleArray, 0, this.numRight);
            this.activeRightFloaters = rectangleArray;
        }
        this.activeRightFloaters[this.numRight++] = rectangle;
    }

    int getAvailableX() {
        return this.ax1 - this.x1;
    }

    int getAvailableWidth() {
        return this.ax2 - this.ax1;
    }

    void addFloater(CSSBox cSSBox) {
        if (this.firstJustAdded == null) {
            this.firstJustAdded = cSSBox;
        }
        if (this.firstFloater != null) {
            this.lastFloater.next = cSSBox;
            cSSBox.next = null;
            this.lastFloater = cSSBox;
        } else {
            this.firstFloater = this.lastFloater = cSSBox;
            cSSBox.next = null;
        }
    }

    int clearLeft() {
        int n = this.y;
        while (this.numLeft > 0) {
            Rectangle rectangle = this.activeLeftFloaters[this.numLeft - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n) {
                n = rectangle.y + rectangle.height;
            }
            this.activeLeftFloaters[this.numLeft - 1] = null;
            --this.numLeft;
        }
        this.y += (n -= this.y);
        this.ax1 = this.x1;
        return n;
    }

    int clearRight() {
        int n = this.y;
        while (this.numRight > 0) {
            Rectangle rectangle = this.activeRightFloaters[this.numRight - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n) {
                n = rectangle.y + rectangle.height;
            }
            this.activeRightFloaters[this.numRight - 1] = null;
            --this.numRight;
        }
        this.y += (n -= this.y);
        this.ax2 = this.x2;
        return n;
    }

    int skipTill(int n) {
        Rectangle rectangle;
        int n2 = this.y;
        while (this.numLeft > 0) {
            rectangle = this.activeLeftFloaters[this.numLeft - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n2) {
                n2 = rectangle.y + rectangle.height;
            }
            this.activeLeftFloaters[this.numLeft - 1] = null;
            --this.numLeft;
        }
        while (this.numRight > 0) {
            rectangle = this.activeRightFloaters[this.numRight - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n2) {
                n2 = rectangle.y + rectangle.height;
            }
            this.activeRightFloaters[this.numRight - 1] = null;
            --this.numRight;
        }
        this.y += (n2 -= this.y);
        this.ax1 = this.x1;
        this.ax2 = this.x2;
        return n2;
    }

    void advance(int n) {
        Rectangle rectangle;
        this.y += n;
        this.ax1 = this.x1;
        this.ax2 = this.x2;
        while (this.numLeft > 0) {
            rectangle = this.activeLeftFloaters[this.numLeft - 1];
            if (rectangle != null && rectangle.y + rectangle.height > this.y) {
                this.ax1 = rectangle.x + rectangle.width;
                break;
            }
            this.activeLeftFloaters[this.numLeft - 1] = null;
            --this.numLeft;
        }
        while (this.numRight > 0) {
            rectangle = this.activeRightFloaters[this.numRight - 1];
            if (rectangle != null && rectangle.y + rectangle.height > this.y) {
                this.ax2 = rectangle.x;
                break;
            }
            this.activeRightFloaters[this.numRight - 1] = null;
            --this.numRight;
        }
        if (this.firstJustAdded != null) {
            CSSBox cSSBox = this.firstJustAdded;
            while (cSSBox != null) {
                rectangle = new Rectangle(0, 0, cSSBox.width + cSSBox.ox * 2, cSSBox.height + cSSBox.oy * 2);
                if ((cSSBox.css.do_floats & 1) != 0) {
                    rectangle.x = this.ax1;
                    cSSBox.ox += rectangle.x;
                    this.ax1 = rectangle.x + rectangle.width;
                    rectangle.y = this.y;
                    cSSBox.oy += this.y;
                    this.pushLeftFloaters(rectangle);
                } else if ((cSSBox.css.do_floats & 2) != 0) {
                    rectangle.x = this.ax2 - rectangle.width;
                    if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                    cSSBox.ox += rectangle.x;
                    this.ax2 = rectangle.x;
                    rectangle.y = this.y;
                    cSSBox.oy = this.y;
                    this.pushRightFloaters(rectangle);
                }
                cSSBox = cSSBox.next;
            }
            this.firstJustAdded = cSSBox;
        }
    }

    void translate(int n, int n2) {
        this.x1 += n;
        this.x2 += n2;
    }

    boolean hasActiveFloaters() {
        return this.numLeft > 0 || this.numRight > 0;
    }

    CSSBox getFirstFloater() {
        return this.firstFloater;
    }
}

