/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DCSSRule;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class DRuleList
extends DynamicList
implements CSSRuleList {
    private int maxRules = 16;
    private int numRules = 0;
    private DCSSRule[] rules = new DCSSRule[this.maxRules];
    private static final int Method_insertRule = -1;
    private static final int Method_deleteRule = -2;

    DRuleList() {
    }

    public int getLength() {
        return this.numRules;
    }

    public CSSRule item(int n) {
        if (n < 0 || n >= this.numRules) {
            return null;
        }
        return this.rules[n];
    }

    protected Object script_item(int n, DynEnv dynEnv) {
        return this.item(n);
    }

    protected Object script_namedItem(String string, DynEnv dynEnv) {
        return null;
    }

    public int insertRule(String string, int n) {
        return 0;
    }

    public void deleteRule(int n) {
        if (n < 0 || n >= this.numRules) {
            return;
        }
        int n2 = n;
        while (n2 < this.numRules - 1) {
            this.rules[n2] = this.rules[n2 + 1];
            ++n2;
        }
        this.rules[this.numRules - 1] = null;
        --this.numRules;
    }

    void addRule(DCSSRule dCSSRule) {
        if (this.numRules == this.maxRules) {
            this.maxRules *= 2;
            DCSSRule[] dCSSRuleArray = new DCSSRule[this.maxRules];
            System.arraycopy(this.rules, 0, dCSSRuleArray, 0, this.numRules);
            this.rules = dCSSRuleArray;
        }
        this.rules[this.numRules++] = dCSSRule;
    }

    String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numRules) {
            stringBuffer.append(this.rules[n].getCssText());
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DRuleList.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DRuleList.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DRuleList.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                String string = dynEnv.toStr(objectArray, 0);
                int n2 = dynEnv.toInt(objectArray, 1);
                return dynEnv.wrapInt(this.insertRule(string, n2));
            }
            case -2: {
                int n3 = dynEnv.toInt(objectArray, 0);
                this.deleteRule(n3);
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        if (string.length() == 10) {
            char c = string.charAt(0);
            if (c == 'd') {
                string2 = "deleteRule";
                n = -2;
            } else if (c == 'i') {
                string2 = "insertRule";
                n = -1;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

