/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.LexBase;
import ice.dombase.Nbrs;
import ice.pilots.html4.CSSBuilder;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DXmlElement;
import ice.pilots.html4.HtmlDOMFixer;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.Names;
import ice.pilots.html4.ProgressDetail;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.Transformer;
import ice.storm.StormBase;
import ice.util.alg.CharKit;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Node;

public final class DOMBuilder
implements LexCallback,
Nbrs {
    private boolean titleEventFired;
    private DDocument doc;
    private ThePilot pilot;
    private DNode startNode;
    private DNode curNode = null;
    private HtmlDOMFixer fixer;
    private boolean encodingChanged = false;
    private String totalLengthString = null;
    private boolean spaceAdded = false;
    private boolean isPre = false;
    private boolean preJustStarted = false;
    private boolean isTextArea = false;
    private boolean textAreaJustStarted = false;
    private String xmlBody;
    private String scriptBody = null;
    private String scriptLanguage = null;
    private int[] attrIds = new int[50];
    private String[] attrNames = new String[50];
    private String[] attrValues = new String[50];
    private int numAttrs = 0;
    private boolean isXmlnsPending = false;
    private Stack prefixDefs = new Stack();
    private Stack nsDefs = new Stack();
    private int defaultNamespace = 0;
    private DFormElement curHackForm;
    private Vector eventScripts = new Vector();
    private String xsltSheet;
    private int iframeNesting;
    boolean noJS = false;
    private int cdataStartLine;
    boolean loadSingleOnly = false;
    private char[] textBuffer = new char[2048];
    private int textBufferPos = 0;

    public static void setLoadSingleOnly(StormBase stormBase) {
        StormData stormData = StormData.get(stormBase);
        stormData.setLoadSingleOnly(true);
    }

    public DOMBuilder(DDocument dDocument, ThePilot thePilot) {
        this(dDocument, dDocument, thePilot);
    }

    public DOMBuilder(DDocument dDocument, DNode dNode, ThePilot thePilot) {
        this.doc = dDocument;
        this.startNode = dNode;
        this.pilot = thePilot;
        if (thePilot != null) {
            StormData stormData = StormData.get(thePilot.getStorm());
            this.loadSingleOnly = stormData.getLoadSingleOnly();
        }
    }

    public boolean isStopRequested() {
        if (this.pilot == null) {
            return false;
        }
        return this.pilot.isStopRequested();
    }

    public void progress(int n, ProgressDetail progressDetail) {
        if (this.startNode != this.doc) {
            return;
        }
        if (this.pilot == null) {
            return;
        }
        String string = this.pilot.getPilotViewport().getLocation();
        if (string == null) {
            return;
        }
        if (this.totalLengthString == null) {
            this.totalLengthString = this.pilot.getPageInfo("content-length");
            if (this.totalLengthString == null) {
                this.totalLengthString = "-1";
            }
        }
        this.pilot.firePropertyChange("contentLoadingProgress", progressDetail, string + " " + n + " " + this.totalLengthString);
    }

    public void startDocument() {
        this.fixer = new HtmlDOMFixer(this.doc);
        this.numAttrs = 0;
        this.titleEventFired = false;
        this.curNode = this.startNode;
        this.defaultNamespace = this.doc.defaultNamespace;
    }

    public void endDocument() {
        block9: {
            DNode dNode;
            Object object;
            String string;
            Object object2;
            if (this.textBufferPos > 0) {
                this.addTextNode();
            }
            this.curNode = null;
            this.curHackForm = null;
            this.fixer.moveIsIndexElements();
            this.fixer = null;
            this.prefixDefs.removeAllElements();
            this.nsDefs.removeAllElements();
            int n = 0;
            while (n < this.eventScripts.size()) {
                object2 = (String)this.eventScripts.elementAt(n);
                string = (String)this.eventScripts.elementAt(n + 1);
                object = (String)this.eventScripts.elementAt(n + 2);
                dNode = null;
                dNode = ((String)object2).equals("document") || ((String)object2).equals("window") ? this.doc.getDBody() : (DNode)((Object)this.doc.getElementById((String)object2));
                if (dNode != null) {
                    int n2 = this.doc.names.getAttrId(3, string);
                    dNode.setDAttr(n2, object, false);
                }
                n += 3;
            }
            this.eventScripts.removeAllElements();
            if (this.pilot != null) {
                this.pilot.moveToBodyTmpBodyEventHandlers();
            }
            object2 = this.doc.getDom().getTransformFactory();
            if (this.xsltSheet != null && object2 != null) {
                try {
                    string = this.doc.resolveUrl(this.xsltSheet);
                    if (Debug.trace) {
                        Debug.trace("External XSL: url=" + string);
                    }
                    object = this.doc.openUrlReader(string);
                    dNode = this.doc.getDom().createDDocument(this.doc.pilot, false);
                    DOMBuilder dOMBuilder = new DOMBuilder((DDocument)dNode, null);
                    Lex2 lex2 = new Lex2(dOMBuilder);
                    lex2.setReader((Reader)object);
                    lex2.parse();
                    ((Reader)object).close();
                    Transformer transformer = object2.createTransformer();
                    DElement dElement = (DElement)this.doc.getDocumentElement();
                    this.doc.removeChild(dElement);
                    DNode dNode2 = (DNode)((Object)this.doc.createDocumentFragment());
                    dNode2.appendChild(dElement);
                    this.doc.defaultNamespace = 3;
                    transformer.transform((Node)dNode2, (Node)dNode, this.doc);
                    if (this.doc != null && this.doc.pilot != null) {
                        this.doc.pilot.refresh();
                    }
                }
                catch (Exception exception) {
                    if (!Debug.ex) break block9;
                    Debug.ex(exception);
                }
            }
        }
    }

    public void documentCharset(String string) {
        this.doc.setDefaultCharset(string);
        this.encodingChanged = true;
    }

    public void cdataBody(char[] cArray, int n, int n2) {
        this.appendChars(cArray, n, n2);
    }

    public void textCharacters(char[] cArray, int n, int n2) {
        if (this.isPre) {
            this.appendPreText(cArray, n, n2);
        } else if (this.isTextArea) {
            this.appendTextAreaText(cArray, n, n2);
        } else {
            this.appendDefaultText(cArray, n, n2);
        }
    }

    public void startElement(LexBase lexBase, char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4;
        String string;
        int n5;
        Object object;
        int n6;
        int n7;
        String string2;
        int n8;
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        if (cArray[n] == '!') {
            this.numAttrs = 0;
            return;
        }
        if (cArray[n] == '?') {
            String string3 = new String(cArray, n + 1, n2 - 1);
            if (string3.equalsIgnoreCase("xml-stylesheet")) {
                String string4 = null;
                String string5 = null;
                String string6 = null;
                int n9 = 0;
                while (n9 < this.numAttrs) {
                    if (this.attrNames[n9].equals("href")) {
                        string4 = this.attrValues[n9];
                    } else if (this.attrNames[n9].equals("type")) {
                        string5 = this.attrValues[n9];
                    } else if (this.attrNames[n9].equals("media")) {
                        string6 = this.attrValues[n9];
                    }
                    ++n9;
                }
                if (string4 != null) {
                    this.linkStyleSheet(lexBase, string4, string5, string6, null, this.doc);
                }
            }
            this.numAttrs = 0;
            return;
        }
        if (this.isXmlnsPending) {
            n8 = 0;
            while (n8 < this.numAttrs) {
                string2 = this.attrNames[n8];
                if (CharKit.startsWithIgnoreAsciiCase(string2, "xmlns")) {
                    String string7 = this.attrValues[n8];
                    n7 = !"".equals(string7) ? this.doc.names.getNamespace(string7) : 5;
                    n6 = string2.indexOf(58);
                    if (n6 < 0) {
                        this.defaultNamespace = n7;
                        object = new NSEntry(null, n7, null);
                        this.nsDefs.push(object);
                    } else {
                        object = string2.substring(n6 + 1);
                        NSEntry nSEntry = new NSEntry(null, n7, (String)object);
                        this.prefixDefs.push(nSEntry);
                    }
                }
                ++n8;
            }
        }
        n8 = this.defaultNamespace;
        if (n3 > 0) {
            string2 = new String(cArray, n, n3 - 1);
            int n10 = this.getNamespaceFromPrefix(string2);
            if (n10 >= 0) {
                n8 = n10;
            } else {
                this.isXmlnsPending = false;
                this.numAttrs = 0;
                return;
            }
        }
        if (n2 >= 8 && CharKit.startsWith(cArray, n, n + n2, "itemtb")) {
            CharKit.asciiToUpperCase(cArray, n, n + n2);
            n8 = 5;
        }
        if ((n5 = this.doc.names.getTagId(n8, cArray, n + n3, n2 - n3)) < 0) {
            this.isXmlnsPending = false;
            this.numAttrs = 0;
            return;
        }
        if (n5 == 14) {
            this.spaceAdded = true;
        }
        if (n5 == 32 && this.curHackForm != null) {
            this.isXmlnsPending = false;
            this.numAttrs = 0;
            return;
        }
        DElement dElement = this.doc.createElement(n5);
        if (n3 > 0) {
            dElement.qname = new String(cArray, n, n2);
        }
        if (this.numAttrs > this.attrIds.length) {
            this.attrIds = new int[this.attrNames.length];
        }
        if (this.isXmlnsPending) {
            this.isXmlnsPending = false;
            n7 = this.nsDefs.size() - 1;
            while (n7 >= 0) {
                NSEntry nSEntry = (NSEntry)this.nsDefs.elementAt(n7);
                if (nSEntry.node != null) break;
                nSEntry.node = dElement;
                n7 -= 1;
            }
            n6 = this.prefixDefs.size() - 1;
            while (n6 >= 0) {
                object = (NSEntry)this.prefixDefs.elementAt(n6);
                if (((NSEntry)object).node != null) break;
                ((NSEntry)object).node = dElement;
                --n6;
            }
            object = this.doc.names;
            int n11 = 0;
            while (n11 < this.numAttrs) {
                string = this.attrNames[n11];
                int n12 = string.indexOf(58);
                if (n12 < 0) {
                    this.attrIds[n11] = ((Names)object).getAttrId(n8, string);
                } else {
                    n4 = 0;
                    String string8 = string.substring(0, n12);
                    int n13 = this.getNamespaceFromPrefix(string8);
                    if (n13 >= 0) {
                        n4 = n13;
                    }
                    this.attrIds[n11] = ((Names)object).getAttrId(n4, string);
                }
                ++n11;
            }
        } else {
            n7 = 0;
            while (n7 < this.numAttrs) {
                this.attrIds[n7] = this.doc.names.getAttrId(n8, this.attrNames[n7]);
                n7 += 1;
            }
        }
        dElement.setAttributes(this.attrIds, this.attrValues, this.numAttrs);
        this.numAttrs = 0;
        this.curNode = this.fixer.addChildNode(this.curNode, dElement);
        if (bl && this.curNode != null && this.curNode.getNameId() == n5) {
            this.curNode = this.curNode.getParentDNode();
        }
        if (this.curNode != dElement) {
            this.closeNamespaces(dElement, this.curNode);
        }
        switch (n5) {
            case 94: {
                if (bl) {
                    this.loadIfGivenExternalXML((DXmlElement)dElement);
                    break;
                }
                lexBase.reqEmbeddedXml();
                break;
            }
            case 76: {
                lexBase.reqCdata();
                break;
            }
            case 70: {
                if (!this.shouldIgnoreScripts()) {
                    this.scriptLanguage = dElement.getAttribute(54);
                    n7 = 0;
                    if (this.scriptLanguage == null || this.scriptLanguage.length() == 0 || this.scriptLanguage.equals("language") || this.scriptLanguage.equals("liveScript")) {
                        this.scriptLanguage = "ECMAScript";
                    } else if (this.scriptLanguage.equalsIgnoreCase("vbscript")) {
                        n7 = 1;
                    }
                    this.fixer.setAllowNoScript(n7 != 0);
                    if (bl) {
                        this.loadIfGivenExternalScript(dElement);
                    }
                }
                if (bl) break;
                this.cdataStartLine = lexBase.lineNumber;
                lexBase.reqScriptCdata();
                break;
            }
            case 54: {
                String string9 = dElement.getAttribute(90);
                String string10 = dElement.getAttribute(46);
                object = dElement.getAttribute(111);
                if (string9 == null || string10 == null || !string9.equalsIgnoreCase("stylesheet")) break;
                this.linkStyleSheet(lexBase, string10, (String)object, dElement.getAttribute(60), dElement.getAttribute(110), dElement);
                break;
            }
            case 57: {
                String string11 = dElement.getAttribute("charset");
                if (string11 != null && !this.encodingChanged) {
                    this.encodingChanged = true;
                    if (this.applyEncodingChange(string11, (Lex2)lexBase)) {
                        return;
                    }
                }
                string = dElement.getAttribute(49);
                String string12 = dElement.getAttribute(31);
                if (string == null || string12 == null) break;
                if (string.equalsIgnoreCase("content-type")) {
                    n4 = string12.toLowerCase().indexOf("charset");
                    if (n4 <= 0 || this.encodingChanged) break;
                    this.encodingChanged = true;
                    if ((n4 = string12.indexOf(61, n4)) <= 0 || !this.applyEncodingChange(string12 = string12.substring(n4 + 1).trim(), (Lex2)lexBase)) break;
                    return;
                }
                if (!string.equalsIgnoreCase("set-cookie")) break;
                this.doc.setCookie(string12);
                break;
            }
            case 66: {
                this.isPre = true;
                this.preJustStarted = true;
                break;
            }
            case 34: {
                this.doc.isFrameset = true;
                break;
            }
            case 8: {
                String string13 = dElement.getAttribute(46);
                String string14 = dElement.getAttribute(108);
                if (string13 != null) {
                    this.doc.setBaseUrl(this.doc.resolveUrl(string13));
                }
                if (string14 == null) break;
                this.doc.setBaseTarget(string14);
                break;
            }
            case 13: {
                this.doc.validateBodyAttrs();
                break;
            }
            case 32: {
                this.curHackForm = (DFormElement)dElement;
                break;
            }
            case 15: 
            case 47: {
                if (this.curHackForm == null) break;
                this.curHackForm.addHackElement(dElement);
                if (this.curHackForm.getParentNode() != null || dElement.getParentNode() == null) break;
                dElement.getParentNode().insertBefore(this.curHackForm, dElement);
                break;
            }
            case 82: {
                this.isTextArea = true;
                this.textAreaJustStarted = true;
                if (this.curHackForm == null) break;
                this.curHackForm.addHackElement(dElement);
                if (this.curHackForm.getParentNode() != null || dElement.getParentNode() == null) break;
                dElement.getParentNode().insertBefore(this.curHackForm, dElement);
                break;
            }
            case 71: {
                if (this.curHackForm == null) break;
                this.curHackForm.addHackElement(dElement);
                if (this.curHackForm.getParentNode() != null || dElement.getParentNode() == null) break;
                dElement.getParentNode().insertBefore(this.curHackForm, dElement);
                break;
            }
            case 45: {
                if (cArray[n] == 'e' || cArray[n] == 'E') {
                    if (this.curNode != dElement) break;
                    this.curNode = dElement.getParentDNode();
                    break;
                }
                if (bl) break;
                ++this.iframeNesting;
                break;
            }
            case 46: {
                this.spaceAdded = false;
            }
        }
    }

    private boolean applyEncodingChange(String string, Lex2 lex2) {
        if (lex2.applyEncodingChange(string)) {
            this.doc.clear();
            this.doc.setUnresolvedCharset(string);
            this.doc.setDefaultCharset(string);
            this.startDocument();
            return true;
        }
        return false;
    }

    public void elementAttribute(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        String string;
        if (n3 > 0) {
            this.isXmlnsPending = true;
        } else if (CharKit.startsWithIgnoreAsciiCase(cArray, n, n + n2, "xml")) {
            this.isXmlnsPending = true;
        }
        String string2 = new String(cArray, n, n2);
        if (n != n4) {
            string = new String(cArray, n4, n5);
        } else if (this.defaultNamespace == 3 && n3 == 0) {
            if (string2.equalsIgnoreCase("value")) {
                return;
            }
            string = string2;
        } else {
            string = "";
        }
        int n6 = this.attrNames.length;
        if (this.numAttrs == n6) {
            String[] stringArray = new String[n6 * 2];
            System.arraycopy(this.attrNames, 0, stringArray, 0, n6);
            this.attrNames = stringArray;
            stringArray = new String[n6 * 2];
            System.arraycopy(this.attrValues, 0, stringArray, 0, n6);
            this.attrValues = stringArray;
        }
        this.attrNames[this.numAttrs] = string2;
        this.attrValues[this.numAttrs] = string;
        ++this.numAttrs;
    }

    public void endElement(LexBase lexBase, char[] cArray, int n, int n2, int n3) {
        Object object;
        DNode dNode;
        int n4;
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        int n5 = this.defaultNamespace;
        if (n3 > 0) {
            String string = new String(cArray, n, n3 - 1);
            int n6 = this.getNamespaceFromPrefix(string);
            if (n6 >= 0) {
                n5 = n6;
            } else {
                return;
            }
        }
        if ((n4 = this.doc.names.getTagId(n5, cArray, n + n3, n2 - n3)) == 86 && this.fixer.parentOfIllegalTitleNode != null) {
            this.fixer.parentOfIllegalTitleNode = null;
            return;
        }
        if (n4 < 0) {
            return;
        }
        String string = null;
        DElement dElement = null;
        DElement dElement2 = null;
        switch (n4) {
            case 87: {
                if (this.curNode.getNameId() != 87) break;
                this.fixer.onClosingTR(this.curNode);
                break;
            }
            case 81: {
                this.fixer.closeLastBreakNode();
                break;
            }
            case 79: {
                if (!this.fixer.hasHackTable()) break;
                this.curNode = this.fixer.closeHackTable(false);
                break;
            }
            case 66: {
                this.isPre = false;
                break;
            }
            case 82: {
                this.isTextArea = false;
                break;
            }
            case 86: {
                if (this.pilot == null || this.titleEventFired) break;
                this.pilot.firePropertyChange("title", null, this.doc.getTitle());
                this.titleEventFired = true;
                break;
            }
            case 70: {
                if (!this.shouldIgnoreScripts() && this.curNode != null && this.curNode.tagId == 70) {
                    dElement = (DElement)this.curNode;
                    string = this.scriptBody;
                }
                this.scriptBody = null;
                break;
            }
            case 94: {
                if (this.curNode != null && this.curNode.tagId == 94 && !this.loadIfGivenExternalXML((DXmlElement)(dNode = (DXmlElement)this.curNode)) && this.xmlBody != null && (object = this.doc.getDom().parseEmbeddedDocumentFromString(this.xmlBody)) != null) {
                    ((DXmlElement)dNode).setGeneratedDocument((DDocument)object);
                }
                this.xmlBody = null;
                break;
            }
            case 32: {
                this.curHackForm = null;
                break;
            }
            case 5: {
                if (this.curNode == null || !(this.curNode instanceof DAppletElement)) break;
                dNode = (DAppletElement)this.curNode;
                ((DAppletElement)dNode).setLoaded();
                this.doc.mutate();
                break;
            }
            case 43: {
                if (this.doc.defaultNamespace != 3) break;
                return;
            }
            case 45: {
                dElement2 = (DElement)this.curNode;
            }
        }
        dNode = this.checkClosing(true, n4);
        if (dNode == null) {
            this.checkClosing(false, n4);
        }
        if (dElement != null && this.pilot != null && !this.loadIfGivenExternalScript(dElement) && string != null && !this.checkScriptEventHandler(dElement, (String)(object = this.cleanupScript(string)))) {
            String string2 = this.doc.getBaseUrl();
            this.pilot.doScriptEval(this.scriptLanguage, (String)object, string2, this.cdataStartLine);
        }
    }

    private boolean loadIfGivenExternalXML(DXmlElement dXmlElement) {
        Object var2_2 = null;
        String string = dXmlElement.getAttribute(102);
        if (string == null) {
            string = dXmlElement.getAttribute(90);
        }
        if (string != null) {
            String string2 = this.doc.resolveUrl(string);
            if (string2 != null) {
                DDocument dDocument;
                block10: {
                    dDocument = null;
                    if (this.loadSingleOnly) {
                        return true;
                    }
                    if (Debug.trace) {
                        Debug.trace("External XML: url=" + string2);
                    }
                    try {
                        Reader reader = this.doc.openUrlReader(string2);
                        try {
                            dDocument = this.doc.getDom().parseEmbeddedDocumentFromReader(reader);
                            Object var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            reader.close();
                            throw throwable;
                        }
                        reader.close();
                        {
                        }
                    }
                    catch (IOException iOException) {
                        if (!Debug.ex) break block10;
                        Debug.ex(iOException);
                    }
                }
                if (dDocument != null) {
                    dXmlElement.setGeneratedDocument(dDocument);
                }
            }
            return true;
        }
        return false;
    }

    private boolean loadIfGivenExternalScript(DElement dElement) {
        String string = dElement.getAttribute(102);
        if (string != null) {
            if (this.loadSingleOnly) {
                return true;
            }
            String string2 = this.doc.resolveUrl(string);
            if (string2 != null) {
                String string3;
                if (Debug.trace) {
                    Debug.trace("External script: url=" + string2);
                }
                if ((string3 = this.loadDataOrNull(string2)) != null && this.pilot != null && !this.checkScriptEventHandler(dElement, string3)) {
                    this.pilot.doScriptEval(this.scriptLanguage, string3, string2.toString(), 0);
                }
            }
            return true;
        }
        return false;
    }

    private String cleanupScript(String string) {
        String string2 = string.trim();
        if (string2.endsWith("-->")) {
            string = string2.substring(0, string2.length() - 3);
        }
        return string;
    }

    private boolean checkScriptEventHandler(DElement dElement, String string) {
        String string2 = dElement.getAttribute(120);
        String string3 = dElement.getAttribute(41);
        if (string3 != null && string2 != null) {
            this.eventScripts.addElement(string3);
            this.eventScripts.addElement(string2);
            this.eventScripts.addElement(string);
            return true;
        }
        return false;
    }

    DNode checkClosing(boolean bl, int n) {
        DNode dNode = this.curNode;
        while (dNode != null) {
            if (dNode instanceof DElement) {
                DElement dElement = (DElement)dNode;
                if (!bl || !dElement.getSynthetic()) {
                    if (dElement.tagId == n || this.fixer.tagsAreSynonymous(dElement, n)) {
                        DNode dNode2 = this.curNode;
                        this.curNode = dElement.getParentDNode();
                        this.closeNamespaces(dNode2, this.curNode);
                        if (n != 45 || this.iframeNesting == 0) break;
                        --this.iframeNesting;
                        break;
                    }
                    if (!this.fixer.canCloseNodeWith(dNode, n)) {
                        dNode = null;
                        break;
                    }
                }
            }
            dNode = dNode.getParentDNode();
        }
        return dNode;
    }

    String removeBufferedChars() {
        String string = new String(this.textBuffer, 0, this.textBufferPos);
        this.textBufferPos = 0;
        return string;
    }

    private final void addTextNode() {
        DTextNode dTextNode = this.doc.createDTextNode(this.textBuffer, 0, this.textBufferPos, this.isPre || this.isTextArea);
        this.curNode = this.fixer.addChildNode(this.curNode, dTextNode);
        if (this.isTextArea && this.curNode instanceof DTextAreaElement) {
            ((DTextAreaElement)this.curNode).getValue();
        }
        this.textBufferPos = 0;
        if (this.curNode instanceof DElement) {
            DElement dElement = (DElement)this.curNode;
            if (dElement.tagId == 76) {
                try {
                    DStyleSheet dStyleSheet = this.doc.getDom().createDStyleSheet(this.doc.defaultNamespace, dElement, null, null);
                    CSSBuilder cSSBuilder = new CSSBuilder(this.doc);
                    cSSBuilder.build(dStyleSheet, new CharArrayReader(dTextNode.text), this.doc.getBaseUrl());
                    this.doc.addStyleSheet(dStyleSheet);
                }
                catch (IOException iOException) {
                    if (Debug.ex) {
                        Debug.ex(iOException);
                    }
                }
            } else if (dElement.tagId == 70) {
                if (!this.shouldIgnoreScripts()) {
                    this.scriptBody = dTextNode.getNodeValue();
                }
            } else if (dElement.tagId == 94) {
                this.xmlBody = dTextNode.getNodeValue();
            }
        }
    }

    private void ensureTextBufferAppend(int n) {
        int n2 = this.textBufferPos + n;
        int n3 = this.textBuffer.length;
        if (n2 > n3) {
            if (n2 > (n3 *= 2)) {
                n3 = n2;
            }
            char[] cArray = new char[n3];
            if (this.textBufferPos != 0) {
                System.arraycopy(this.textBuffer, 0, cArray, 0, this.textBufferPos);
            }
            this.textBuffer = cArray;
        }
    }

    private void appendChars(char[] cArray, int n, int n2) {
        this.ensureTextBufferAppend(n2);
        System.arraycopy(cArray, n, this.textBuffer, this.textBufferPos, n2);
        this.textBufferPos += n2;
    }

    private void appendPreText(char[] cArray, int n, int n2) {
        this.ensureTextBufferAppend(n2);
        int n3 = n;
        int n4 = this.textBufferPos;
        while (n3 < n + n2) {
            int n5 = cArray[n3];
            if (n5 == 12) {
                n5 = 10;
            } else if (n5 == 10) {
                if (n3 < n + n2 - 1 && cArray[n3 + 1] == '\r') {
                    ++n3;
                }
            } else if (n5 == 13) {
                if (n3 < n + n2 - 1 && cArray[n3 + 1] == '\n') {
                    ++n3;
                }
                n5 = 10;
            } else if (n5 == 9) {
                n5 = 32;
            }
            ++n3;
            if (!this.preJustStarted || n4 != this.textBufferPos || n5 != 10) {
                this.textBuffer[n4++] = n5;
            }
            this.preJustStarted = false;
        }
        this.textBufferPos = n4;
    }

    private void appendTextAreaText(char[] cArray, int n, int n2) {
        this.ensureTextBufferAppend(n2);
        int n3 = n;
        int n4 = this.textBufferPos;
        while (n3 < n + n2) {
            int n5 = cArray[n3];
            if (n5 == 12) {
                n5 = 10;
            } else if (n5 == 10) {
                if (n3 < n + n2 - 1 && cArray[n3 + 1] == '\r') {
                    ++n3;
                }
            } else if (n5 == 13) {
                if (n3 < n + n2 - 1 && cArray[n3 + 1] == '\n') {
                    ++n3;
                }
                n5 = 10;
            } else if (n5 == 9) {
                n5 = 32;
            }
            ++n3;
            if (!this.textAreaJustStarted || n4 != this.textBufferPos || n5 != 10) {
                this.textBuffer[n4++] = n5;
            }
            this.textAreaJustStarted = false;
        }
        this.textBufferPos = n4;
    }

    private void appendDefaultText(char[] cArray, int n, int n2) {
        this.ensureTextBufferAppend(n2);
        char[] cArray2 = this.textBuffer;
        int n3 = 0;
        int n4 = n;
        int n5 = this.textBufferPos;
        int n6 = n + n2;
        while (n4 != n6 && DOMBuilder.isWhiteSpace(n3 = cArray[n4])) {
            ++n4;
        }
        if (n4 != n && !this.spaceAdded) {
            if (this.fixer.isFirstWhitespaceAllowed(this.curNode)) {
                cArray2[n5++] = 32;
            }
            this.spaceAdded = true;
        }
        if (n4 != n6) {
            cArray2[n5++] = n3;
            ++n4;
            boolean bl = true;
            while (n4 != n6) {
                n3 = cArray[n4];
                if (bl) {
                    if (DOMBuilder.isWhiteSpace(n3)) {
                        bl = false;
                        n3 = 32;
                    }
                    cArray2[n5++] = n3;
                } else if (!DOMBuilder.isWhiteSpace(n3)) {
                    cArray2[n5++] = n3;
                    bl = true;
                }
                ++n4;
            }
            this.spaceAdded = !bl;
        }
        this.textBufferPos = n5;
    }

    private static boolean isWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 12 || n == 0;
    }

    private String loadDataOrNull(String string) {
        try {
            String string2;
            Reader reader = this.doc.openUrlReader(string);
            try {
                int n;
                int n2 = 0;
                char[] cArray = new char[2048];
                while ((n = reader.read(cArray, n2, cArray.length - n2)) >= 0) {
                    if ((n2 += n) != cArray.length) continue;
                    char[] cArray2 = new char[n2 * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    cArray = cArray2;
                }
                string2 = new String(cArray, 0, n2);
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return string2;
        }
        catch (IOException iOException) {
            if (Debug.ex) {
                Debug.ex(iOException);
            }
            return null;
        }
    }

    private void linkStyleSheet(LexBase lexBase, String string, String string2, String string3, String string4, DNode dNode) {
        String string5;
        if (string2 != null) {
            if (string2.equalsIgnoreCase("text/xsl")) {
                this.xsltSheet = string;
                return;
            }
            if (!string2.equalsIgnoreCase("text/css")) {
                return;
            }
        }
        if ((string5 = this.doc.resolveUrl(string)) != null) {
            boolean bl;
            DStyleSheet dStyleSheet;
            block13: {
                dStyleSheet = this.doc.getDom().createDStyleSheet(this.doc.defaultNamespace, dNode, null, null);
                dStyleSheet.setHref(string5);
                if (dNode != null) {
                    dStyleSheet.setTitle(string4);
                }
                if (string3 != null) {
                    dStyleSheet.getMedia().setMediaText(string3);
                }
                CSSBuilder cSSBuilder = new CSSBuilder(this.doc);
                bl = false;
                if (this.loadSingleOnly) {
                    return;
                }
                if (Debug.trace) {
                    Debug.trace("External style: url=" + string5 + " type=" + string2);
                }
                try {
                    Reader reader = this.doc.openUrlReader(string5);
                    try {
                        cSSBuilder.build(dStyleSheet, reader, string5);
                        bl = true;
                        Object var13_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block13;
                    Debug.ex(iOException);
                }
            }
            if (bl) {
                this.doc.addStyleSheet(dStyleSheet);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void closeNamespaces(DNode var1_1, DNode var2_2) {
        ** GOTO lbl15
        {
            var3_3 = (NSEntry)this.prefixDefs.peek();
            if (var3_3.node != var1_1) ** GOTO lbl8
            this.prefixDefs.pop();
            do {
                if (!this.prefixDefs.empty()) continue block0;
lbl8:
                // 3 sources

                while (!this.nsDefs.empty()) {
                    var3_3 = (NSEntry)this.nsDefs.peek();
                    if (var3_3.node != var1_1) break;
                    this.nsDefs.pop();
                }
                var1_1 = var1_1.getParentDNode();
lbl15:
                // 2 sources

            } while (var1_1 != null && var1_1 != var2_2);
        }
        if (this.nsDefs.empty()) {
            this.defaultNamespace = this.doc.defaultNamespace;
        } else {
            var3_3 = (NSEntry)this.nsDefs.peek();
            this.defaultNamespace = var3_3.nsId;
        }
    }

    private final int getNamespaceFromPrefix(String string) {
        if ("xmlns".equals(string)) {
            return 2;
        }
        int n = this.prefixDefs.size() - 1;
        while (n >= 0) {
            NSEntry nSEntry = (NSEntry)this.prefixDefs.elementAt(n);
            if (nSEntry.prefix.equals(string)) {
                return nSEntry.nsId;
            }
            --n;
        }
        return -1;
    }

    boolean shouldIgnoreScripts() {
        int n;
        if (this.noJS) {
            return true;
        }
        boolean bl = false;
        if (this.curNode != null && ((n = this.curNode.tagId) == 58 || n == 59 || this.iframeNesting != 0)) {
            bl = true;
        }
        return bl;
    }

    static class NSEntry {
        DNode node;
        int nsId;
        String prefix;

        NSEntry(DNode dNode, int n, String string) {
            this.node = dNode;
            this.nsId = n;
            this.prefix = string;
        }
    }
}

