/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.Nbrs;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;

class DMapElementList
extends DynamicList
implements HTMLCollection,
Nbrs {
    private final DMapElement master;
    private final Vector v = new Vector();
    private HashArray named;
    private int mutation = 0;

    DMapElementList(DMapElement dMapElement) {
        this.master = dMapElement;
    }

    private void record() {
        this.mutation = this.master.doc.getMutation();
        this.v.removeAllElements();
        HashArray hashArray = new HashArray(Defs.NO_SYNCHRONIZATION);
        DMapElementList.record_r(this.v, hashArray, this.master);
        hashArray.sealObject();
        this.named = hashArray;
    }

    private static void record_r(Vector vector, HashArray hashArray, DNode dNode) {
        int n = dNode.tagId;
        if (n == 6 || n == 1) {
            DElement dElement = (DElement)dNode;
            vector.addElement(dElement);
            String string = dElement.getIdOrName();
            if (string != null) {
                hashArray.put(string, (Object)dElement);
            }
        }
        dNode = dNode.getFirstDChild();
        while (dNode != null) {
            DMapElementList.record_r(vector, hashArray, dNode);
            dNode = dNode.next;
        }
    }

    public int getLength() {
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.v.size();
    }

    public Node namedItem(String string) {
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        return (Node)this.named.get(string);
    }

    public Node item(int n) {
        if (this.master.doc.getMutation() != this.mutation) {
            this.record();
        }
        if (n < 0 || n >= this.v.size()) {
            return null;
        }
        return (Node)this.v.elementAt(n);
    }

    protected Object script_namedItem(String string, DynEnv dynEnv) {
        return this.namedItem(string);
    }

    protected Object script_item(int n, DynEnv dynEnv) {
        return this.item(n);
    }
}

