/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSLexCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class CSSLex {
    private Reader reader = null;
    private InputStream inputStream = null;
    private char[] buf = null;
    private int pos = 0;
    private int numRead = 0;
    private char c = '\u0000';
    private int openedBlocks = 0;
    private CSSLexCallback callback = null;
    private boolean[] quotes = new boolean[32];

    public void setLexCallback(CSSLexCallback cSSLexCallback) {
        this.callback = cSSLexCallback;
    }

    void setReader(Reader reader) {
        this.reader = reader;
    }

    public void parseInlineDeclaration(String string) {
        this.buf = string.toCharArray();
        this.openedBlocks = 0;
        this.pos = 0;
        this.numRead = this.buf.length;
        while (this.parseDeclaration()) {
        }
        this.buf = null;
    }

    public void parse() throws IOException {
        this.loadData();
        if (this.buf == null) {
            return;
        }
        this.callback.startStylesheet();
        this.openedBlocks = 0;
        this.pos = 0;
        this.numRead = this.buf.length;
        int n = 0;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f') {
                this.skipWhitespaceChars();
            } else if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            } else if (this.c == '@') {
                this.parseAtRule();
            } else if (this.c == '}') {
                if (this.openedBlocks > 0) {
                    --this.openedBlocks;
                    this.callback.endBlock();
                }
                ++this.pos;
            } else if (this.c == '<' && this.buf[this.pos + 1] == '!') {
                this.pos += 4;
            } else if (this.c == '-' && this.buf[this.pos + 1] == '-') {
                this.pos += 3;
            } else {
                this.parseSelector();
                if (this.c == '{') {
                    this.callback.startDeclBlock();
                    ++this.pos;
                    while (this.parseDeclaration()) {
                    }
                    this.callback.endDeclBlock();
                    ++this.pos;
                }
            }
            if (n == this.pos) {
                // empty if block
            }
            n = ++this.pos;
        }
        this.callback.endStylesheet();
    }

    private final void skipComment() {
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '*' && this.pos + 1 < this.numRead && this.buf[this.pos + 1] == '/') {
                this.pos += 2;
                if (this.pos >= this.numRead) break;
                this.c = this.buf[this.pos];
                break;
            }
            ++this.pos;
        }
    }

    private final void skipWhitespaceChars() {
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c != ' ' && this.c != '\t' && this.c != '\n' && this.c != '\r' && this.c != '\f') break;
            ++this.pos;
        }
    }

    private final void parseAtRule() {
        int n = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ';' || this.c == '{') break;
            if (this.c == '\'' || this.c == '\"') {
                this.skipString();
                continue;
            }
            ++this.pos;
        }
        this.callback.atRule(this.buf, n + 1, this.pos - n - 1);
        if (this.c == '{') {
            ++this.openedBlocks;
            this.callback.startBlock();
        }
        ++this.pos;
    }

    private final void parseSelector() {
        this.callback.startSelector();
        while (this.pos < this.buf.length - 1) {
            this.parseSimpleSelector();
            this.skipWhitespaceChars();
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            }
            if (this.c == '-' && this.buf[this.pos + 1] == '-' || this.c == '{') break;
            if (this.c == '+' || this.c == '>') {
                this.callback.selectorCombinator(this.c);
                ++this.pos;
                this.skipWhitespaceChars();
                if (this.c != '/' || this.buf[this.pos + 1] != '*') continue;
                this.skipComment();
                continue;
            }
            if (this.c == ',') {
                this.callback.endSelector();
                ++this.pos;
                this.callback.startSelector();
                this.skipWhitespaceChars();
                if (this.c != '/' || this.buf[this.pos + 1] != '*') continue;
                this.skipComment();
                continue;
            }
            this.callback.selectorCombinator(' ');
        }
        this.callback.endSelector();
    }

    /*
     * Unable to fully structure code
     */
    private final void parseSimpleSelector() {
        var1_1 = this.pos;
        var2_2 = 0;
        var3_3 = false;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f') {
                var3_3 = true;
                break;
            }
            if (this.c == '+' || this.c == '>') {
                var3_3 = true;
                break;
            }
            if (this.c == ',') {
                var3_3 = true;
                break;
            }
            if (this.c == '{') {
                var3_3 = true;
                break;
            }
            if (this.c == '.' || this.c == '#' || this.c == '[' || this.c == ':') break;
            if (this.c == '|') {
                var2_2 = this.pos - var1_1 + 1;
            } else if (this.c == '-' && this.pos + 1 < this.numRead && this.buf[this.pos + 1] == '-') {
                return;
            }
            ++this.pos;
        }
        if (var1_1 < this.pos) {
            this.callback.typeSelector(this.buf, var1_1, this.pos - var1_1, var2_2);
        }
        if (!var3_3) ** GOTO lbl76
        return;
lbl-1000:
        // 1 sources

        {
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            }
            if (this.c == '{' || this.c == ',') break;
            if (this.c == '.') {
                var1_1 = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= var1_1) continue;
                this.callback.classSelector(this.buf, var1_1, this.pos - var1_1);
                continue;
            }
            if (this.c == '#') {
                var1_1 = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= var1_1) continue;
                this.callback.idSelector(this.buf, var1_1, this.pos - var1_1);
                continue;
            }
            if (this.c == ':') {
                var1_1 = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= var1_1) continue;
                this.callback.pseudoSelector(this.buf, var1_1, this.pos - var1_1);
                continue;
            }
            if (this.c != '[') break;
            var1_1 = ++this.pos;
            while (this.pos < this.numRead) {
                this.c = this.buf[this.pos];
                if (this.c == ']') break;
                if (this.c == '\'' || this.c == '\"') {
                    this.skipString();
                    continue;
                }
                ++this.pos;
            }
            if (this.pos > var1_1) {
                this.callback.attributeSelector(this.buf, var1_1, this.pos - var1_1);
            }
            ++this.pos;
lbl76:
            // 8 sources

            ** while (this.pos < this.numRead)
        }
lbl77:
        // 3 sources

    }

    private final boolean parseDeclaration() {
        int n;
        this.skipWhitespaceChars();
        while (this.c == '/' && this.buf[this.pos + 1] == '*') {
            this.skipComment();
            this.skipWhitespaceChars();
        }
        if (this.pos >= this.numRead) {
            return false;
        }
        if (this.c == '}') {
            return false;
        }
        if (this.c == ';') {
            ++this.pos;
            return true;
        }
        int n2 = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\r' || this.c == '\f' || this.c == '/' || this.c == ':' || this.c == '=') break;
            ++this.pos;
        }
        if (this.pos >= this.numRead) {
            return false;
        }
        int n3 = this.pos - n2;
        boolean bl = false;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ':' || this.c == '=') {
                bl = true;
                ++this.pos;
                continue;
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
                continue;
            }
            if (this.c != ' ' && this.c != '\t' && this.c != '\n' && this.c != '\r' && this.c != '\f') break;
            ++this.pos;
        }
        if (this.pos >= this.numRead || !bl) {
            return false;
        }
        int n4 = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '}' || this.c == ';') break;
            if (this.c == '\'' || this.c == '\"') {
                this.skipString();
                continue;
            }
            ++this.pos;
        }
        if (this.pos > this.numRead) {
            return false;
        }
        int n5 = this.pos;
        while (n5 > n4) {
            if ((n = this.buf[--n5]) == 32 || n == 9 || n == 13 || n == 10 || n == 12) continue;
            ++n5;
            break;
        }
        if (n5 == n4) {
            return false;
        }
        n = n5 - n4;
        char c = this.buf[n4];
        char c2 = this.buf[n4 + n - 1];
        if (c == '\'' && c2 == '\'' || c == '\"' && c2 == '\"') {
            this.callback.declaration(this.buf, n2, n3, n4 + 1, n - 2);
        } else {
            this.callback.declaration(this.buf, n2, n3, n4, n);
        }
        if (this.c == ';') {
            ++this.pos;
            return true;
        }
        return false;
    }

    private final void skipString() {
        int n = 1;
        char c = this.buf[this.pos];
        if (c == '\'') {
            this.quotes[0] = false;
        } else if (c == '\"') {
            this.quotes[0] = true;
        } else {
            return;
        }
        ++this.pos;
        while (n > 0 && this.pos < this.numRead) {
            if ((c = this.buf[this.pos++]) == '\'') {
                if (!this.quotes[n - 1]) {
                    --n;
                    continue;
                }
                this.quotes[n++] = false;
                continue;
            }
            if (c != '\"') continue;
            if (this.quotes[n - 1]) {
                --n;
                continue;
            }
            this.quotes[n++] = true;
        }
    }

    private final void loadData() throws IOException {
        boolean bl = false;
        this.pos = 0;
        if (this.reader != null) {
            char[] cArray = new char[2048];
            int n = this.reader.read(cArray, this.pos, cArray.length - this.pos);
            while (n > 0) {
                this.pos += n;
                if (this.pos == cArray.length) {
                    char[] cArray2 = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                n = this.reader.read(cArray, this.pos, cArray.length - this.pos);
            }
            this.buf = new char[this.pos];
            System.arraycopy(cArray, 0, this.buf, 0, this.pos);
            this.reader.close();
            this.reader = null;
        } else {
            byte[] byArray = new byte[2048];
            int n = this.inputStream.read(byArray, this.pos, byArray.length - this.pos);
            while (n > 0) {
                this.pos += n;
                if (this.pos == byArray.length) {
                    byte[] byArray2 = new byte[byArray.length * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray = byArray2;
                }
                n = this.inputStream.read(byArray, this.pos, byArray.length - this.pos);
            }
            this.inputStream.close();
            this.buf = new char[this.pos];
            int n2 = 0;
            while (n2 < this.pos) {
                this.buf[n2] = (char)byArray[n2];
                ++n2;
            }
            this.inputStream = null;
        }
    }
}

