/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import org.w3c.dom.html.HTMLCollection;

public class VisitedLinks
implements PropertyChangeListener {
    private Hashtable visited = new Hashtable();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Viewport viewport = (Viewport)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("contentLoading")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (string2.equals("request")) {
                ContentLoader contentLoader = (ContentLoader)propertyChangeEvent.getOldValue();
                String string3 = contentLoader.getLocation();
                if (string3 != null) {
                    this.visited.put(string3, "visited");
                }
            } else if (string2.equals("end")) {
                this.traverseLinks(viewport);
            }
        }
    }

    public void clearLinks() {
        this.visited.clear();
    }

    private void traverseLinks(Viewport viewport) {
        if (viewport.getPilot() instanceof ThePilot) {
            boolean bl = false;
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            DDocument dDocument = (DDocument)thePilot.getDocument();
            HTMLCollection hTMLCollection = dDocument.getLinks();
            if (hTMLCollection == null) {
                return;
            }
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                DAnchorElement dAnchorElement;
                if (hTMLCollection.item(n) instanceof DAnchorElement && this.visited.containsKey((dAnchorElement = (DAnchorElement)hTMLCollection.item(n)).getHref())) {
                    bl = true;
                    dAnchorElement.setVisited(true);
                }
                ++n;
            }
            if (bl) {
                thePilot.refresh();
            }
        }
    }
}

