/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class SourceFrame
extends Frame
implements WindowListener,
ActionListener,
Runnable {
    private TextArea info;
    private String enc;
    private Frame parent;
    private Thread thread;
    private boolean done = false;
    private char[] buf;
    private MenuItem msaveas;

    public SourceFrame(Frame frame, char[] cArray) {
        this(frame, cArray, null);
    }

    public SourceFrame(Frame frame, char[] cArray, String string) {
        super("Page Source");
        this.enc = string;
        this.parent = frame;
        this.buf = cArray;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void run() {
        this.info = new TextArea();
        this.info.append(new String(this.buf));
        this.info.setEditable(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        this.add(this.info);
        this.msaveas = this.createMenuItem("Save as...");
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("File");
        menuBar.add(menu);
        menu.add(this.msaveas);
        this.addWindowListener(this);
        ((Component)this).setSize(300, 300);
        ((Component)this).setVisible(true);
    }

    private MenuItem createMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.msaveas) {
            this.save();
        }
    }

    private void save() {
        File file;
        String string = this.chooseFile();
        if (string == null || this.buf == null) {
            return;
        }
        File file2 = new File(string);
        if (file2.getParent() != null && !(file = new File(file2.getParent())).exists()) {
            file.mkdirs();
        }
        if (file2 != null) {
            this.do_save(this.enc, file2);
        }
    }

    private void do_save(String string, File file) {
        try {
            OutputStreamWriter outputStreamWriter = null;
            if (string == null) {
                outputStreamWriter = new FileWriter(file);
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            }
            outputStreamWriter.write(this.buf, 0, this.buf.length);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Unsupported encoding: " + string + ". Saving with default encoding.");
            this.do_save(null, file);
        }
        catch (Exception exception) {
            System.out.println("Could not save file...");
        }
    }

    private String chooseFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select file to Save:", 1);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return null;
        }
        String string = new String(fileDialog.getDirectory() + fileDialog.getFile());
        return string;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.done = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

