/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.HintDisplayer;
import ice.browser.MyCallback_swing;
import ice.browser.Tooltip;
import ice.pilots.html4.ThePilot;
import ice.storm.Hint;
import ice.storm.Pilot;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

class BrowserFrame_swing
extends JInternalFrame
implements ActionListener,
PropertyChangeListener,
InternalFrameListener {
    private MyCallback_swing master;
    private String viewportName;
    private JTextField loc;
    private JPanel panel;
    private String prevLoc;
    private Tooltip tooltip;

    BrowserFrame_swing(MyCallback_swing myCallback_swing, Viewport viewport) {
        super(viewport.getName(), true, true, true, true);
        this.master = myCallback_swing;
        this.viewportName = viewport.getId();
        this.addInternalFrameListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        myCallback_swing.base.addPropertyChangeListener(this, this.viewportName);
        this.loc = new JTextField("", 30);
        this.loc.setBackground(Color.white);
        this.loc.setForeground(Color.black);
        this.loc.addActionListener(this);
        this.panel = new JPanel();
        this.getContentPane().add((Component)this.loc, "South");
        this.getContentPane().add((Component)this.panel, "Center");
    }

    void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    JPanel getPanel() {
        return this.panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.loc) {
            int n;
            String string = this.viewportName;
            String string2 = this.loc.getText();
            int n2 = string2.indexOf(124);
            if (n2 >= 0) {
                string = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            }
            if ((n = string2.indexOf(58)) < 0) {
                int n3 = string2.indexOf(47);
                string2 = n3 == 0 ? "file://localhost" + string2 : "http://" + string2;
            }
            this.master.base.renderContent(string2, null, string);
            if (!string.equals(this.viewportName)) {
                this.loc.setText(this.prevLoc);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Pilot pilot;
        String string;
        Viewport viewport = (Viewport)propertyChangeEvent.getSource();
        boolean bl = viewport.getId().equals(this.viewportName);
        String string2 = propertyChangeEvent.getPropertyName();
        if (string2 == "hint") {
            Hint hint = (Hint)propertyChangeEvent.getNewValue();
            HintDisplayer.display(hint, this.master.base, viewport);
        } else if (string2 == "title") {
            if (bl) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this.setTitle("Storm - " + viewport.getName() + " - " + string3);
            }
        } else if (string2 == "location") {
            if (bl) {
                String string4 = (String)propertyChangeEvent.getNewValue();
                this.loc.setText(string4);
                this.prevLoc = this.loc.getText();
            }
        } else if (string2 != "statusLine" && string2 != "contentLoadingProgress" && string2 == "pilotLoading" && (string = (String)propertyChangeEvent.getNewValue()) == "end" && this.tooltip != null && (pilot = viewport.getPilot()) instanceof ThePilot) {
            ThePilot thePilot = (ThePilot)pilot;
            thePilot.addPersistentDOMEventListener("mouseover", this.tooltip, true);
            thePilot.addPersistentDOMEventListener("mouseout", this.tooltip, true);
        }
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.master.base.closeViewport(this.viewportName);
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }
}

