/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.util.Date;
import java.util.List;
import oracle.dbtools.raptor.runner.DBSourceFinder;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DatabaseDebuggingHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerHostDialog;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public class RaptorDebuggingHelper
implements DatabaseDebuggingHelper {
    private DebuggingProcess debuggingProcess;
    private OracleDatabase odb;
    private DBSourceFinder m_dbSrcFinder;
    private DebuggingListener databaseListener;
    private String probeSessionId;
    private final Object databaseConnectionSync = new Object();
    private Boolean databaseConnectionDone;
    private static final String CALL_DBMS_DEBUG_JDWP_CONNECT = "CALL DBMS_DEBUG_JDWP.CONNECT_TCP";

    public static void initialize() {
        DebuggingProcess.setDatabaseDebuggingHelperClass(RaptorDebuggingHelper.class);
    }

    public void setDebuggingProcess(DebuggingProcess debuggingProcess) {
        this.debuggingProcess = debuggingProcess;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRunInDatabase(Node node, Object object, List list) {
        if (object != null) {
            if (object instanceof OracleDatabase) {
                OracleDatabase oracleDatabase = (OracleDatabase)object;
                if (!RaptorDebuggingHelper.useJDWPForDatabase(oracleDatabase)) return true;
                if (RaptorDebuggingHelper.canGetLocalHost()) {
                    return true;
                }
                String string = DbgArb.format((int)870, (Object)node.getShortLabel());
                list.add(string);
                return false;
            } else {
                String string = DbgArb.format((int)868, (Object)node.getShortLabel());
                list.add(string);
            }
            return false;
        } else {
            String string = DbgArb.format((int)867, (Object)node.getShortLabel());
            list.add(string);
        }
        return false;
    }

    public String[][] getDatabaseCommands(Object object) {
        if (object instanceof OracleDatabase) {
            Object object2;
            this.odb = (OracleDatabase)object;
            this.m_dbSrcFinder = new DBSourceFinder(this.odb.getConnectionName());
            boolean bl = false;
            try {
                object2 = OracleDatabaseFactory.getOracleMajorMinorVersion((String)this.odb.getConnection().getMetaData().getDatabaseProductVersion());
                if (object2 != null && ((int[])object2).length == 2 && object2[0] == 9) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (RaptorDebuggingHelper.useJDWPForDatabase(this.odb)) {
                object2 = RaptorDebuggingHelper.getLocalHost(this.odb);
                if (RaptorDebuggingHelper.shouldPromptForDebuggerHost()) {
                    object2 = RaptorDebuggingHelper.promptForDebuggerHost((String)object2);
                }
                if (this.startDatabaseListener()) {
                    String string = this.debuggingProcess.getPort();
                    String[][] stringArray = new String[2][];
                    stringArray[0] = new String[bl ? 3 : 2];
                    int n = 0;
                    stringArray[0][n++] = "ALTER SESSION SET PLSQL_DEBUG=TRUE";
                    if (bl) {
                        stringArray[0][n++] = "ALTER SESSION SET PLSQL_COMPILER_FLAGS=INTERPRETED";
                    }
                    stringArray[0][n++] = "CALL DBMS_DEBUG_JDWP.CONNECT_TCP( '" + (String)object2 + "', '" + string + "' )";
                    stringArray[1] = new String[0];
                    return stringArray;
                }
            } else if (this.startProbeDebugging()) {
                int n = this.probeSessionId.length() + 1;
                n += 10 - n % 10;
                String[][] stringArray = new String[2][];
                stringArray[0] = new String[bl ? 3 : 2];
                int n2 = 0;
                stringArray[0][n2++] = "ALTER SESSION SET PLSQL_DEBUG=TRUE";
                if (bl) {
                    stringArray[0][n2++] = "ALTER SESSION SET PLSQL_COMPILER_FLAGS=INTERPRETED";
                }
                stringArray[0][n2++] = "DECLARE\n  id VARCHAR2( " + n + " );\n" + "BEGIN\n" + "  id := DBMS_DEBUG.initialize( '" + this.probeSessionId + "', 0 );\n" + "  DBMS_DEBUG.debug_on( TRUE );\n" + "END;";
                stringArray[1] = new String[1];
                stringArray[1][0] = "BEGIN\n  DBMS_DEBUG.debug_off();\nEND;";
                return stringArray;
            }
        }
        return null;
    }

    public void handleDatabaseError(String[][] stringArray, int n, int n2, int n3) {
        if (RaptorDebuggingHelper.useJDWPForDatabase(this.odb) && stringArray[n][n2].indexOf(CALL_DBMS_DEBUG_JDWP_CONNECT) != -1) {
            switch (n3) {
                case 1031: {
                    this.debuggingProcess.log((Object)DbgArb.getString((int)885));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForDatabase() {
        boolean bl = false;
        Object object = this.databaseConnectionSync;
        synchronized (object) {
            if (this.databaseConnectionDone != null) {
                bl = this.databaseConnectionDone;
            } else {
                try {
                    this.databaseConnectionSync.wait();
                    bl = this.databaseConnectionDone;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public void startTargetFailed() {
        this.setDatabaseConnectionDone(false);
        if (this.probeSessionId != null) {
            this.debuggingProcess.forceDetach();
        } else if (this.databaseListener != null) {
            this.databaseListener.stopListening();
            this.databaseListener = null;
        }
    }

    public void connectionAccepted() {
        if (this.databaseListener != null) {
            this.setDatabaseConnectionDone(true);
            this.databaseListener = null;
        }
    }

    public void listenerStopped() {
        if (this.databaseListener != null) {
            this.setDatabaseConnectionDone(false);
            this.databaseListener = null;
        }
    }

    public void finished() {
        if (this.databaseListener != null) {
            this.databaseListener.stopListening();
        }
    }

    public int getDebuggerFactory() {
        if (this.probeSessionId != null) {
            return 2;
        }
        return 1;
    }

    public URL findSourceFile(Workspace workspace, Project project, String string, String string2) {
        return this.m_dbSrcFinder.findSourceFile(workspace, project, string, string2);
    }

    private static boolean useJDWPForDatabase(OracleDatabase oracleDatabase) {
        return oracleDatabase.supportsDebugging() && Ide.getProperty((String)"DatabaseDebuggerDisableJDWP") == null;
    }

    private boolean startDatabaseListener() {
        if (this.databaseListener == null) {
            String string = this.debuggingProcess.getPort();
            if (string == null) {
                String string2 = Ide.getProperty((String)"DatabaseDebuggerPortOverride");
                string = string2 != null ? string2 : Integer.toString(DebuggingProcess.getLocalPort());
                this.debuggingProcess.setPort(string);
            }
            this.databaseListener = new DebuggingListener(this.debuggingProcess, false);
            if (!this.databaseListener.startListening(string)) {
                this.databaseListener = null;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldPromptForDebuggerHost() {
        DebugWindowSettings debugWindowSettings = DebugWindowSettings.getInstance();
        return debugWindowSettings.isPromptForDebuggerHostForDatabaseDebugging();
    }

    private static String promptForDebuggerHost(String string) {
        string = DebuggerHostDialog.showDebuggerHostDialog((String)string);
        return string;
    }

    private boolean startProbeDebugging() {
        if (this.probeSessionId == null) {
            String string = this.odb.getConnectionName();
            String string2 = RaptorDebuggingHelper.getLocalHost(this.odb);
            if (string2 == null) {
                string2 = "SQL Developer";
            }
            this.probeSessionId = string2 + ":" + new Date().getTime();
            DebugConnector debugConnector = DebugFactory.newInstance((int)2);
            DebugConnectArg[] debugConnectArgArray = debugConnector.getConnectArgs();
            assert (debugConnectArgArray.length == 2) : "Wrong number of arguments";
            debugConnectArgArray[0].setValue(string);
            debugConnectArgArray[1].setValue(this.probeSessionId);
            Runnable runnable = new Runnable(){

                public void run() {
                    RaptorDebuggingHelper.this.debuggingProcess.afterConnection(DbgArb.getString((int)206));
                    RaptorDebuggingHelper.this.setDatabaseConnectionDone(true);
                }
            };
            Runnable runnable2 = new Runnable(){

                public void run() {
                    RaptorDebuggingHelper.this.setDatabaseConnectionDone(false);
                    RaptorDebuggingHelper.this.debuggingProcess.log((Object)DbgArb.getString((int)207));
                    RaptorDebuggingHelper.this.debuggingProcess.superTerminate();
                }
            };
            Runnable runnable3 = new Runnable(){

                public void run() {
                    RaptorDebuggingHelper.this.setDatabaseConnectionDone(false);
                    RaptorDebuggingHelper.this.debuggingProcess.superTerminate();
                }
            };
            String string3 = DbgArb.getString((int)204);
            String string4 = DbgArb.getString((int)205);
            this.debuggingProcess.connectToDebuggee(debugConnector, debugConnectArgArray, string3, string4, runnable, runnable2, runnable3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDatabaseConnectionDone(boolean bl) {
        Object object = this.databaseConnectionSync;
        synchronized (object) {
            this.databaseConnectionDone = bl ? Boolean.TRUE : Boolean.FALSE;
            this.databaseConnectionSync.notify();
        }
    }

    private static boolean canGetLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getLocalHost(OracleDatabase oracleDatabase) {
        try {
            String string = oracleDatabase.getConnectionName();
            Connections connections = Connections.getInstance();
            ConnectionDescriptor connectionDescriptor = connections.getConnectionInfo(string);
            connections.populateConnectionInfo(connectionDescriptor);
            String string2 = connectionDescriptor.getHostname();
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.connect(InetAddress.getByName(string2), 7);
            return datagramSocket.getLocalAddress().getHostAddress();
        }
        catch (Exception exception) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }
}

