/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.ObjectPriv;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.ObjectPriv.DirectoryCheck;
import oracle.dbtools.util.ObjectPriv.IObjectCheck;
import oracle.dbtools.util.ObjectPriv.IndexCheck;
import oracle.dbtools.util.ObjectPriv.MatViewCheck;
import oracle.dbtools.util.ObjectPriv.MatViewLogCheck;
import oracle.dbtools.util.ObjectPriv.PlSqlCheck;
import oracle.dbtools.util.ObjectPriv.SequenceCheck;
import oracle.dbtools.util.ObjectPriv.SynonymCheck;
import oracle.dbtools.util.ObjectPriv.TableCheck;
import oracle.dbtools.util.ObjectPriv.TriggerCheck;
import oracle.dbtools.util.ObjectPriv.TypeCheck;
import oracle.dbtools.util.ObjectPriv.ViewCheck;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class PermissionRegistry {
    private static HashMap<String, Class> _registry = new HashMap();

    public static synchronized void registerHandler(String string, String string2, Class clazz) {
        if (!IObjectCheck.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IObjectPerms");
        }
        _registry.put(DBObject.getKey(string, string2), clazz);
    }

    public static synchronized void unregisterHandler(String string) {
        _registry.remove(string);
    }

    public static synchronized IObjectCheck getInstanceFor(DBObject dBObject) {
        IObjectCheck iObjectCheck = null;
        Class clazz = _registry.get(dBObject.getKey());
        try {
            if (clazz != null) {
                iObjectCheck = (IObjectCheck)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return iObjectCheck;
    }

    private static boolean checkSysPriv(DBObject dBObject) {
        ConnectionDescriptor connectionDescriptor = Connections.getInstance().getConnectionInfo(dBObject.getConnectionName());
        String string = connectionDescriptor.getProperty("Role");
        return string != null && string.equals("SYSDBA");
    }

    public static boolean canCreate(DBObject dBObject) {
        if (dBObject.isOracle() && PermissionRegistry.checkPrivs(dBObject)) {
            return true;
        }
        IObjectCheck iObjectCheck = PermissionRegistry.getInstanceFor(dBObject);
        return iObjectCheck != null && iObjectCheck.canCreate(dBObject);
    }

    public static boolean canAlter(DBObject dBObject) {
        if (dBObject.isOracle() && PermissionRegistry.checkPrivs(dBObject)) {
            return true;
        }
        IObjectCheck iObjectCheck = PermissionRegistry.getInstanceFor(dBObject);
        return iObjectCheck != null && iObjectCheck.canAlter(dBObject);
    }

    public static boolean canDrop(DBObject dBObject) {
        if (dBObject.isOracle() && PermissionRegistry.checkPrivs(dBObject)) {
            return true;
        }
        IObjectCheck iObjectCheck = PermissionRegistry.getInstanceFor(dBObject);
        return iObjectCheck != null && iObjectCheck.canDrop(dBObject);
    }

    private static boolean checkPrivs(DBObject dBObject) {
        try {
            String string = dBObject.getSchemaName();
            String string2 = dBObject.getConnection().getMetaData().getUserName();
            return string2.equals(string) || PermissionRegistry.checkSysPriv(dBObject);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    static {
        PermissionRegistry.registerHandler("Oracle", "TABLE", TableCheck.class);
        PermissionRegistry.registerHandler("Oracle", "VIEW", ViewCheck.class);
        PermissionRegistry.registerHandler("Oracle", "INDEX", IndexCheck.class);
        PermissionRegistry.registerHandler("Oracle", "SEQUENCE", SequenceCheck.class);
        PermissionRegistry.registerHandler("Oracle", "PACKAGE", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "PACKAGE BODY", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "PROCEDURE", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "FUNCTION", PlSqlCheck.class);
        PermissionRegistry.registerHandler("Oracle", "TRIGGER", TriggerCheck.class);
        PermissionRegistry.registerHandler("Oracle", "TYPE", TypeCheck.class);
        PermissionRegistry.registerHandler("Oracle", "MATERIALIZED VIEW", MatViewCheck.class);
        PermissionRegistry.registerHandler("Oracle", "MATERIALIZED VIEW LOG", MatViewLogCheck.class);
        PermissionRegistry.registerHandler("Oracle", "SYNONYM", SynonymCheck.class);
        PermissionRegistry.registerHandler("Oracle", "DIRECTORY", DirectoryCheck.class);
    }
}

