/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.util.EnvironmentVariables;
import oracle.javatools.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TNSHelper {
    public static final String ENV_OH = "ORACLE_HOME";
    public static final String ENV_TA = "TNS_ADMIN";
    private static final String ITEM_END = ")))";
    private static HashMap<String, Long> lastModified = new HashMap();
    public static final String FILE_TNS = System.getProperty("file.separator") + "network" + System.getProperty("file.separator") + "admin" + System.getProperty("file.separator") + "tnsnames.ora";
    private static ArrayList<TCPTNSEntry> entries = null;
    private static Logger logger = Logger.getLogger("oracle.dbtools.raptor.utils");
    private static boolean decision = true;
    private static boolean remember = false;
    private static FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.equalsIgnoreCase(".tnsnames") || string.toLowerCase().startsWith("tnsnames.");
        }
    };
    private static final String NETWORK_ADMIN_PATH = File.separator + "network" + File.separator + "admin";

    private static boolean checkForTns(String string) {
        logger.info("Checking for tnsnames.* in :" + string);
        boolean bl = false;
        File file = new File(string);
        Object var3_3 = null;
        if (file.exists() && file.listFiles(filter).length > 0) {
            bl = true;
        }
        return bl;
    }

    private static File getTNSFileContent(boolean bl) throws IOException, NotDirtyException {
        boolean bl2;
        logger.finest("getTNSFileContent - START");
        String string = EnvironmentVariables.getVariable((String)ENV_OH);
        String string2 = EnvironmentVariables.getVariable((String)ENV_TA);
        String string3 = System.getProperty("jdbc.driver.home");
        String string4 = System.getProperty("user.home");
        String string5 = null;
        if (TNSHelper.checkForTns(string4)) {
            string5 = string4;
        }
        if (!(bl2 = PlatformUtils.isWindows()) && string5 == null && TNSHelper.checkForTns("/etc")) {
            string5 = "/etc";
        }
        if (string2 != null && string5 == null && TNSHelper.checkForTns(string2)) {
            string5 = string2;
        }
        if (string3 != null && string5 == null && TNSHelper.checkForTns(string3 + NETWORK_ADMIN_PATH)) {
            string5 = string3 + NETWORK_ADMIN_PATH;
        }
        if (string != null && string5 == null && TNSHelper.checkForTns(string + NETWORK_ADMIN_PATH)) {
            string5 = string + NETWORK_ADMIN_PATH;
        }
        if (string5 == null && bl2) {
            string = null;
            try {
                RegistryKey registryKey;
                logger.info("Checking Registry for ORACLE_HOME");
                String string6 = "SOFTWARE\\ORACLE";
                String string7 = null;
                NativeHandler nativeHandler = new NativeHandler();
                nativeHandler.initialize();
                RegistryKey registryKey2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(string6, 131097L);
                Iterator iterator = registryKey2.iterateSubKeys();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    e.toString();
                    try {
                        String string8 = string6 + "\\" + e.toString();
                        registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string8, 131097L);
                        string7 = registryKey.getStringValue("ORACLE_HOME_KEY");
                        logger.info("Checking found key for ORACLE_HOME:" + string7);
                    }
                    catch (RegistryException registryException) {
                        logger.fine("Error:" + registryException.getMessage());
                    }
                }
                if (string7 != null) {
                    registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string7, 131097L);
                    string = registryKey.getStringValue(ENV_OH);
                    logger.info("Checking found ORACLE_HOME:" + string);
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                registryNotAvailableException.printStackTrace();
            }
            catch (RegistryException registryException) {
                System.out.println("Error:" + registryException.getMessage());
            }
            if (string != null) {
                string5 = string + NETWORK_ADMIN_PATH;
            }
        }
        if (string5 == null) {
            return null;
        }
        if (!TNSHelper.isDirty(string5)) {
            throw new NotDirtyException();
        }
        logger.finest("getTNSFileContent - END");
        return new File(string5);
    }

    public static boolean isDirty(String string) {
        boolean bl = false;
        File file = new File(string);
        for (File file2 : file.listFiles(filter)) {
            if (lastModified.get(file2.toString()) != null && lastModified.get(file2.toString()).longValue() == file2.lastModified()) continue;
            bl = true;
        }
        return bl;
    }

    public static void updateTimeStamps(String string) {
        File file = new File(string);
        for (File file2 : file.listFiles(filter)) {
            lastModified.put(file2.toString(), new Long(file2.lastModified()));
        }
    }

    public static TCPTNSEntry getEntry(String string) {
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (TCPTNSEntry tCPTNSEntry : arrayList) {
            if (!tCPTNSEntry.getName().equalsIgnoreCase(string)) continue;
            return tCPTNSEntry;
        }
        return null;
    }

    private static ArrayList<TCPTNSEntry> getTNSEntries(File file) throws IOException {
        logger.finest("getTNSItems - START");
        ArrayList<TCPTNSEntry> arrayList = new ArrayList<TCPTNSEntry>();
        if (file != null && file.exists() && file.isDirectory()) {
            for (File file2 : file.listFiles(filter)) {
                arrayList.addAll(TNSHelper.getTNSEntries(file2));
            }
            TNSHelper.updateTimeStamps(file.toString());
        } else if (file != null && file.exists()) {
            boolean bl = false;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int n = 0;
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            TCPTNSEntry tCPTNSEntry = null;
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(35) == 0) continue;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '(') {
                        ++n;
                        continue;
                    }
                    if (string.charAt(i) != ')') continue;
                    --n;
                }
                stringBuilder.append(string);
                if (n != 0) continue;
                try {
                    string2 = stringBuilder.substring(0, stringBuilder.indexOf("=")).trim();
                    if (string2.indexOf(40) > -1) {
                        String string4 = "1";
                        string4 = "2";
                    }
                    string3 = stringBuilder.substring(stringBuilder.indexOf("=") + 1);
                    if (string2.trim().toLowerCase().equals("ifile")) {
                        try {
                            String string5 = file.getParent() + File.separator;
                            File file3 = new File(string5 + string3);
                            if (!file3.exists()) {
                                file3 = new File(string3);
                            }
                            if (file3.exists()) {
                                arrayList.addAll(TNSHelper.getTNSEntries(file3));
                            } else {
                                logger.severe("ifile not found" + string3);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        stringBuilder.setLength(0);
                        continue;
                    }
                    if (string2.indexOf(40) != -1 || string2.length() <= 0 || string3.trim().length() <= 0) continue;
                    tCPTNSEntry = new TCPTNSEntry(string2, string3);
                    arrayList.add(tCPTNSEntry);
                    stringBuilder.setLength(0);
                    logger.fine("Adding:" + string2);
                }
                catch (Exception exception) {}
            }
            bufferedReader.close();
            TNSHelper.updateTimeStamps(file.getParent());
            logger.finest("getTNSItems - END");
        }
        return arrayList;
    }

    public static ArrayList<TCPTNSEntry> getTNSEntries() {
        Object object;
        logger.finest("getTNSEntries - START");
        PerformanceLogger.get().startTiming(TNSHelper.class.toString() + ".getTNSEntries");
        if (entries == null) {
            entries = new ArrayList();
        }
        ArrayList<TCPTNSEntry> arrayList = entries;
        try {
            object = TNSHelper.getTNSFileContent(false);
            logger.info("Using TNS info from :" + ((File)object).toString());
            if (object != null) {
                arrayList = TNSHelper.getTNSEntries((File)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new Comparator(){

            public int compare(Object object, Object object2) {
                TCPTNSEntry tCPTNSEntry = (TCPTNSEntry)object;
                TCPTNSEntry tCPTNSEntry2 = (TCPTNSEntry)object2;
                return Collator.getInstance().compare(tCPTNSEntry.toString(), tCPTNSEntry2.toString());
            }
        };
        Collections.sort(arrayList, object);
        PerformanceLogger.get().stopTiming(TNSHelper.class.toString() + ".getTNSEntries", "Finished Parsing TNS");
        logger.finest("getTNSEntries - END");
        if (entries != arrayList) {
            entries.addAll(arrayList);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleIdeCore.initIde();
        System.out.println("OH=" + EnvironmentVariables.getVariable((String)ENV_OH));
        System.out.println("TA=" + EnvironmentVariables.getVariable((String)ENV_TA));
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (TCPTNSEntry tCPTNSEntry : arrayList) {
            System.out.println(tCPTNSEntry);
        }
        System.exit(0);
    }

    private static class NotDirtyException
    extends Exception {
        private NotDirtyException() {
        }
    }
}

