/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TCPTNSEntry {
    public static int SPEC_SHORT_FORMAT = 1;
    public static int SPEC_LONG_FORMAT = 2;
    private static int spec_format = 0;
    private static String SPEC_PROTOCOL = "(PROTOCOL=TCP)";
    private static String SPEC_HOST = "(HOST=";
    private static String SPEC_PORT = "(PORT=";
    private static String SPEC_SERVICE_NAME = "(SERVICE_NAME=";
    private static String SPEC_SID = "(SID=";
    private String name = null;
    private String hostname = null;
    private String portno = null;
    private String sid = null;
    private String servicename = null;
    private String desc = null;
    private static final Pattern PORT_PATTERN = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern HOST_PATTERN = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern SID_PATTERN = Pattern.compile("\\(\\s*SID\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern SVCNAME_PATTERN = Pattern.compile("\\(\\s*SERVICE_NAME\\s*=\\s*([^\\s)]+)\\s*\\)");

    public TCPTNSEntry(String string, String string2) {
        spec_format = SPEC_LONG_FORMAT;
        this.name = string;
        this.desc = string2;
        this.parseDescriptor();
    }

    TCPTNSEntry(String string, int n) {
        spec_format = n;
        this.populate(string);
    }

    protected void populate(String string) {
        int n = string.indexOf("=");
        this.name = string.substring(0, n);
        this.desc = string.substring(n + 1);
        this.parseDescriptor();
    }

    private void parseDescriptor() {
        String string = this.desc.toUpperCase();
        Matcher matcher = PORT_PATTERN.matcher(string);
        if (matcher.find()) {
            this.portno = this.desc.substring(matcher.start(1), matcher.end(1));
        }
        if ((matcher = HOST_PATTERN.matcher(string)).find()) {
            this.hostname = this.desc.substring(matcher.start(1), matcher.end(1));
        }
        if ((matcher = SID_PATTERN.matcher(string)).find()) {
            this.sid = this.desc.substring(matcher.start(1), matcher.end(1));
        }
        if ((matcher = SVCNAME_PATTERN.matcher(string)).find()) {
            this.servicename = this.desc.substring(matcher.start(1), matcher.end(1));
        }
    }

    public String getJDBCUrl() {
        String string = null;
        if (spec_format == SPEC_SHORT_FORMAT) {
            if (this.servicename != null) {
                string = "jdbc:oracle:thin:@\\\\" + this.hostname + ":" + this.portno + "\\" + this.servicename;
            } else if (this.sid != null) {
                string = "jdbc:oracle:thin:@" + this.hostname + ":" + this.portno + ":" + this.sid;
            }
        } else if (spec_format == SPEC_LONG_FORMAT) {
            string = "jdbc:oracle:thin:@" + this.desc;
        }
        return string;
    }

    public static void printUrl(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            TCPTNSEntry tCPTNSEntry = new TCPTNSEntry(stringArray[i].replaceAll("\\s", ""), SPEC_LONG_FORMAT);
            System.out.println(tCPTNSEntry.getJDBCUrl());
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"ORCL=(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=localhost)(PORT=1521))(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=orcl)))", "spx2tcp  = (description= (address_list=(address=(protocol=spx)(service=orasrvc1))(address=(protocol=tcp)(port=1580)(host=spcstn)))(connect_data=(sid=cman))(source_route=yes))", "tcp_mv713 =\n  (DESCRIPTION =\n    (ADDRESS=      (PROTOCOL=TCP) (HOST=hostname) (PORT=1521))\n    (CONNECT_DATA= (SID=MV713))\n  )", "mv713 = \n  (DESCRIPTION =\n    (ADDRESS=      (PROTOCOL=IPC) (KEY=700))\n    (CONNECT_DATA= (SID=MV713)) \n  )", "EXTPROC_CONNECTION_DATA=(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=IPC)(KEY=EXTPROC1)))"};
        try {
            TCPTNSEntry.printUrl(stringArray2);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPortno() {
        return this.portno;
    }

    public String getSid() {
        return this.sid;
    }

    public String getServicename() {
        return this.servicename;
    }

    public String toString() {
        return this.name + "=" + this.getJDBCUrl();
    }
}

