/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.util.Version;

public abstract class SearchForObjects
implements IDelayedProgressRunnable {
    private boolean _isCanceled = false;
    private String _filter;
    private String _connName;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private String _types;

    public SearchForObjects(String string, String string2, String string3) {
        this._filter = string3;
        this._connName = string;
    }

    public void cancel() {
        this._isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doWork() {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("OWNER", "SYS");
        hashMap.put("OBJECT_NAME", "DBA_OBJECTS");
        DBUtil dBUtil = DBUtil.getInstance();
        dBUtil.setRaiseError(false);
        String string = dBUtil.executeOracleReturnOneCol(this._connName, "select 1 from sys.dba_objects where rownum = 1", hashMap);
        dBUtil.setRaiseError(true);
        hashMap.clear();
        hashMap.put("OBJECT_NAME", "RECYCLEBIN");
        String string2 = DBUtil.getInstance().executeOracleReturnOneCol(this._connName, "select count(1) from sys.all_objects where object_name = :OBJECT_NAME", hashMap);
        StringBuilder stringBuilder = new StringBuilder(" select object_name,owner,object_type from ");
        StringBuilder stringBuilder2 = new StringBuilder("select db_link object_name ,owner,'DATABASE LINK' object_type from ");
        if (string == null || string.equals("0")) {
            stringBuilder.append(" sys.all_objects");
            stringBuilder2.append(" sys.all_db_links");
        } else {
            stringBuilder.append(" sys.dba_objects");
            stringBuilder2.append(" sys.dba_db_links");
        }
        hashMap.clear();
        try {
            if (DBUtil.checkVersion(this._connName, null, new Version("10.0")) && this._filter.startsWith("/") && (this._filter.endsWith("/") || this._filter.substring(this._filter.length() - 2, 1).startsWith("/"))) {
                object = null;
                if (this._filter.endsWith("i")) {
                    stringBuilder.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME,'i') ");
                    stringBuilder2.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME,'i') ");
                    object = this._filter.substring(1, this._filter.length() - 2);
                } else {
                    stringBuilder.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME) ");
                    stringBuilder2.append(" where REGEXP_LIKE(owner || '.'|| object_name,:NAME) ");
                    object = this._filter.substring(1, this._filter.length() - 1);
                }
                hashMap.put("NAME", object);
                this.logger.info("Using regex:" + (String)object);
            } else {
                if (this._filter.indexOf(".") > 0) {
                    stringBuilder.append(" where owner like :OWNER");
                    stringBuilder2.append(" where owner like :OWNER");
                    stringBuilder.append(" and object_name like :NAME");
                    stringBuilder2.append(" and db_link like :NAME");
                    object = this._filter.split("\\.");
                    hashMap.put("OWNER", this.scrubBind(object[0]));
                    if (((String[])object).length == 2) {
                        hashMap.put("NAME", this.scrubBind(object[1]));
                    } else {
                        hashMap.put("NAME", "%");
                    }
                } else {
                    stringBuilder.append(" where object_name like :NAME");
                    stringBuilder2.append(" where db_link like :NAME");
                    hashMap.put("NAME", this.scrubBind(this._filter) + "%");
                }
                if (DBConfig.getInstance().getBoolean("SEARCH_AUTO_WILDCARD").booleanValue()) {
                    hashMap.put("NAME", (String)hashMap.get("NAME") + "%");
                }
            }
            if (this._types != null) {
                object = this._types.split(":");
                stringBuilder.append(" and object_type in (");
                stringBuilder2.append(" and 'DATABASE LINK' in (");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    hashMap.put("TYPE" + i, ((String)object[i]).replace("_", " "));
                    stringBuilder.append(":TYPE" + i);
                    stringBuilder2.append(":TYPE" + i);
                    if (i == ((Object)object).length - 1) continue;
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                stringBuilder.append(") ");
                stringBuilder2.append(") ");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("Format number failed:" + numberFormatException.getMessage());
        }
        object = new StringBuilder("select * from ( ");
        ((StringBuilder)object).append(stringBuilder.toString());
        ((StringBuilder)object).append(" union ");
        ((StringBuilder)object).append(stringBuilder2.toString());
        ((StringBuilder)object).append(" ) ");
        if (string2.equals("1")) {
            ((StringBuilder)object).append(" where (object_name,object_type) not in (select object_name,type from recyclebin) ");
        }
        ((StringBuilder)object).append(" order by owner,object_name");
        Connections.getInstance().lock(this._connName);
        ResultSet resultSet = DBUtil.getInstance().executeQuery(this._connName, ((StringBuilder)object).toString(), hashMap);
        try {
            while (resultSet.next() && !this._isCanceled) {
                URL uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this._connName, null, resultSet.getString("OWNER"), resultSet.getString("OBJECT_TYPE")), resultSet.getString("OBJECT_NAME"));
                if (uRL == null) continue;
                arrayList.add(uRL);
                if (resultSet.getRow() % 10 != 0) continue;
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            Connections.getInstance().unlock(this._connName);
        }
        return arrayList;
    }

    private String scrubBind(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"' && string.charAt(string.length()) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public void setFilter(String string) {
        this._filter = string;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setTypes(String string) {
        this._types = string;
    }

    public String getTypes() {
        return this._types;
    }
}

