/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Window;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.ExceptionDialogRunnable;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ConnectionCanceledException;

public class ExceptionHandler {
    private static Exception hitException = null;

    public static Exception wasException() {
        return hitException;
    }

    public static void reset() {
        hitException = null;
    }

    public static void handleException(final Exception exception) {
        hitException = exception;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (exception instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), exception.getMessage(), (SQLException)exception);
                } else {
                    if (exception instanceof ConnectionCanceledException) {
                        return;
                    }
                    if (exception instanceof AbstractConnectionNode.ExceptionWrapper) {
                        ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable("Could not connect: {0}", exception.getCause());
                        if (SwingUtilities.isEventDispatchThread()) {
                            exceptionDialogRunnable.run();
                        } else {
                            try {
                                SwingUtilities.invokeAndWait(exceptionDialogRunnable);
                            }
                            catch (Exception exception2) {}
                        }
                    } else {
                        ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)exception);
                    }
                }
            }
        });
    }

    public static void handleException(Exception exception, String string, int n) {
        hitException = exception;
        if (exception instanceof SQLException) {
            SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), exception.getMessage(), (SQLException)exception, string, n);
        } else {
            ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)exception);
        }
    }

    public static void handleException(Exception exception, String string, int n, int n2, int n3) {
        hitException = exception;
        if (exception instanceof SQLException) {
            SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), exception.getMessage(), (SQLException)exception, string, n, n2, n3);
        } else {
            ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)exception);
        }
    }
}

