/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.ModelUtil;
import oracle.jdbc.OracleTypes;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class DataTypesUtil {
    static Map<Integer, String> dataTypesMap;

    public static boolean isEqual(Object object, Object object2, Connection connection, int n) {
        String string;
        if (DataTypesUtil.isExtendedType(object, n)) {
            return ModelUtil.areEqual((Object)object, (Object)object2);
        }
        if (object != null && object2 != null && (string = DataTypesUtil.stringValue(object, connection)) != null) {
            return string.equals(object2);
        }
        return false;
    }

    public static String stringValue(Object object, Connection connection) {
        if (object == null) {
            return null;
        }
        String string = null;
        Object object2 = null;
        if (object instanceof Clob) {
            try {
                object2 = object;
                string = Translate.translate("(CLOB) ") + ((Clob)object).getSubString(1L, 10);
                if ((int)((Clob)object).length() > 10) {
                    string = string + "...";
                }
            }
            catch (SQLException sQLException) {}
        } else if (object instanceof Blob) {
            object2 = object;
            string = Translate.translate("(BLOB)");
        } else if (object instanceof RAW) {
            object2 = object;
            string = Translate.translate("(RAW)");
        } else if (object instanceof BFILE) {
            object2 = object;
            string = Translate.translate("(BFILE)");
        } else if (object instanceof TIMESTAMPTZ) {
            string = (String)NLSUtils.getValue(connection, (TIMESTAMPTZ)object);
        } else if (object instanceof TIMESTAMPLTZ) {
            string = (String)NLSUtils.getValue(connection, (TIMESTAMPLTZ)object);
        } else if (object instanceof TIMESTAMP) {
            string = (String)NLSUtils.getValue(connection, (TIMESTAMP)object);
        } else if (object instanceof DATE) {
            string = (String)NLSUtils.getValue(connection, (DATE)object);
        } else if (object instanceof Date) {
            try {
                string = NLSUtils.formatDate(connection, new DATE((Date)object));
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof NUMBER) {
            string = (String)NLSUtils.getValue(connection, (NUMBER)object);
        } else if (object instanceof BigDecimal) {
            string = (String)NLSUtils.getValue(connection, (BigDecimal)object);
        } else if (object instanceof OPAQUE) {
            try {
                string = ((OPAQUE)object).getSQLTypeName().trim();
                if (string.equals("SYS.XMLTYPE")) {
                    string = XMLType.createXML((OPAQUE)((OPAQUE)object)).getStringVal();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof STRUCT) {
            try {
                string = ((STRUCT)object).getSQLTypeName().trim();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof ARRAY) {
            try {
                string = ((ARRAY)object).getBaseTypeName() + "(";
                Datum[] datumArray = ((ARRAY)object).getOracleArray();
                boolean bl = true;
                for (Datum datum : datumArray) {
                    string = string + (bl ? "" : ",") + DataTypesUtil.stringValue(datum, connection);
                    bl = false;
                }
                string = string + ")";
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof ResultSet) {
            ResultSetFormatter resultSetFormatter = new ResultSetFormatter();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                resultSetFormatter.rset2sqlplus((ResultSet)object, connection, stringBuffer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            string = stringBuffer.toString();
        } else if (object instanceof List) {
            string = "{";
            List list = (List)object;
            int n = 0;
            List list2 = (List)list.get(0);
            for (Object e : list) {
                if (n > 0) {
                    string = string + "<";
                    int n2 = 0;
                    for (Object e2 : (List)e) {
                        string = string + list2.get(n2) + "=" + DataTypesUtil.stringValue(e2, connection) + ",";
                        ++n2;
                    }
                    string = string.substring(0, string.length() - 1);
                    string = string + ">,";
                }
                ++n;
            }
            string = string + "}";
        } else if (object instanceof Datum && !(object instanceof INTERVALDS)) {
            try {
                string = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else {
            string = object.toString();
        }
        return string;
    }

    public static boolean isExtendedType(Object object, int n) {
        return object instanceof ExtendedType || object instanceof BFILE || n == -13 || object instanceof Blob || n == 2004;
    }

    public static String getEmptyExtendedType(Object object, int n) {
        if (object instanceof Blob || n == 2004) {
            return "empty_blob()";
        }
        if (object instanceof BFILE || n == -13) {
            return "bfilename(' ',' ')";
        }
        return "NULL";
    }

    public static String getJdbcTypeName(int n) {
        if (dataTypesMap == null) {
            dataTypesMap = new HashMap<Integer, String>();
            Field[] fieldArray = OracleTypes.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    String string = fieldArray[i].getName();
                    Integer n2 = (Integer)fieldArray[i].get(null);
                    dataTypesMap.put(n2, string);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return dataTypesMap.get(new Integer(n));
    }

    public static void main(String[] stringArray) {
    }

    public static boolean canDuplicate(Object object, int n) {
        return !(object instanceof STRUCT) && n != 2002 && !(object instanceof RAW) && n != -4 && n != -2 && n != -3 && !(object instanceof Blob) && n != 2004;
    }

    public static CLOB getCLOB(String string, Connection connection) throws SQLException {
        CLOB cLOB = null;
        try {
            cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            cLOB.open(1);
            Writer writer = cLOB.getCharacterOutputStream();
            writer.write(string);
            writer.flush();
            writer.close();
            cLOB.close();
        }
        catch (SQLException sQLException) {
            cLOB.freeTemporary();
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            cLOB.freeTemporary();
            exception.printStackTrace();
        }
        return cLOB;
    }

    public static Object getDuplicate(Object object, Connection connection, int n) throws SQLException {
        if (DataTypesUtil.canDuplicate(object, n)) {
            if (object instanceof Clob || n == 2005) {
                return ((Clob)object).getSubString(1L, (int)((Clob)object).length());
            }
            return DataTypesUtil.stringValue(object, connection);
        }
        return null;
    }
}

