/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.SchemaObject;
import oracle.jdeveloper.cm.CMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObject {
    public static final String DBOBJECT_KEY = "DB_OBJECT";
    public static final String OBJECT_NAME_KEY = "OBJECT_NAME";
    public static final String OBJECT_TYPE_KEY = "OBJECT_TYPE";
    public static final String OBJECT_FOLDER_TYPE_KEY = "OBJECT_FOLDER_TYPE";
    public static final String OBJECT_OWNER_KEY = "OBJECT_OWNER";
    public static final String COLUMN_NAME_KEY = "COLUMN_NAME";
    public static final String OBJECT_ID_KEY = "OBJECT_ID";
    public static final String CHILD_NAME_KEY = "CHILD_NAME";
    public static final String CONN_TYPE_KEY = "CONN_TYPE";
    protected Element _node;
    protected String _objectName;
    protected String _schemaName;
    protected String _objectId;
    protected String _objectType;
    protected String _objectFolderType;
    protected String _childName;
    protected SchemaObject _schemaObject;
    protected Connection m_conn;
    protected String _connName;
    private HashMap<String, Object> _dict;
    private String _connType;
    private String _catalog;
    private boolean _isValid;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private URL _url;

    public DBObject(URL uRL) throws DBException {
        this._url = uRL;
        this._connName = DBURLFormatHelper.getConnectionName(uRL);
        this._objectName = DBURLFormatHelper.getName(uRL);
        this._objectFolderType = this._objectType = DBURLFormatHelper.getBaseType(uRL);
        this._schemaName = DBURLFormatHelper.getSchema(uRL);
        this._catalog = DBURLFormatHelper.getCatalog(uRL);
    }

    public DBObject(Element element) {
        this._node = element instanceof IViewerNode ? ((IViewerNode)element).getBaseNode() : element;
        this.loadDBData();
    }

    public HashMap<String, Object> getDictionary() {
        if (this._dict == null) {
            Object object;
            this._dict = new HashMap();
            if (this._node instanceof DatabaseNode) {
                object = ((DatabaseNode)this._node).getNodeInstance();
                for (String string : object.getPropertyKeys()) {
                    this._dict.put(string, object.getProperty(string));
                }
            }
            if ((object = ObjectFactory.getFactory(this.getConnectionName(), this.getConnection())) != null) {
                this._dict.putAll(((ObjectFactory)object).getGlobalBindMap());
            }
            if (this._node instanceof CustomNode && ((CustomNode)this._node).getDict() != null) {
                this._dict.putAll(((CustomNode)this._node).getDict());
            }
            this._dict.put(OBJECT_NAME_KEY, this.getObjectName());
            this._dict.put(OBJECT_TYPE_KEY, this.getObjectType());
            this._dict.put(OBJECT_OWNER_KEY, this.getSchemaName());
            this._dict.put(COLUMN_NAME_KEY, this.getChildName());
            this._dict.put(OBJECT_ID_KEY, this.getObjectId());
            this._dict.put(CHILD_NAME_KEY, this.getChildName());
            this._dict.put(OBJECT_FOLDER_TYPE_KEY, this._objectFolderType);
        }
        return this._dict;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void loadDBData() {
        this._isValid = true;
        if (this._node instanceof DatabaseNode) {
            this.processObjectNode((DatabaseNode)this._node);
        } else if (this._node instanceof ObjectFolder) {
            this.processObjectFolder((ObjectFolder)this._node);
        } else if (this._node instanceof OtherSchemasFolder) {
            this.processOtherSchemasFolder((OtherSchemasFolder)this._node);
        } else if (this._node instanceof DatabaseConnection) {
            this.processConnectionNode((DatabaseConnection)this._node);
        } else if (this._node instanceof SchemaFolder) {
            this.processSchemaFolder((SchemaFolder)this._node);
        } else if (this._node instanceof ObjectNode) {
            this.processObjectNode((ObjectNode)this._node);
        } else if (this._node instanceof CustomNode) {
            this.processCustomNode((CustomNode)this._node);
        } else if (this._node instanceof ChildObjectElement) {
            this.processChild((ChildObjectElement)this._node);
        } else if (this._node instanceof CatalogFolder) {
            this.processCatalogFolder((CatalogFolder)this._node);
        } else {
            this._isValid = false;
        }
        if (this._node instanceof DatabaseElement) {
            DatabaseElement databaseElement = (DatabaseElement)this._node;
            if (this._connType == null) {
                this._connType = (String)databaseElement.getProperty("ConnectionType");
            }
            String string = this._objectId = databaseElement.getProperty(OBJECT_ID_KEY) != null ? databaseElement.getProperty(OBJECT_ID_KEY).toString() : null;
        }
        if (this._objectType != null && this._objectType.equals("PUBLIC_SYNONYM")) {
            this._schemaName = "PUBLIC";
        }
        if (this._node instanceof Locatable) {
            this._url = ((Locatable)this._node).getURL();
        }
    }

    private void processCatalogFolder(CatalogFolder catalogFolder) {
        this._objectFolderType = this._objectType = "CATALOG";
        this._url = catalogFolder.getURL();
        this._connName = DBURLFormatHelper.getConnectionName(this._url);
        this._connType = catalogFolder.getCatalogInstance().getObjectFactory().getConnectionType();
        this._objectName = DBURLFormatHelper.getCatalog(this._url);
        this._catalog = DBURLFormatHelper.getCatalog(this._url);
    }

    private void processChild(ChildObjectElement childObjectElement) {
        this._objectName = (String)childObjectElement.getProperty(OBJECT_NAME_KEY);
        this._schemaName = (String)childObjectElement.getProperty("SCHEMA");
        this._objectFolderType = this._objectType = (String)childObjectElement.getProperty("TYPE");
        this._connName = DBURLFormatHelper.getConnectionName(childObjectElement.getURL());
        this._connType = (String)childObjectElement.getProperty("ConnectionType");
        this._catalog = (String)childObjectElement.getProperty("CATALOG");
        this._childName = (String)childObjectElement.getProperty("NAME");
    }

    private void processCustomNode(CustomNode customNode) {
        this._objectFolderType = this._objectType = customNode.getObjectType();
        this._connType = customNode.getConnType();
        this._connName = customNode.getConnectionName();
        this._objectName = customNode.getObjectName();
    }

    private void processConnectionNode(DatabaseConnection databaseConnection) {
        this._objectFolderType = this._objectType = "CONNECTION";
        this._objectName = databaseConnection.getConnectionName();
        this._connName = databaseConnection.getConnectionName();
        try {
            if (databaseConnection.isOpen()) {
                DatabaseMetaData databaseMetaData = databaseConnection.getConnection().getMetaData();
                this._connType = databaseMetaData.getDatabaseProductName();
                this._schemaName = databaseMetaData.getUserName();
            }
        }
        catch (SQLException sQLException) {
            this.logger.severe("Could not connect to database:" + sQLException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.severe("Could not read node:" + iOException.getMessage());
        }
    }

    private void processOtherSchemasFolder(OtherSchemasFolder otherSchemasFolder) {
        this._objectFolderType = this._objectType = "USER_FOLDER";
        this._connName = otherSchemasFolder.getConnectionName();
    }

    private void processSchemaFolder(SchemaFolder schemaFolder) {
        this._objectFolderType = this._objectType = "USER";
        this._connName = (String)schemaFolder.getProperty("ConnectionName");
        this._schemaName = (String)schemaFolder.getProperty("SCHEMA");
    }

    private void processObjectFolder(ObjectFolder objectFolder) {
        this._objectType = objectFolder.getObjectType() + "_FOLDER";
        this._objectFolderType = objectFolder.getObjectType();
        this._connName = (String)objectFolder.getProperty("ConnectionName");
        this._schemaName = (String)objectFolder.getProperty("SCHEMA");
    }

    private static Connection getConnection(String string) {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
        }
        catch (CMException cMException) {
            ExceptionHandler.handleException((Exception)((Object)cMException));
        }
        return connection;
    }

    private void processObjectNode(DatabaseNode databaseNode) {
        DBObjectInstance dBObjectInstance = databaseNode.getNodeInstance();
        this._objectName = (String)databaseNode.getProperty("NAME");
        this._schemaName = (String)databaseNode.getProperty("SCHEMA");
        this._objectFolderType = this._objectType = (String)databaseNode.getProperty("TYPE");
        this._connName = (String)databaseNode.getProperty("ConnectionName");
        this._connType = (String)databaseNode.getProperty("ConnectionType");
        this._catalog = (String)databaseNode.getProperty("CATALOG");
        if (this._objectType != null) {
            if (this._objectType.equalsIgnoreCase("materialized view log")) {
                this._childName = (String)databaseNode.getProperty("MASTER");
            }
        } else {
            this._isValid = false;
        }
    }

    public URL getURL() {
        return this._url;
    }

    public Node getNode() {
        if (this._node == null && this._url != null) {
            this._node = DatabaseNavigatorElementFactory.getObjectNode(this._url);
        }
        return (Node)(this._node instanceof Element ? this._node : (Node)null);
    }

    public Element getElement() {
        return this._node;
    }

    public void setNode(Node node) {
        this._node = node;
        this.loadDBData();
    }

    public String getObjectName() {
        return this._objectName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getObjectId() {
        DBObjectID dBObjectID;
        SchemaObject schemaObject;
        if (this._objectId == null && (schemaObject = this.getSchemaObject()) != null && (dBObjectID = schemaObject.getID()) != null && dBObjectID instanceof IdentifierBasedID) {
            this._objectId = ((IdentifierBasedID)dBObjectID).getIdentifier().toString();
        }
        return this._objectId;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public String getObjectFolderType() {
        return this._objectFolderType;
    }

    public String getChildName() {
        return this._childName;
    }

    public SchemaObject getSchemaObject() {
        if (this._schemaObject == null) {
            try {
                Database database = this.getDatabase();
                if (database != null) {
                    this._schemaObject = database.getObject(this._objectType, database.getSchema(this._schemaName), this._objectName);
                }
            }
            catch (DBException dBException) {
                this.logger.severe("Could not get schema Object:" + dBException.getMessage());
            }
        }
        return this._schemaObject;
    }

    public Database getDatabase() {
        return Connections.getInstance().getDatabase(this._connName, this.getConnection());
    }

    public Connection getConnection() {
        if (this.m_conn == null) {
            this.m_conn = DBObject.getConnection(this._connName);
        }
        return this.m_conn;
    }

    public String getConnectionName() {
        return this._connName;
    }

    private boolean isOracleImpl() {
        return Connections.getInstance().isOracle(this.getConnectionName());
    }

    public String getConnectionType() {
        return this._connType == null && this.isOracleImpl() ? "Oracle" : this._connType;
    }

    public String getCatalog() {
        return null;
    }

    public boolean isOracle() {
        return this._connType != null ? "Oracle".equals(this._connType) : this.isOracleImpl();
    }

    public boolean isTimesTen() {
        return Connections.getInstance().isTimesTen(this.getConnectionName());
    }

    public String getKey() {
        return DBObject.getKey(this.getConnectionType(), this.getObjectType());
    }

    public static String getKey(String string, String string2) {
        return string + "#" + string2;
    }

    public String getDBVersion() {
        try {
            return Connections.getInstance().getConnection(this.getConnectionName()).getMetaData().getDatabaseProductVersion();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean checkVals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string.equals(string2);
    }

    public boolean checkQualifiedNameEquals(DBObject dBObject) {
        if (dBObject == null) {
            return false;
        }
        return DBObject.checkVals(dBObject.getObjectName(), this.getObjectName()) && DBObject.checkVals(dBObject.getConnectionName(), this.getConnectionName()) && DBObject.checkVals(dBObject.getSchemaName(), this.getSchemaName());
    }
}

