/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionCanceledException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.JdbcConnectionWrapper;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connections {
    private static Logger logger = Logger.getLogger(Connections.class.getName());
    private static Connections s_connections;
    private static final Object LOCK;
    public static final String DBNAME_KEY = "Connections.db_name";
    private Map<Connection, ReentrantLock> m_locks = new HashMap<Connection, ReentrantLock>();
    private Map<String, ConnectionInfo> m_conns = new HashMap<String, ConnectionInfo>();
    private Map<Connection, Database> m_dbs = new HashMap<Connection, Database>();
    private Map<Connection, Object> m_dbDescMap = new HashMap<Connection, Object>();
    private ConnectInfoPrompter m_prompt;
    private CopyOnWriteList m_listeners;
    private ConnectionManager m_cm;
    private ConnectionsProvider m_cp;
    private FactoryListener m_fl = new FactoryListener();
    private static final Pattern SERVICE_FORMAT;
    private static final Pattern SID_FORMAT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connections getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (s_connections == null) {
                s_connections = new Connections();
            }
        }
        return s_connections;
    }

    private Connections() {
        this.setCm(ConnectionManager.getInstance());
        this.init();
    }

    private void init() {
        try {
            String[] stringArray = this.m_cm.getConnectionNamesForClass("CLASS_DATABASE");
            if (stringArray != null) {
                for (String string : stringArray) {
                    ConnectionDescriptor connectionDescriptor = this.m_cm.getConnectionDescriptor(string);
                    if (connectionDescriptor == null) continue;
                    ConnectionInfo connectionInfo = new ConnectionInfo(string, connectionDescriptor);
                    this.m_conns.put(string, connectionInfo);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_cm.addConnectionListener((oracle.jdeveloper.cm.ConnectionListener)new L());
    }

    public ReentrantLock getLock(Connection connection) {
        if (this.m_locks.get(connection) == null) {
            this.m_locks.put(connection, new ReentrantLock());
        }
        return this.m_locks.get(connection);
    }

    public ReentrantLock getLock(String string) {
        try {
            return this.getLock(s_connections.getConnection(string));
        }
        catch (CMException cMException) {
            logger.severe("Could not get connection");
            return null;
        }
    }

    public void unlock(String string) {
        if (this.getLock(string).isHeldByCurrentThread()) {
            this.getLock(string).unlock();
        } else {
            logger.info("Trying to unlock another thread's lock");
        }
    }

    public void unlock(Connection connection) {
        if (this.getLock(connection).isHeldByCurrentThread()) {
            this.getLock(connection).unlock();
        } else {
            logger.info("Trying to unlock another thread's lock");
        }
    }

    public boolean lock(String string) {
        try {
            return this.lock(s_connections.getConnection(string));
        }
        catch (CMException cMException) {
            logger.severe("Could not get connection");
            return false;
        }
    }

    public boolean lock(Connection connection) {
        boolean bl = false;
        ReentrantLock reentrantLock = Connections.getInstance().getLock(connection);
        do {
            try {
                if (!reentrantLock.tryLock(500L, TimeUnit.MILLISECONDS)) continue;
                bl = true;
                break;
            }
            catch (InterruptedException interruptedException) {
                logger.fine("Interrupted while trying to get a lock");
            }
        } while (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)"Connection currrently busy.  Try again?", (String)"Connection busy", null, (boolean)false, (String)"Try Again", (String)"Abort"));
        return bl;
    }

    public void setPrompter(ConnectInfoPrompter connectInfoPrompter) {
        this.m_prompt = connectInfoPrompter;
    }

    public void closeConnection(String string) {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        if (connectionInfo != null) {
            try {
                Connection connection = connectionInfo.getConnection(false);
                if (connection != null) {
                    this.m_dbs.remove(connection);
                    Object object = this.m_dbDescMap.remove(connection);
                    if (object != null) {
                        DatabaseFactory.uncacheProvider((Object)object);
                    }
                }
            }
            catch (CMException cMException) {
                // empty catch block
            }
            connectionInfo.closeConnection();
        }
    }

    private void removeConnection(String string) {
        ConnectionInfo connectionInfo = this.m_conns.get(string);
        if (connectionInfo != null) {
            connectionInfo.closeConnection();
        }
        this.m_conns.remove(string);
    }

    private ConnectionInfo findConnectionInfo(String string) {
        ConnectionInfo connectionInfo = this.m_conns.get(string);
        return connectionInfo;
    }

    public Database getDatabase(String string, Connection connection) {
        Database database = null;
        try {
            database = connection == null ? this.getDatabase(string) : this.getDatabaseImpl(string, connection);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return database;
    }

    public Database getDatabase(Connection connection) {
        return this.getDatabase(null, connection);
    }

    private Database getDatabaseImpl(String string, Connection connection) throws DBException {
        Database database = this.m_dbs.get(connection);
        if (database == null) {
            this.m_fl.setCurrConn(connection);
            database = DatabaseFactory.findOrCreateDatabase((String)string, (Connection)connection);
            this.m_dbs.put(connection, database);
        }
        return database;
    }

    public Database getDatabase(String string) throws DBException {
        return this.getDatabase(string, true);
    }

    public Database getDatabase(String string, boolean bl) throws DBException {
        Database database = null;
        try {
            Connection connection = this.getConnection(string, bl);
            if (connection != null) {
                database = this.getDatabaseImpl(string, connection);
            }
        }
        catch (CMException cMException) {
            Throwable throwable = cMException.isWrapper() ? cMException.unwrap() : cMException;
            throw new DBException(throwable);
        }
        return database;
    }

    public Connection getConnection(String string) throws CMException {
        return this.getConnection(string, true);
    }

    private Connection getConnection(String string, boolean bl) throws CMException {
        Connection connection = null;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        connection = connectionInfo != null ? connectionInfo.getConnection(bl) : null;
        return connection;
    }

    public Connection getUniqueConnection(String string) throws CMException {
        Connection connection = null;
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        connection = connectionInfo != null ? connectionInfo.getUniqueConnection() : null;
        return connection;
    }

    public Connection cloneConnection(Connection connection) throws CMException {
        Connection connection2 = null;
        String string = this.getConnectioName(connection);
        if (string != null) {
            connection2 = this.getUniqueConnection(string);
        }
        return connection2;
    }

    public boolean isOracle(Connection connection) {
        return connection instanceof OracleConnection;
    }

    public boolean isTimesTen(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            if (string.indexOf("TimesTen") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isOracle(String string) {
        ConnectionDescriptor connectionDescriptor;
        boolean bl = false;
        if (string != null && (connectionDescriptor = this.getConnectionInfo(string)) != null) {
            bl = ModelUtil.areEqual((Object)connectionDescriptor.getJdbcDriver(), (Object)"oracle.jdbc.driver.OracleDriver");
        }
        return bl;
    }

    public boolean isTimesTen(String string) {
        ConnectionDescriptor connectionDescriptor;
        boolean bl = false;
        if (string != null && (connectionDescriptor = this.getConnectionInfo(string)) != null) {
            bl = ModelUtil.areEqual((Object)connectionDescriptor.getJdbcDriver(), (Object)"com.timesten.jdbc.TimesTenDriver") || ModelUtil.areEqual((Object)connectionDescriptor.getJdbcDriver(), (Object)"com.timesten.jdbc.TimesTenClientDriver");
        }
        return bl;
    }

    public boolean isConnectionOpen(String string) {
        boolean bl = false;
        try {
            ConnectionInfo connectionInfo = this.findConnectionInfo(string);
            bl = connectionInfo != null && connectionInfo.getConnection(false) != null;
        }
        catch (CMException cMException) {
            // empty catch block
        }
        return bl;
    }

    public ConnectionDescriptor getConnectionInfo(String string) {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string);
        return connectionInfo != null ? (connectionInfo.m_authDesc != null ? connectionInfo.m_authDesc : connectionInfo.m_origDesc) : null;
    }

    public String getConnectioName(Connection connection) {
        String string = null;
        if (connection != null) {
            for (ConnectionInfo connectionInfo : this.m_conns.values()) {
                try {
                    if (connectionInfo.getConnection(false) != connection) continue;
                    string = connectionInfo.m_name;
                    break;
                }
                catch (CMException cMException) {
                }
            }
        }
        return string;
    }

    public DatabaseConnectionNode getDBConnectionNode(String string) {
        return (DatabaseConnectionNode)ConnectionsProvider.getInstance().getConnectionNode(string);
    }

    public String[] getConnNames() {
        return this.m_conns.keySet().toArray(new String[0]);
    }

    public ConnectionManager getCm() {
        return this.m_cm;
    }

    private void setCm(ConnectionManager connectionManager) {
        this.m_cm = connectionManager;
    }

    public static String getConnName(URL uRL) {
        String string = "";
        if (uRL.getPath().indexOf("/") > 0) {
            string = uRL.getPath().substring(uRL.getPath().indexOf("/") + 1);
        }
        return string;
    }

    public Connection getTestConnection(String string) throws Exception {
        File file;
        DriverManager.registerDriver((Driver)new OracleDriver());
        String string2 = System.getProperty("sdev.testConnectionFile");
        if (string2 == null && Connections.class.getResource("testConnections.xml") != null) {
            string2 = Connections.class.getResource("testConnections.xml").getFile();
        }
        if (string2 == null) {
            file = new File(System.getProperty("user.home") + File.separator + "testConnections.xml");
            string2 = file.getAbsolutePath();
        }
        System.out.println("Using:" + string2);
        file = new DefaultConnectionStore(string2, true);
        this.m_cm.setConnectionStore((ConnectionStore)file);
        JdbcConnectionWrapper jdbcConnectionWrapper = (JdbcConnectionWrapper)Connections.getInstance().getCm().getConnection(string);
        String string3 = CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)jdbcConnectionWrapper.getDescriptor());
        Connection connection = DriverManager.getConnection(string3, jdbcConnectionWrapper.getDescriptor().getUsername(), jdbcConnectionWrapper.getDescriptor().getPassword());
        System.out.println("Returning:" + string);
        return connection;
    }

    public ArrayList<String> getTestConnectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("10.2");
        arrayList.add("9.2");
        arrayList.add("8");
        return arrayList;
    }

    public String resovleTNS2JDBCURL(String string) {
        String string2 = string;
        string2 = TNSHelper.getEntry(string).getJDBCUrl();
        return string2;
    }

    public void populateConnectionInfo(ConnectionDescriptor connectionDescriptor) {
        String string = connectionDescriptor.getURL();
        if (ModelUtil.hasLength((String)string)) {
            if (!string.startsWith("jdbc")) {
                TCPTNSEntry tCPTNSEntry = TNSHelper.getEntry(string);
                if (tCPTNSEntry == null) {
                    return;
                }
                connectionDescriptor.setProperty("URL", tCPTNSEntry.getJDBCUrl());
                connectionDescriptor.setProperty("HOSTNAME", tCPTNSEntry.getHostname());
                connectionDescriptor.setProperty("JDBC_PORT", tCPTNSEntry.getPortno());
                connectionDescriptor.setProperty("SID", tCPTNSEntry.getSid());
                connectionDescriptor.setProperty("ServiceName", tCPTNSEntry.getServicename());
            } else {
                int n;
                String string2 = connectionDescriptor.getHostname();
                String string3 = connectionDescriptor.getSid();
                String string4 = connectionDescriptor.getProperty("ServiceName");
                if ((!ModelUtil.hasLength((String)string2) || !ModelUtil.hasLength((String)string3) && !ModelUtil.hasLength((String)string4)) && string.startsWith("jdbc:oracle:") && (n = string.indexOf("@")) != -1) {
                    String string5 = string.substring(n + 1);
                    Matcher matcher = SERVICE_FORMAT.matcher(string5);
                    if (matcher.matches()) {
                        connectionDescriptor.setProperty("HOSTNAME", matcher.group(1));
                        connectionDescriptor.setProperty("JDBC_PORT", matcher.group(2));
                        connectionDescriptor.setProperty("ServiceName", matcher.group(3));
                    } else {
                        matcher = SID_FORMAT.matcher(string5);
                        if (matcher.matches()) {
                            connectionDescriptor.setProperty("HOSTNAME", matcher.group(1));
                            connectionDescriptor.setProperty("JDBC_PORT", matcher.group(2));
                            connectionDescriptor.setProperty("SID", matcher.group(3));
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "select product,version from PRODUCT_COMPONENT_VERSION";
        Connection connection = Connections.getInstance().getTestConnection("8");
        ResultSet resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
        connection = Connections.getInstance().getTestConnection("9.2");
        resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
        connection = Connections.getInstance().getTestConnection("10.2");
        resultSet = connection.prepareStatement(string).executeQuery();
        while (resultSet.next()) {
            System.out.println(resultSet.getString(1) + ":" + resultSet.getString(2));
        }
        resultSet.close();
        connection.close();
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new CopyOnWriteList(ConnectionListener.class);
        }
        this.m_listeners.add((Object)connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove((Object)connectionListener);
            if (this.m_listeners.size() == 0) {
                this.m_listeners = null;
            }
        }
    }

    private void fireConnectionEvent(final oracle.dbtools.raptor.connections.ConnectionEvent connectionEvent, boolean bl) {
        if (this.m_listeners != null) {
            connectionEvent.setSelectorOpened(ConnectionSelectorUI.SELECTOR_ACTIVE);
            Runnable runnable = new Runnable(){

                public void run() {
                    ConnectionListener[] connectionListenerArray = (ConnectionListener[])Connections.this.m_listeners.getItems();
                    switch (connectionEvent.getID()) {
                        case 2: {
                            for (ConnectionListener connectionListener : connectionListenerArray) {
                                connectionListener.connectionAdded(connectionEvent);
                            }
                            break;
                        }
                        case 3: {
                            for (ConnectionListener connectionListener : connectionListenerArray) {
                                connectionListener.connectionRemoved(connectionEvent);
                            }
                            break;
                        }
                        case 4: {
                            for (ConnectionListener connectionListener : connectionListenerArray) {
                                connectionListener.connectionRenamed(connectionEvent);
                            }
                            break;
                        }
                        case 5: {
                            for (ConnectionListener connectionListener : connectionListenerArray) {
                                connectionListener.connectionModified(connectionEvent);
                            }
                            break;
                        }
                        case 0: {
                            for (ConnectionListener connectionListener : connectionListenerArray) {
                                connectionListener.connectionOpened(connectionEvent);
                            }
                            break;
                        }
                        case 1: {
                            for (ConnectionListener connectionListener : connectionListenerArray) {
                                connectionListener.connectionClosed(connectionEvent);
                            }
                            break;
                        }
                    }
                }
            };
            if (bl) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    static {
        LOCK = new Object();
        SERVICE_FORMAT = Pattern.compile("/*([^:]+):([^:]+)/([^:]+)");
        SID_FORMAT = Pattern.compile("([^:]+):([^:]+):([^:]+)");
    }

    private class ConnectionInfo {
        private String m_name;
        private ConnectionDescriptor m_origDesc;
        private ConnectionDescriptor m_authDesc;
        private Connection m_conn;

        ConnectionInfo(String string, ConnectionDescriptor connectionDescriptor) {
            this.setName(string);
            this.setDescriptor(connectionDescriptor);
        }

        synchronized Connection getConnection(boolean bl) throws CMException {
            if (this.m_conn == null && bl) {
                ArrayList arrayList = new ArrayList();
                ConnectRunnable connectRunnable = new ConnectRunnable();
                connectRunnable.setTitle("Connecting to " + this.m_name);
                try {
                    connectRunnable.start(true);
                    if (connectRunnable.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                }
                catch (ProgressException progressException) {
                    Throwable throwable = progressException.getCause();
                    if (throwable instanceof CMException) {
                        throw (CMException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw (RuntimeException)throwable;
                }
            }
            return this.m_conn;
        }

        Connection getConnection() throws CMException {
            return this.getConnection(true);
        }

        Connection getUniqueConnection() throws CMException {
            return this.createConnection();
        }

        void setName(String string) {
            this.m_name = string;
        }

        void setDescriptor(ConnectionDescriptor connectionDescriptor) {
            if (ModelUtil.areDifferent((Object)this.m_origDesc, (Object)connectionDescriptor)) {
                this.m_origDesc = connectionDescriptor;
                this.m_conn = null;
            }
        }

        void closeConnection() {
            if (this.m_conn != null) {
                try {
                    this.m_conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.clearConnectionInfo();
                Connections.this.fireConnectionEvent(new oracle.dbtools.raptor.connections.ConnectionEvent(1, this.m_name), true);
            }
        }

        Connection createConnection() throws CMException {
            ConnectionDescriptor connectionDescriptor = this.m_authDesc;
            if (connectionDescriptor == null) {
                connectionDescriptor = (ConnectionDescriptor)this.m_origDesc.clone();
                if (Connections.this.m_prompt != null) {
                    Connections.this.m_prompt.promptUser(connectionDescriptor);
                }
            }
            Connections.this.populateConnectionInfo(connectionDescriptor);
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionWrapper connectionWrapper = connectionManager.getConnection(connectionDescriptor, null);
            Connection connection = (Connection)connectionWrapper.getPresentation("JDBC");
            this.m_authDesc = connectionDescriptor;
            return connection;
        }

        void updateDescriptor(ConnectionDescriptor connectionDescriptor) {
            this.closeConnection();
            this.m_origDesc = connectionDescriptor;
        }

        private void clearConnectionInfo() {
            this.m_conn = null;
            this.m_authDesc = null;
        }

        private class ConnectRunnable
        extends ProgressRunnable {
            boolean m_canceled;

            private ConnectRunnable() {
            }

            protected Object doWork() throws Exception {
                return ConnectionInfo.this.createConnection();
            }

            protected void finish(Object object) {
                if (object instanceof Connection) {
                    ConnectionInfo.this.m_conn = (Connection)object;
                    Connections.this.fireConnectionEvent(new oracle.dbtools.raptor.connections.ConnectionEvent(0, ConnectionInfo.this.m_name), true);
                }
            }

            protected void doCancel() {
                super.doCancel();
                this.m_canceled = true;
            }

            boolean isCanceled() {
                return this.m_canceled;
            }
        }
    }

    private class L
    implements oracle.jdeveloper.cm.ConnectionListener {
        private L() {
        }

        public void connectionAdded(ConnectionEvent connectionEvent) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
            String string = connectionDescriptor.getConnectionName();
            Connections.this.m_conns.put(string, new ConnectionInfo(string, connectionDescriptor));
            Connections.this.fireConnectionEvent(new oracle.dbtools.raptor.connections.ConnectionEvent(2, string), true);
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
            String string = connectionDescriptor.getConnectionName();
            Connections.this.removeConnection(string);
            Connections.this.fireConnectionEvent(new oracle.dbtools.raptor.connections.ConnectionEvent(3, string), true);
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
            ConnectionDescriptor connectionDescriptor2 = (ConnectionDescriptor)connectionEvent.getData();
            String string = connectionDescriptor.getConnectionName();
            ConnectionInfo connectionInfo = Connections.this.findConnectionInfo(string);
            if (connectionInfo != null) {
                connectionInfo.updateDescriptor(connectionDescriptor2);
            }
            Connections.this.fireConnectionEvent(new oracle.dbtools.raptor.connections.ConnectionEvent(5, string), true);
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }
    }

    private class FactoryListener
    implements DBObjectProviderFactory.Listener {
        private Connection m_currConn;

        FactoryListener() {
            DBObjectProviderFactory.registerListener((DBObjectProviderFactory.Listener)this);
        }

        public void providerRemoved(Object object, DBObjectProvider dBObjectProvider) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerCreated(Object object, DBObjectProvider dBObjectProvider) {
            FactoryListener factoryListener = this;
            synchronized (factoryListener) {
                if (this.m_currConn != null) {
                    Connections.this.m_dbDescMap.put(this.m_currConn, object);
                    this.setCurrConn(null);
                }
            }
        }

        synchronized void setCurrConn(Connection connection) {
            this.m_currConn = connection;
        }
    }
}

