/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractFolderedXml {
    private Logger logger = Logger.getLogger(AbstractFolderedXml.class.getName());
    private XMLDocument _document;

    public abstract void openFolder(String var1, String var2, String var3, Node var4);

    public abstract void closeFolder();

    public abstract void newItem(Node var1);

    public void newNode(Node node) {
    }

    private void processFolder(Node node) {
        String string = XMLHelper.getNodeValue(node, "name");
        String string2 = XMLHelper.getNodeValue(node, "description");
        String string3 = XMLHelper.getNodeValue(node, "tip");
        this.openFolder(string, string2, string3, node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(nodeList.item(i));
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("item")) {
                this.newItem(nodeList.item(i));
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("description") || nodeList.item(i).getNodeName().equalsIgnoreCase("name") || nodeList.item(i).getNodeName() == null) continue;
            this.logger.fine("Folder:Unsupported node in report.xml:" + nodeList.item(i).getNodeName());
        }
    }

    private void processNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(nodeList.item(i));
                this.closeFolder();
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("item")) {
                this.newItem(nodeList.item(i));
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("#comment")) continue;
            this.newNode(nodeList.item(i));
        }
    }

    public void processXML(InputStream inputStream) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(inputStream);
        }
        catch (XMLParseException xMLParseException) {
            xMLParseException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this._document = dOMParser.getDocument();
        NodeList nodeList = this._document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.processNode(nodeList.item(i));
        }
    }

    public Document getDocument() {
        return this._document;
    }

    public static void main(String[] stringArray) {
    }
}

