/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.utils;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptMessagePage;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.log.MessagePage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class ScriptUtils {
    private static final Logger LOGGER = Logger.getLogger(ScriptUtils.class.getName());

    public static String runAsScript(String string, String string2, MessagePage messagePage) {
        return ScriptUtils.runAsScript(new StringReader(string), string2, messagePage);
    }

    public static String runAsScript(String string, String string2) {
        return ScriptUtils.runAsScript(new StringReader(string), string2, null);
    }

    public static String runAsScript(InputStream inputStream, String string, MessagePage messagePage) {
        return ScriptUtils.runAsScript(new InputStreamReader(inputStream), string, messagePage);
    }

    public static String runAsScript(InputStream inputStream, String string) {
        return ScriptUtils.runAsScript(new InputStreamReader(inputStream), string, null);
    }

    public static String runAsScript(Reader reader, String string) {
        return ScriptUtils.runAsScript(reader, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runAsScript(Reader reader, String string, MessagePage messagePage) {
        if (string == null) {
            string = ConnectionSelectorUI.getConnection(ConnectionArb.getString((int)159), ConnectionArb.getString((int)158), string, "CLASS_DATABASE", true);
        }
        if (string != null) {
            try {
                Ide.getWaitCursor().show();
                if (messagePage == null) {
                    ScriptMessagePage.getScriptMessagePage().clearAll();
                }
                ScriptRunner scriptRunner = new ScriptRunner(reader, Connections.getInstance().getConnection(string));
                scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                PipedInputStream pipedInputStream = new PipedInputStream();
                OutputRedirector outputRedirector = null;
                outputRedirector = messagePage == null ? new OutputRedirector(pipedInputStream, ScriptMessagePage.getScriptMessagePage()) : new OutputRedirector(pipedInputStream, messagePage);
                outputRedirector.setName("Report output reader");
                outputRedirector.start();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                scriptRunner.setOut(bufferedOutputStream);
                scriptRunner.run();
            }
            catch (CMException cMException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                Ide.getWaitCursor().hide();
            }
        }
        return string;
    }

    public static void runFileInDialog(File file, Connection connection, String string, String string2) {
        final File file2 = file;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        final String string3 = string2;
        final String string4 = string;
        basicEditorPane.setText("");
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;
            ScriptRunner sr = null;

            public void cancel() {
                this.sr.interrupt();
                this._isCanceled = true;
            }

            public Object doWork() {
                Object var1_1 = null;
                this.sr = new ScriptRunner("@" + file2.getAbsolutePath(), connection2);
                basicEditorPane.setEditable(true);
                this.sr.setScriptRunnerContext(new ScriptRunnerContext());
                this.sr.getScriptRunnerContext().setSubstitutionChar('^');
                this.sr.getScriptRunnerContext().setSubstitutionOn(false);
                this.sr.getScriptRunnerContext().setScanOn(false);
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                }
                catch (IOException iOException) {
                    LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
                }
                this.sr.setOut(bufferedOutputStream);
                this.sr.start();
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                outputRedirector.setName("Script output reader");
                outputRedirector.start();
                basicEditorPane.setEditable(false);
                while (this.sr.isAlive()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.sr.getScriptRunnerContext().getExited()) {
                    ScriptUtils.showError(basicEditorPane);
                } else if (string4 != null && string3 != null) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string3, (String)string4, null);
                }
                return var1_1;
            }

            public void finish(Object object) {
                file2.deleteOnExit();
                if (this._isCanceled) {
                    try {
                        connection2.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe("Could not rollback");
                    }
                }
            }

            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Installing", null, 500, iDelayedProgressRunnable, (Component)basicEditorPane);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    public static void showError(BasicEditorPane basicEditorPane) {
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)"Error", (int)2);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("");
            System.err.println("");
            System.err.println("Usage: java oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils username/password@tns @klr.sql define1 define2 define3 ...");
            System.err.println("");
            System.err.println("");
            System.exit(1);
        }
        String string = stringArray[0].substring(0, stringArray[0].indexOf("/"));
        String string2 = stringArray[0].substring(stringArray[0].indexOf("/") + 1, stringArray[0].indexOf("@"));
        String string3 = stringArray[0].substring(stringArray[0].indexOf("@") + 1);
        String string4 = "jdbc:oracle:thin:@" + string3;
        String string5 = null;
        string5 = stringArray[1].indexOf("@") == 0 ? stringArray[1].substring(1) : stringArray[1];
        File file = new File(string5);
        if (!file.exists() && string5.indexOf(".") == -1) {
            string5 = string5 + ".sql";
        }
        if (!file.exists() && string5.indexOf(".") == -1) {
            string5 = string5 + ".sql";
        }
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        for (int i = 2; i < stringArray.length; ++i) {
            scriptRunnerContext.getMap().put("" + (i - 1), stringArray[i]);
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string4, string, string2);
        connection.setAutoCommit(false);
        ScriptRunner scriptRunner = new ScriptRunner(new FileInputStream(string5), connection);
        scriptRunner.setScriptRunnerContext(scriptRunnerContext);
        scriptRunner.run();
    }
}

