/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;

public class ShowErrors
extends CommandListener {
    private static final String CMD = "show err";
    private static final String VERBOSE_CMD = "set errorswithlines";
    private static final String VERBOSE_CMD_NUM_LINES = "set errorswithlines num lines";
    private SQLCommand _lastCmd;

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (!sQLCommand.getSql().trim().toLowerCase().startsWith(CMD)) {
            this._lastCmd = sQLCommand;
        }
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        Object object;
        if (sQLCommand.getSql().trim().toLowerCase().startsWith(VERBOSE_CMD)) {
            object = sQLCommand.getSQLOrig().split(" ");
            if (((String[])object).length >= 3 && object[2].toLowerCase().trim().equals("on")) {
                scriptRunnerContext.putProperty(VERBOSE_CMD, Boolean.TRUE);
            } else {
                scriptRunnerContext.putProperty(VERBOSE_CMD, Boolean.FALSE);
            }
            if (((String[])object).length == 5) {
                scriptRunnerContext.putProperty(VERBOSE_CMD_NUM_LINES, Integer.parseInt(object[3]));
            }
        }
        if (sQLCommand.getSql().trim().toLowerCase().startsWith(CMD)) {
            object = (String)scriptRunnerContext.getProperty("sqldev.last.err.name");
            String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.type");
            if (object == null || string == null) {
                scriptRunnerContext.write("No Errors.\n");
                return true;
            }
            Map<String, String> map = DBUtil.getInstance().resolveName(connection, (String)object);
            if (string.toUpperCase().indexOf("BODY") > 0) {
                map.put("OBJECT_TYPE", map.get("OBJECT_TYPE") + " BODY");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(map.get("OBJECT_TYPE"));
            arrayList.add(map.get("OBJECT_NAME"));
            arrayList.add(map.get("OWNER"));
            String string2 = "select substr(line||'/'||position,0,10) linenum ,text from all_errors  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER and    attribute != 'WARNING' ";
            ResultSet resultSet = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            try {
                resultSet = DBUtil.getInstance().executeQuery(connection, string2, arrayList);
                while (resultSet.next()) {
                    arrayList2.add(resultSet.getString(1));
                    arrayList3.add(resultSet.getString(2));
                }
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.write(sQLException.getMessage());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.getStatement().close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if (arrayList2.size() > 0) {
                int n = 10;
                int n2 = 10;
                for (String string3 : arrayList2) {
                    if (string3.length() <= n) continue;
                    n = string3.length();
                }
                for (String string3 : arrayList3) {
                    if (string3.length() <= n2) continue;
                    n2 = string3.length();
                }
                n += 5;
                String string4 = "                             ";
                for (int i = 0; i < arrayList2.size(); ++i) {
                    int n3;
                    scriptRunnerContext.write((String)arrayList2.get(i) + string4.substring(0, n - ((String)arrayList2.get(i)).length()));
                    scriptRunnerContext.write((String)arrayList3.get(i) + "\n");
                    if (!((Boolean)scriptRunnerContext.getProperty(VERBOSE_CMD)).booleanValue()) continue;
                    Integer n4 = 1;
                    if (scriptRunnerContext.getProperty(VERBOSE_CMD_NUM_LINES) != null) {
                        n4 = (Integer)scriptRunnerContext.getProperty(VERBOSE_CMD_NUM_LINES);
                        n4 = n4 - 1;
                    }
                    String[] stringArray = this._lastCmd.getSQLOrig().split("\n");
                    int n5 = Integer.parseInt(((String)arrayList2.get(i)).substring(0, ((String)arrayList2.get(i)).indexOf("/")));
                    --n5;
                    int n6 = Integer.parseInt(((String)arrayList2.get(i)).substring(((String)arrayList2.get(i)).indexOf("/") + 1));
                    for (n3 = n4.intValue(); n3 >= 0; --n3) {
                        if (n5 - 1 - n3 < 0) continue;
                        scriptRunnerContext.write(n5 - n3 + "  " + stringArray[n5 - 1 - n3] + "\n");
                    }
                    if (n5 > 0 && n5 < stringArray.length) {
                        scriptRunnerContext.write(n5 + 1 + "* " + stringArray[n5] + "\n");
                        String string5 = "                                                                                                    ";
                        int n7 = (int)Math.round(Math.floor(n6 / 100));
                        String string6 = new String();
                        string6 = "" + n5 + "  ";
                        scriptRunnerContext.write(string5.substring(0, string6.length()));
                        boolean bl = false;
                        while (i < n7) {
                            scriptRunnerContext.write(string5);
                            ++i;
                        }
                        scriptRunnerContext.write(string5.substring(0, n6 % 100) + "^\n");
                    }
                    for (n3 = 1; n3 < n4 + 2; ++n3) {
                        if (n5 + n3 >= stringArray.length) continue;
                        scriptRunnerContext.write(n5 + 1 + n3 + "  " + stringArray[n5 + n3] + "\n");
                    }
                    scriptRunnerContext.write("\n\n");
                }
            } else {
                scriptRunnerContext.write("No Errors.\n");
            }
            return true;
        }
        return false;
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    private String[] getName(String string) {
        String[] stringArray = string.split("[ \n\r]");
        String string2 = null;
        String string3 = null;
        String string4 = "";
        if (stringArray[0].toLowerCase().equals("create")) {
            if (stringArray[1].toLowerCase().equals("or")) {
                if (string2.toLowerCase().equals("package") && stringArray[4].toLowerCase().equals("body")) {
                    string2 = stringArray[3] + " " + stringArray[4];
                    string3 = stringArray[5];
                    string4 = "YES";
                } else {
                    string2 = stringArray[3];
                    string3 = stringArray[4];
                }
            } else if (string2.toLowerCase().equals("package") && stringArray[2].toLowerCase().equals("body")) {
                string2 = stringArray[1] + " " + stringArray[2];
                string3 = stringArray[3];
                string4 = "YES";
            } else {
                string2 = stringArray[1];
                string3 = stringArray[2];
            }
        }
        String[] stringArray2 = new String[]{string2, string3, string4};
        return stringArray2;
    }
}

