/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;

public class SetTiming
extends CommandListener {
    private static final String TIMING = "set timing";
    private long start;

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (scriptRunnerContext.getProperty(TIMING) == Boolean.TRUE) {
            this.start = System.currentTimeMillis();
        }
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (scriptRunnerContext.getProperty(TIMING) == Boolean.TRUE && !sQLCommand.getSql().trim().toLowerCase().startsWith(TIMING)) {
            long l = System.currentTimeMillis();
            Object[] objectArray = new Object[]{l - this.start};
            String string = MessageFormat.format("{0}ms elapsed\n", objectArray);
            try {
                scriptRunnerContext.getOutputStream().write(string.getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (sQLCommand.getSql().trim().toLowerCase().startsWith(TIMING)) {
            String string = sQLCommand.getSql().trim().substring(sQLCommand.getSql().trim().lastIndexOf(" ")).trim();
            if (string.toLowerCase().equals("on")) {
                scriptRunnerContext.putProperty(TIMING, Boolean.TRUE);
            } else if (string.toLowerCase().equals("off")) {
                scriptRunnerContext.putProperty(TIMING, Boolean.FALSE);
            }
            return true;
        }
        return false;
    }
}

